/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;

public class UserOrgAction
extends Action {
    private static final Logger log = Logger.getLogger(UserOrgAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        log.debug((Object)("orgId: " + orgId));
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        if (orgId == null || orgId <= 0 || organisation == null) {
            request.setAttribute("errorName", (Object)"UserOrgAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.org.invalid"));
            return mapping.findForward("error");
        }
        String orgName = organisation.getName();
        log.debug((Object)("orgName: " + orgName));
        Organisation parentOrg = organisation.getParentOrganisation();
        if (parentOrg != null && !parentOrg.equals((Object)service.getRootOrganisation())) {
            request.setAttribute("pOrgId", (Object)parentOrg.getOrganisationId());
            request.setAttribute("pOrgName", (Object)parentOrg.getName());
        }
        Integer orgType = organisation.getOrganisationType().getOrganisationTypeId();
        request.setAttribute("orgType", (Object)orgType);
        DynaActionForm userOrgForm = (DynaActionForm)form;
        userOrgForm.set("orgId", (Object)orgId);
        userOrgForm.set("orgName", (Object)orgName);
        Object[] args = new String[]{"0"};
        request.setAttribute("numExistUsers", (Object)messageService.getMessage("label.number.of.users", args));
        request.setAttribute("numPotentialUsers", (Object)messageService.getMessage("label.number.of.potential.users", args));
        return mapping.findForward("userorg");
    }
}

