/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.HashUtil;

public class UserSaveAction
extends Action {
    private static Logger log = Logger.getLogger(UserSaveAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        ActionMessages errors = new ActionMessages();
        DynaActionForm userForm = (DynaActionForm)form;
        Integer orgId = (Integer)userForm.get("orgId");
        Integer userId = (Integer)userForm.get("userId");
        log.debug((Object)("orgId: " + orgId));
        Boolean edit = false;
        Boolean passwordChanged = true;
        SupportedLocale locale = (SupportedLocale)service.findById(SupportedLocale.class, (Serializable)((Integer)userForm.get("localeId")));
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)service.findById(AuthenticationMethod.class, (Serializable)((Integer)userForm.get("authenticationMethodId")));
        log.debug((Object)("locale: " + locale));
        log.debug((Object)("authenticationMethod:" + authenticationMethod));
        if (this.isCancelled(request)) {
            if (orgId == null || orgId == 0) {
                return mapping.findForward("usersearch");
            }
            request.setAttribute("org", (Object)orgId);
            return mapping.findForward("userlist");
        }
        User user = null;
        if (userId != 0) {
            edit = true;
            user = (User)service.findById(User.class, (Serializable)userId);
        }
        userForm.set("login", (Object)userForm.getString("login").trim());
        if (userForm.get("login") == null || userForm.getString("login").length() == 0) {
            errors.add("login", new ActionMessage("error.login.required"));
        }
        if (!(service.getUserByLogin(userForm.getString("login")) == null || user != null && StringUtils.equals((String)user.getLogin(), (String)userForm.getString("login")))) {
            errors.add("login", new ActionMessage("error.login.unique", (Object)("(" + userForm.getString("login") + ")")));
        }
        if (!StringUtils.equals((String)((String)userForm.get("password")), (String)((String)userForm.get("password2")))) {
            errors.add("password", new ActionMessage("error.newpassword.mismatch"));
        }
        if (userForm.get("password") == null || userForm.getString("password").trim().length() == 0) {
            passwordChanged = false;
            if (!edit.booleanValue()) {
                errors.add("password", new ActionMessage("error.password.required"));
            }
        }
        if (userForm.get("firstName") == null || userForm.getString("firstName").trim().length() == 0) {
            errors.add("firstName", new ActionMessage("error.firstname.required"));
        }
        if (userForm.get("lastName") == null || userForm.getString("lastName").trim().length() == 0) {
            errors.add("lastName", new ActionMessage("error.lastname.required"));
        }
        if (userForm.get("email") == null || userForm.getString("email").trim().length() == 0) {
            errors.add("email", new ActionMessage("error.email.required"));
        } else {
            Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
            Matcher m = p.matcher(userForm.getString("email"));
            if (!m.matches()) {
                errors.add("email", new ActionMessage("error.valid.email.required"));
            }
        }
        if (errors.isEmpty()) {
            if (edit.booleanValue()) {
                log.debug((Object)("editing userId: " + userId));
                if (passwordChanged.booleanValue()) {
                    service.auditPasswordChanged(user, "admin");
                    userForm.set("password", (Object)HashUtil.sha1((String)((String)userForm.get("password"))));
                } else {
                    userForm.set("password", (Object)user.getPassword());
                }
                BeanUtils.copyProperties((Object)user, (Object)userForm);
                user.setLocale(locale);
                user.setAuthenticationMethod(authenticationMethod);
                service.save((Object)user);
            } else {
                user = new User();
                userForm.set("password", (Object)HashUtil.sha1((String)((String)userForm.get("password"))));
                BeanUtils.copyProperties((Object)user, (Object)userForm);
                log.debug((Object)("creating user... new login: " + user.getLogin()));
                if (errors.isEmpty()) {
                    user.setFlashTheme(service.getDefaultFlashTheme());
                    user.setHtmlTheme(service.getDefaultHtmlTheme());
                    user.setDisabledFlag(Boolean.valueOf(false));
                    user.setCreateDate(new Date());
                    user.setAuthenticationMethod((AuthenticationMethod)service.findByProperty(AuthenticationMethod.class, "authenticationMethodName", (Object)"LAMS-Database").get(0));
                    user.setUserId(null);
                    user.setLocale(locale);
                    service.save((Object)user);
                    service.auditUserCreated(user, "admin");
                    log.debug((Object)("user: " + user.toString()));
                }
            }
        }
        if (errors.isEmpty()) {
            if (orgId == null || orgId == 0) {
                return mapping.findForward("usersearch");
            }
            if (edit.booleanValue()) {
                request.setAttribute("org", (Object)orgId);
                return mapping.findForward("userlist");
            }
            request.setAttribute("orgId", (Object)orgId);
            request.setAttribute("userId", (Object)user.getUserId());
            return mapping.findForward("userroles");
        }
        this.saveErrors(request, errors);
        request.setAttribute("orgId", (Object)orgId);
        return mapping.findForward("user");
    }
}

