/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;

public class UserSearchAction
extends Action {
    private static Logger log = Logger.getLogger(UserSearchAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (service == null) {
            service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        }
        if (messageService == null) {
            messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        }
        DynaActionForm userSearchForm = (DynaActionForm)form;
        if (!request.isUserInRole("SYSADMIN") && !service.isUserGlobalGroupAdmin()) {
            log.debug((Object)"user not sysadmin or global group admin");
            ActionMessages errors = new ActionMessages();
            errors.add("authorisation", new ActionMessage("error.authorisation"));
            this.saveErrors(request, errors);
            request.setAttribute("isSysadmin", (Object)false);
            return mapping.findForward("usersearchlist");
        }
        Boolean showAll = (Boolean)userSearchForm.get("showAll");
        Boolean searched = (Boolean)userSearchForm.get("searched");
        String term = userSearchForm.getString("term").trim();
        if (searched.booleanValue()) {
            List userList = new ArrayList();
            if (showAll.booleanValue()) {
                HashMap<String, Boolean> objectProperties = new HashMap<String, Boolean>();
                objectProperties.put("disabledFlag", false);
                userList = service.findByProperties(User.class, objectProperties);
            } else {
                userList = service.searchUserSingleTerm(term);
            }
            if (userList.isEmpty()) {
                ActionMessages messages = new ActionMessages();
                messages.add("results", new ActionMessage("msg.results.none"));
                this.saveMessages(request, messages);
            }
            request.setAttribute("userList", userList);
            Object[] args = new String[]{new Integer(userList.size()).toString()};
            request.setAttribute("numUsers", (Object)messageService.getMessage("label.number.of.users", args));
        }
        userSearchForm.set("showAll", (Object)false);
        userSearchForm.set("searched", (Object)true);
        return mapping.findForward("usersearchlist");
    }
}

