/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.dto.V1OrgRightDTO;
import org.lamsfoundation.lams.admin.web.dto.V1OrganisationDTO;
import org.lamsfoundation.lams.admin.web.dto.V1UserDTO;
import org.lamsfoundation.lams.admin.web.form.ImportV1ContentsForm;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportV1ContentsSaveAction
extends Action {
    private static Logger log = Logger.getLogger(ImportV1ContentsSaveAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            this.removeSessionVars(request);
            return mapping.findForward("sysadmin");
        }
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        ArrayList<V1UserDTO> users = (ArrayList<V1UserDTO>)request.getSession().getAttribute("users");
        List orgs = (List)request.getSession().getAttribute("orgs");
        this.removeSessionVars(request);
        ImportV1ContentsForm importV1ContentsForm = (ImportV1ContentsForm)form;
        String[] sids = importV1ContentsForm.getOrgSids();
        List<String> orgSids = sids == null ? new ArrayList<String>() : Arrays.asList(sids);
        sids = importV1ContentsForm.getSessSids();
        List<String> sessSids = sids == null ? new ArrayList<String>() : Arrays.asList(sids);
        boolean onlyMembers = importV1ContentsForm.getOnlyMembers();
        SupportedLocale locale = LanguageUtil.getDefaultLocale();
        OrganisationType courseType = (OrganisationType)service.findById(OrganisationType.class, (Serializable)OrganisationType.COURSE_TYPE);
        OrganisationState activeState = (OrganisationState)service.findById(OrganisationState.class, (Serializable)OrganisationState.ACTIVE);
        Integer userID = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        ArrayList<V1UserDTO> alreadyExists = new ArrayList<V1UserDTO>();
        if (onlyMembers) {
            ArrayList<V1UserDTO> createdUsers = new ArrayList<V1UserDTO>();
            for (V1UserDTO user : users) {
                if (!this.isUserMember(user, orgSids, sessSids)) continue;
                boolean created = this.createUser(user, locale);
                if (!created) {
                    alreadyExists.add(user);
                    continue;
                }
                createdUsers.add(user);
            }
            users = createdUsers;
        } else {
            for (V1UserDTO user : users) {
                boolean created = this.createUser(user, locale);
                if (created) continue;
                alreadyExists.add(user);
            }
        }
        HashMap<String, Integer> orgIdsMap = new HashMap<String, Integer>();
        for (V1OrganisationDTO org : orgs) {
            if (StringUtils.equals((String)org.getAccountOrganisation(), (String)"1") ? !orgSids.contains(org.getSid()) : StringUtils.equals((String)org.getAccountOrganisation(), (String)"0") && !sessSids.contains(org.getSid())) continue;
            Organisation v2org = this.createOrg(org, locale, courseType, activeState, userID);
            orgIdsMap.put(org.getSid(), v2org.getOrganisationId());
        }
        for (V1UserDTO v1user : users) {
            User user = service.getUserByLogin(v1user.getLogin());
            if (v1user.getRoleIds().contains("2")) {
                ArrayList<String> roles = new ArrayList<String>();
                roles.add(Role.ROLE_SYSADMIN.toString());
                service.setRolesForUserOrganisation(user, service.getRootOrganisation().getOrganisationId(), roles);
            }
            for (V1OrgRightDTO v1orgRight : v1user.getOrgRights()) {
                if (orgIdsMap.get(v1orgRight.getOrgSid()) == null) continue;
                List<String> roles = this.getV2RoleIds(v1user.getRoleIds(), v1orgRight);
                service.setRolesForUserOrganisation(user, (Integer)orgIdsMap.get(v1orgRight.getOrgSid()), roles);
            }
        }
        MessageService messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Object[] args = new String[]{String.valueOf(users.size()), String.valueOf(orgIdsMap.size())};
        request.setAttribute("msgNumCreated", (Object)messageService.getMessage("msg.importv1.created", args));
        request.setAttribute("alreadyExists", alreadyExists);
        return mapping.findForward("importv1result");
    }

    private List<String> getV2RoleIds(List<String> roleIds, V1OrgRightDTO orgRight) {
        ArrayList<String> newRoleIds = new ArrayList<String>();
        for (String roleId : roleIds) {
            if (StringUtils.equals((String)roleId, (String)"1")) {
                if (!StringUtils.equals((String)orgRight.getUserRight(), (String)"2")) continue;
                newRoleIds.add(Role.ROLE_GROUP_ADMIN.toString());
                continue;
            }
            if (StringUtils.equals((String)roleId, (String)"5")) {
                newRoleIds.add(Role.ROLE_AUTHOR.toString());
                continue;
            }
            if (StringUtils.equals((String)roleId, (String)"4")) {
                if (StringUtils.equals((String)orgRight.getUserRight(), (String)"0")) continue;
                newRoleIds.add(Role.ROLE_MONITOR.toString());
                continue;
            }
            if (!StringUtils.equals((String)roleId, (String)"3")) continue;
            newRoleIds.add(Role.ROLE_LEARNER.toString());
        }
        return newRoleIds;
    }

    private void removeSessionVars(HttpServletRequest request) {
        request.getSession().removeAttribute("users");
        request.getSession().removeAttribute("orgs");
        request.getSession().removeAttribute("ImportV1ContentsForm");
    }

    private void createUserAuditLog(User user) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")", user.getFullName()};
        String message = AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("audit.user.create", args);
        AdminServiceProxy.getAuditService(this.getServlet().getServletContext()).log("admin", message);
    }

    private boolean createUser(V1UserDTO user, SupportedLocale locale) throws Exception {
        if (service.getUserByLogin(user.getLogin()) != null) {
            return false;
        }
        User newUser = new User();
        BeanUtils.copyProperties((Object)newUser, (Object)user);
        newUser.setPassword(HashUtil.sha1((String)user.getLogin()));
        newUser.setChangePassword(Boolean.valueOf(true));
        newUser.setFlashTheme(service.getDefaultFlashTheme());
        newUser.setHtmlTheme(service.getDefaultHtmlTheme());
        newUser.setDisabledFlag(Boolean.valueOf(false));
        newUser.setCreateDate(new Date());
        newUser.setAuthenticationMethod((AuthenticationMethod)service.findByProperty(AuthenticationMethod.class, "authenticationMethodName", (Object)"LAMS-Database").get(0));
        newUser.setUserId(null);
        newUser.setLocale(locale);
        service.save((Object)newUser);
        this.createUserAuditLog(newUser);
        return true;
    }

    private boolean isUserMember(V1UserDTO user, List<String> orgSids, List<String> sessSids) {
        List<V1OrgRightDTO> orgRights = user.getOrgRights();
        if (orgRights != null) {
            for (V1OrgRightDTO orgRight : orgRights) {
                if (!orgSids.contains(orgRight.getOrgSid()) && !sessSids.contains(orgRight.getOrgSid())) continue;
                return true;
            }
        }
        return false;
    }

    private Organisation createOrg(V1OrganisationDTO org, SupportedLocale locale, OrganisationType courseType, OrganisationState activeState, Integer userID) throws Exception {
        Organisation newOrg = new Organisation();
        BeanUtils.copyProperties((Object)newOrg, (Object)org);
        newOrg.setParentOrganisation(service.getRootOrganisation());
        newOrg.setOrganisationType(courseType);
        newOrg.setOrganisationState(activeState);
        newOrg.setLocale(locale);
        newOrg = service.saveOrganisation(newOrg, userID);
        this.createOrgAuditLog(newOrg);
        return newOrg;
    }

    private void createOrgAuditLog(Organisation org) {
        Object[] args = new String[]{org.getName() + "(" + org.getOrganisationId() + ")", org.getOrganisationType().getName()};
        String message = AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("audit.organisation.create", args);
        AdminServiceProxy.getAuditService(this.getServlet().getServletContext()).log("admin", message);
    }
}

