/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.dto.BulkUpdateResultDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.service.LdapService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LdapConfigAction
extends Action {
    private static Logger log = Logger.getLogger(LdapConfigAction.class);
    private static IUserManagementService service;
    private static LdapService ldapService;
    private static MessageService messageService;

    private IUserManagementService getService() {
        if (service == null) {
            service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        }
        return service;
    }

    private LdapService getLdapService() {
        if (ldapService == null) {
            ldapService = AdminServiceProxy.getLdapService(this.getServlet().getServletContext());
        }
        return ldapService;
    }

    private MessageService getMessageService() {
        if (messageService == null) {
            messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        }
        return messageService;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String action = WebUtil.readStrParam((HttpServletRequest)request, (String)"action", (boolean)true);
        if (action != null) {
            if (StringUtils.equals((String)action, (String)"sync")) {
                return this.sync(mapping, form, request, response);
            }
            if (StringUtils.equals((String)action, (String)"waiting")) {
                return this.waiting(mapping, form, request, response);
            }
            if (StringUtils.equals((String)action, (String)"results")) {
                return this.results(mapping, form, request, response);
            }
        }
        int numLdapUsers = this.getNumLdapUsers();
        request.setAttribute("numLdapUsersMsg", (Object)this.getNumLdapUsersMsg(numLdapUsers));
        return mapping.findForward("ldap");
    }

    public ActionForward sync(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sessionId = SessionManager.getSession().getId();
        Thread t = new Thread(new LdapSyncThread(sessionId));
        t.start();
        request.setAttribute("wait", (Object)this.getMessageService().getMessage("msg.ldap.synchronise.wait"));
        return mapping.findForward("ldap");
    }

    public ActionForward waiting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("wait", (Object)this.getMessageService().getMessage("msg.ldap.synchronise.wait"));
        return mapping.findForward("ldap");
    }

    public ActionForward results(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession ss = SessionManager.getSession();
        BulkUpdateResultDTO dto = (BulkUpdateResultDTO)ss.getAttribute("syncResults");
        int numLdapUsers = this.getNumLdapUsers();
        request.setAttribute("numLdapUsersMsg", (Object)this.getNumLdapUsersMsg(numLdapUsers));
        request.setAttribute("numSearchResults", (Object)this.getNumSearchResultsUsersMsg(dto.getNumSearchResults()));
        request.setAttribute("numLdapUsersCreated", (Object)this.getNumCreatedUsersMsg(dto.getNumUsersCreated()));
        request.setAttribute("numLdapUsersUpdated", (Object)this.getNumUpdatedUsersMsg(dto.getNumUsersUpdated()));
        request.setAttribute("numLdapUsersDisabled", (Object)this.getNumDisabledUsersMsg(dto.getNumUsersDisabled()));
        request.setAttribute("messages", (Object)dto.getMessages());
        request.setAttribute("done", (Object)this.getMessageService().getMessage("msg.done"));
        ss.removeAttribute("syncResults");
        return mapping.findForward("ldap");
    }

    private int getNumLdapUsers() {
        Integer count = this.getService().getCountUsers(AuthenticationMethod.LDAP);
        return count != null ? count : -1;
    }

    private String getNumLdapUsersMsg(int numLdapUsers) {
        Object[] args = new String[]{String.valueOf(numLdapUsers)};
        return this.getMessageService().getMessage("msg.num.ldap.users", args);
    }

    private String getNumSearchResultsUsersMsg(int searchResults) {
        Object[] args = new String[]{String.valueOf(searchResults)};
        return this.getMessageService().getMessage("msg.num.search.results.users", args);
    }

    private String getNumCreatedUsersMsg(int created) {
        Object[] args = new String[]{String.valueOf(created)};
        return this.getMessageService().getMessage("msg.num.created.users", args);
    }

    private String getNumUpdatedUsersMsg(int updated) {
        Object[] args = new String[]{String.valueOf(updated)};
        return this.getMessageService().getMessage("msg.num.updated.users", args);
    }

    private String getNumDisabledUsersMsg(int disabled) {
        Object[] args = new String[]{String.valueOf(disabled)};
        return this.getMessageService().getMessage("msg.num.disabled.users", args);
    }

    private class LdapSyncThread
    implements Runnable {
        private String sessionId;

        public LdapSyncThread(String sessionId) {
            this.sessionId = sessionId;
        }

        public void run() {
            log.info((Object)"=== Beginning LDAP user sync ===");
            long start = System.currentTimeMillis();
            BulkUpdateResultDTO dto = LdapConfigAction.this.getLdapService().bulkUpdate();
            long end = System.currentTimeMillis();
            log.info((Object)"=== Finished LDAP user sync ===");
            log.info((Object)("Bulk update took " + (end - start) / 1000L + " seconds."));
            SessionManager.getSession((String)this.sessionId).setAttribute("syncResults", (Object)dto);
        }
    }
}

