/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class UserBasicListAction
extends Action {
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserDTO userDto;
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        HttpSession session = SessionManager.getSession();
        if (session != null && (userDto = (UserDTO)session.getAttribute("user")) != null) {
            Integer userId = userDto.getUserID();
            Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
            String potential = WebUtil.readStrParam((HttpServletRequest)request, (String)"potential", (boolean)true);
            if (orgId != null) {
                if (!StringUtils.equals((String)potential, (String)"1")) {
                    List users = service.getUsersFromOrganisation(orgId);
                    request.setAttribute("users", (Object)users);
                } else {
                    Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
                    if (org != null) {
                        Organisation group = org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) ? org.getParentOrganisation() : org;
                        List users = new ArrayList();
                        if (request.isUserInRole("SYSADMIN") || service.isUserGlobalGroupAdmin()) {
                            users = service.getAllUsers(org.getOrganisationId());
                        } else if (service.isUserInRole(userId, group.getOrganisationId(), "GROUP ADMIN") || service.isUserInRole(userId, group.getOrganisationId(), "GROUP MANAGER")) {
                            if (group.getCourseAdminCanBrowseAllUsers().booleanValue()) {
                                users = service.getAllUsers(org.getOrganisationId());
                            } else if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
                                users = service.getUsersFromOrganisation(group.getOrganisationId(), orgId);
                            }
                        }
                        request.setAttribute("users", users);
                    }
                }
            }
        }
        return mapping.findForward("basiclist");
    }
}

