/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.cxutil;

import blackboard.admin.cxutil.CSResource;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.platform.contentsystem.manager.DocumentManagerEx;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSResourceStatusMap {
    private final Map<CSResource.CSStatus, List<CSResource>> _csLinkStatusMap = new HashMap<CSResource.CSStatus, List<CSResource>>();

    public void addCsLinkStatus(CSResultSet resultSet) {
        if (resultSet == null || !resultSet.hasLinkStatusData()) {
            return;
        }
        Map<CSResource.CSStatus, Map<String, CSResource>> newMap = resultSet.getResultMap();
        for (Map.Entry<CSResource.CSStatus, Map<String, CSResource>> entry : newMap.entrySet()) {
            CSResource.CSStatus status = entry.getKey();
            Map<String, CSResource> resourceMap = entry.getValue();
            if (resourceMap == null || resourceMap.isEmpty()) continue;
            List<CSResource> masterList = this._csLinkStatusMap.get((Object)status);
            if (masterList == null) {
                masterList = new ArrayList<CSResource>();
                this._csLinkStatusMap.put(status, masterList);
            }
            masterList.addAll(resourceMap.values());
        }
    }

    public List<CSResource> getCsLinkStatusList(CSResource.CSStatus status) {
        return this._csLinkStatusMap.get((Object)status);
    }

    public List<String> getCsLinkStatusMessage(CSResource.CSStatus status) {
        if (!this._csLinkStatusMap.containsKey((Object)status)) {
            return null;
        }
        ArrayList<String> resourceStatusMessageList = new ArrayList<String>();
        List<CSResource> resourceStatusList = this._csLinkStatusMap.get((Object)status);
        if (resourceStatusList != null && !resourceStatusList.isEmpty()) {
            BbResourceBundle bundle = BundleManagerFactory.getInstance().getBundle("content_exchange");
            for (CSResource resource : resourceStatusList) {
                String message;
                if (resource == null || !StringUtil.notEmpty((String)(message = resource.getStatusMessage(bundle)))) continue;
                resourceStatusMessageList.add(message);
            }
        }
        return resourceStatusMessageList;
    }

    public static void registerLinks(List<CSResource> resourceList) {
        if (null == resourceList) {
            return;
        }
        DocumentManagerEx docMgr = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
        for (CSResource link : resourceList) {
            docMgr.registerResourceLink(link.getCourseId(), link.getParentId(), link.getXythosId(), link.getStorageType());
        }
    }
}

