/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.cxutil;

import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResourceStatusMap;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.base.FormattedText;
import blackboard.data.content.Content;
import blackboard.data.content.ContentFolder;
import blackboard.data.course.Course;
import blackboard.data.syllabus.CourseSyllabus;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.syllabus.CourseSyllabusManager;
import blackboard.platform.syllabus.CourseSyllabusXmlBuilder;
import blackboard.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.SAXException;

public class SyllabusContentCopier {
    private ContentFolder _destination;
    private Course _destinationCourse;
    private Course _originalCourse;
    private Map<String, String> _oldToNewXythosIdMapping;
    private final CSResourceStatusMap _csLinkStatusMap;
    private boolean _copyFiles;

    public SyllabusContentCopier(Course originalCourse, Course destinationCourse, ContentFolder destination, Map<String, String> oldToNewXythosIdMapping, CSResourceStatusMap csLinkStatusMap, boolean copyFiles) {
        this._originalCourse = originalCourse;
        this._destinationCourse = destinationCourse;
        this._destination = destination;
        this._oldToNewXythosIdMapping = oldToNewXythosIdMapping;
        this._csLinkStatusMap = csLinkStatusMap;
        this._copyFiles = copyFiles;
    }

    public void copyEmbeddedLinks(String sourceCourseHomeDir, String destCourseHomeDir, Content copiedContentSyllabus) throws Exception {
        try {
            CourseSyllabusXmlBuilder builder = new CourseSyllabusXmlBuilder();
            File copiedSyllabusFile = new CourseSyllabusManager().getSyllabusFile(this._destinationCourse, copiedContentSyllabus.getId());
            CourseSyllabus copiedCourseSyllabus = builder.loadCourseSyllabus(copiedSyllabusFile);
            FormattedText description = this.processEmbeddedLinks(copiedContentSyllabus, copiedCourseSyllabus.getDescription(), sourceCourseHomeDir, destCourseHomeDir);
            copiedCourseSyllabus.setDescription(description);
            FormattedText learningObjectives = this.processEmbeddedLinks(copiedContentSyllabus, copiedCourseSyllabus.getLearningObjectives(), sourceCourseHomeDir, destCourseHomeDir);
            copiedCourseSyllabus.setLearningObjectives(learningObjectives);
            FormattedText requiredMaterials = this.processEmbeddedLinks(copiedContentSyllabus, copiedCourseSyllabus.getRequiredMaterials(), sourceCourseHomeDir, destCourseHomeDir);
            copiedCourseSyllabus.setRequiredMaterials(requiredMaterials);
            builder.createXmlFile(copiedCourseSyllabus, copiedSyllabusFile);
        }
        catch (SAXException e) {
            LogServiceFactory.getInstance().logError("Cannot build syllabus.xml for " + copiedContentSyllabus.getTitle() + " under " + this._destination.getTitle(), (Throwable)e);
        }
        catch (IOException e) {
            LogServiceFactory.getInstance().logError("Cannot save syllabus.xml tp filesystem for " + copiedContentSyllabus.getTitle() + " under " + this._destination.getTitle(), (Throwable)e);
        }
    }

    private FormattedText processEmbeddedLinks(Content copiedSyllabusContent, FormattedText originalFormattedText, String sourceCourseHomeDir, String destCourseHomeDir) throws Exception {
        if (StringUtil.isEmpty((FormattedText)originalFormattedText)) {
            return originalFormattedText;
        }
        CSResultSet resultSet = new CSResultSet(this._destinationCourse.getId(), copiedSyllabusContent.getId(), copiedSyllabusContent.getTitle(), "cx.import.copy.link.component.name.content.item");
        String newVtbeText = CSFileCopyHandlerFactory.getInstance().parseVTBEText(originalFormattedText.getText(), sourceCourseHomeDir, destCourseHomeDir, this._destinationCourse, this._originalCourse, this._copyFiles, this._oldToNewXythosIdMapping, resultSet, true, false, null);
        FormattedText newFormattedText = new FormattedText(newVtbeText, originalFormattedText.getType());
        this._csLinkStatusMap.addCsLinkStatus(resultSet);
        return newFormattedText;
    }
}

