/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data.course;

import blackboard.admin.data.FieldValidationUtility;
import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbEnum;
import blackboard.data.IBbObject;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.data.course.Classification;
import blackboard.data.course.Course;
import blackboard.data.course.CourseManagerEx;
import blackboard.data.datasource.BbDataSource;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.api.PublicAPI;
import java.text.MessageFormat;
import java.util.regex.Matcher;

@PublicAPI
public abstract class AdminCourse
extends Course
implements IAdminObject {
    private static final long serialVersionUID = 6689335688123695628L;
    private static final char[] validChars = new char[]{'_', '.', '-'};

    public static char[] getValidChars() {
        return (char[])validChars.clone();
    }

    public AdminCourse() {
        this._bbAttributes.removeBbAttribute("RowStatus");
        this._bbAttributes.setBbEnum("NavStyle", null);
        this._bbAttributes.setString("DataSourceBatchUid", null);
        this._bbAttributes.setString("ReplacementBatchUid", null);
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)IAdminObject.RowStatus.DEFAULT);
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)IAdminObject.RecStatus.DEFAULT);
        this._bbAttributes.setString("TemplateBatchUid", null);
        this._bbAttributes.setString("ClassificationBatchUid", null);
        this._bbAttributes.setBoolean("AssociationRefreshRequired", false);
    }

    public void setServiceLevel(Course.ServiceLevel eLevel) {
    }

    @Override
    public IAdminObject.RowStatus getRowStatus() {
        return (IAdminObject.RowStatus)this._bbAttributes.getBbEnum("RowStatus");
    }

    @Override
    public void setRowStatus(IAdminObject.RowStatus eRowStatus) {
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)eRowStatus);
    }

    @Override
    public IAdminObject.RecStatus getRecStatus() {
        return (IAdminObject.RecStatus)this._bbAttributes.getBbEnum("RecStatus");
    }

    @Override
    public void setRecStatus(IAdminObject.RecStatus eRecStatus) {
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)eRecStatus);
    }

    @Override
    public String getDataSourceBatchUid() {
        return this._bbAttributes.getSafeString("DataSourceBatchUid");
    }

    @Override
    public void setDataSourceBatchUid(String batchUid) {
        this._bbAttributes.setString("DataSourceBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("DataSourceId").setIsDirty(false);
    }

    @Override
    public void setDataSourceId(Id iDataSourceId) {
        this._bbAttributes.setId("DataSourceId", iDataSourceId);
        this._bbAttributes.getBbAttribute("DataSourceBatchUid").setIsDirty(false);
    }

    public String getReplacementBatchUid() {
        return this._bbAttributes.getSafeString("ReplacementBatchUid");
    }

    public void setReplacementBatchUid(String batchUid) {
        this._bbAttributes.setString("ReplacementBatchUid", batchUid);
    }

    public String getTemplateBatchUid() {
        return this._bbAttributes.getSafeString("TemplateBatchUid");
    }

    public void setTemplateBatchUid(String batchUid) {
        this._bbAttributes.setString("TemplateBatchUid", batchUid);
    }

    public String getClassificationBatchUid() {
        return this._bbAttributes.getSafeString("ClassificationBatchUid");
    }

    public void setClassificationBatchUid(String batchUid) {
        this._bbAttributes.setString("ClassificationBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("ClassificationId").setIsDirty(false);
    }

    public void setClassificationId(Id iClassificationId) {
        this._bbAttributes.setId("ClassificationId", iClassificationId);
        this._bbAttributes.getBbAttribute("ClassificationBatchUid").setIsDirty(false);
    }

    public void setClassification(Classification classif) {
        this._bbAttributes.setBbObject("Classification", (IBbObject)classif);
        this.setClassificationId(classif.getId());
    }

    public void setAssociationRefreshRequired(boolean associationRefreshRequired) {
        this._bbAttributes.setBoolean("AssociationRefreshRequired", associationRefreshRequired);
    }

    public boolean isAssociationRefreshRequired() {
        return this._bbAttributes.getSafeBoolean("AssociationRefreshRequired");
    }

    @Override
    public void validate() throws ValidationException {
        Id dsId;
        Matcher matcher;
        String strCourseId;
        ValidationException ve = new ValidationException();
        String colName = "";
        Object[] args = new Object[]{colName};
        String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
        MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
        colName = "DataSourceBatchUid";
        args[0] = colName;
        String dataSourceBatchUid = this.getDataSourceBatchUid();
        if (!FieldValidationUtility.isValidString(dataSourceBatchUid, true, 256) || FieldValidationUtility.containsInvalidCharacters(dataSourceBatchUid, CourseManagerEx.COURSE_ID_PATTERN)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Title";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getTitle(), true, 255)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "BatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (this.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            colName = "ReplacementBatchUid";
            args[0] = colName;
            if (!FieldValidationUtility.isValidString(this.getReplacementBatchUid(), false, 256)) {
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
            }
        }
        colName = "CourseId";
        args[0] = colName;
        if (super.getServiceLevelType() != Course.ServiceLevel.FULL) {
            colName = "CourseId";
            args[0] = colName;
        }
        if (!FieldValidationUtility.isValidString(strCourseId = this.getCourseId(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (strCourseId != null && (matcher = CourseManagerEx.COURSE_ID_PATTERN.matcher(strCourseId)).find()) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Description";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDescription(), true, 4000)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "InstitutionName";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getInstitutionName(), true, 255)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (!Id.isValid((Id)(dsId = this.getDataSourceId()))) {
            this.setDataSourceId(Id.toId((DataType)BbDataSource.DATA_TYPE, (long)2L));
        }
        if (ve.getWarnings().size() > 0) {
            throw ve;
        }
    }
}

