/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data.course;

import blackboard.admin.data.FieldValidationUtility;
import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.IMembership;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbEnum;
import blackboard.base.BbList;
import blackboard.data.BbLink;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.data.course.CourseMembership;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.platform.api.PublicAPI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@PublicAPI
public abstract class Membership
extends CourseMembership
implements IMembership {
    private static final long serialVersionUID = 1151092076553430183L;

    protected Membership() {
        this._bbAttributes.removeBbAttribute("RowStatus");
        this._bbAttributes.setString("GroupBatchUid", null);
        this._bbAttributes.setString("PersonBatchUid", null);
        this._bbAttributes.setString("DataSourceBatchUid", null);
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)IAdminObject.RecStatus.DEFAULT);
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)IAdminObject.RowStatus.DEFAULT);
        this._bbAttributes.setInteger("idtype", 1);
        this._bbAttributes.setString("InheritedFromGroupBatchUid", null);
    }

    @Override
    public IAdminObject.RowStatus getRowStatus() {
        return (IAdminObject.RowStatus)this._bbAttributes.getBbEnum("RowStatus");
    }

    @Override
    public void setRowStatus(IAdminObject.RowStatus eRowStatus) {
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)eRowStatus);
    }

    @Override
    public IAdminObject.RecStatus getRecStatus() {
        return (IAdminObject.RecStatus)this._bbAttributes.getBbEnum("RecStatus");
    }

    @Override
    public void setRecStatus(IAdminObject.RecStatus eRecStatus) {
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)eRecStatus);
    }

    @Override
    public String getDataSourceBatchUid() {
        return this._bbAttributes.getSafeString("DataSourceBatchUid");
    }

    @Override
    public void setDataSourceBatchUid(String batchUid) {
        this._bbAttributes.setString("DataSourceBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("DataSourceId").setIsDirty(false);
    }

    @Override
    public void setDataSourceId(Id iDataSourceId) {
        this._bbAttributes.setId("DataSourceId", iDataSourceId);
        this._bbAttributes.getBbAttribute("DataSourceBatchUid").setIsDirty(false);
    }

    public String getPersonBatchUid() {
        return this._bbAttributes.getSafeString("PersonBatchUid");
    }

    public void setPersonBatchUid(String batchUid) {
        this._bbAttributes.setString("PersonBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("UserId").setIsDirty(false);
    }

    public void setUserId(Id iUserId) {
        this._bbAttributes.setId("UserId", iUserId);
        this._bbAttributes.getBbAttribute("PersonBatchUid").setIsDirty(false);
    }

    protected String getGroupBatchUid() {
        return this._bbAttributes.getSafeString("GroupBatchUid");
    }

    protected Id getGroupId() {
        return super.getCourseId();
    }

    protected void setGroupBatchUid(String batchUid) {
        this._bbAttributes.setString("GroupBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("CourseId").setIsDirty(false);
    }

    protected void setGroupId(Id iGroupId) {
        this._bbAttributes.setId("CourseId", iGroupId);
        this._bbAttributes.getBbAttribute("GroupBatchUid").setIsDirty(false);
    }

    public String getInheritedFromGroupBatchUid() {
        return this._bbAttributes.getSafeString("InheritedFromGroupBatchUid");
    }

    protected Id getInheritedFromGroupId() {
        return super.getChildCourseId();
    }

    public void setInheritedFromGroupBatchUid(String batchUid) {
        this._bbAttributes.setString("InheritedFromGroupBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("ChildCourseId").setIsDirty(false);
    }

    protected void setInheritedFromGroupId(Id iGroupId) {
        this._bbAttributes.setId("ChildCourseId", iGroupId);
        this._bbAttributes.getBbAttribute("InheritedFromGroupBatchUid").setIsDirty(false);
    }

    public void setLinkUrl1(String val) {
        this.setLinkUrl(1, val);
    }

    public void setLinkDescription1(String val) {
        this.setLinkDescription(1, val);
    }

    public void setLinkName1(String val) {
        this.setLinkName(1, val);
    }

    public void setLinkName2(String val) {
        this.setLinkName(2, val);
    }

    public void setLinkUrl2(String val) {
        this.setLinkUrl(2, val);
    }

    public void setLinkDescription2(String val) {
        this.setLinkDescription(2, val);
    }

    public void setLinkName3(String val) {
        this.setLinkName(3, val);
    }

    public void setLinkUrl3(String val) {
        this.setLinkUrl(3, val);
    }

    public void setLinkDescription3(String val) {
        this.setLinkDescription(3, val);
    }

    @Override
    public void validate() throws ValidationException {
        ValidationException ve = new ValidationException();
        String colName = "";
        Object[] args = new Object[]{colName};
        String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
        MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
        colName = "DataSourceBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDataSourceBatchUid(), true, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "PersonBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getPersonBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "GroupBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getGroupBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (ve.getWarnings().size() > 0) {
            throw ve;
        }
    }

    public BbLink getBbLinkAtPos(int pos) {
        BbList bList = super.getFavoriteLinks();
        BbLink bLink = null;
        if (bList.size() >= --pos + 1) {
            bLink = (BbLink)bList.get(pos);
        }
        if (bLink == null) {
            bLink = new BbLink();
            bList.add(pos, bLink);
        }
        return bLink;
    }

    private void setLinkDescription(int pos, String val) {
        this.getBbLinkAtPos(pos).setDescription(val);
    }

    private void setLinkName(int pos, String val) {
        this.getBbLinkAtPos(pos).setName(val);
    }

    private void setLinkUrl(int pos, String val) {
        this.getBbLinkAtPos(pos).setUrl(val);
    }

    @Override
    public String getChildBatchUid() {
        return this.getPersonBatchUid();
    }

    @Override
    public IMembership.IdType getIdType() {
        return IMembership.IdType.fromInt(this._bbAttributes.getInteger("idtype"));
    }

    @Override
    public String getParentBatchUid() {
        return this.getGroupBatchUid();
    }

    @Override
    public void setChildBatchUid(String batchUid) {
        this.setPersonBatchUid(batchUid);
    }

    @Override
    public void setIdType(int type) {
        this._bbAttributes.setInteger("idtype", type);
    }

    @Override
    public void setParentBatchUid(String batchUid) {
        this.setGroupBatchUid(batchUid);
    }

    @Override
    public void setChildBatchUidDirty(boolean dirty) {
        this._bbAttributes.getBbAttribute("PersonBatchUid").setIsDirty(dirty);
    }

    @Override
    public void setParentBatchUidDirty(boolean dirty) {
        this._bbAttributes.getBbAttribute("GroupBatchUid").setIsDirty(dirty);
    }

    public static Set<String> getCourseIdsSet(List<?> objList) throws PersistenceException {
        HashSet<String> courseIdsSet = new HashSet<String>();
        if (objList != null && objList.size() > 0) {
            CourseSiteLoader loader = CourseSiteLoader.Default.getInstance();
            for (int i = 0; i < objList.size(); ++i) {
                Object object = objList.get(i);
                if (object == null || !(object instanceof Membership)) continue;
                String courseBatchUid = ((Membership)object).getGroupBatchUid();
                try {
                    CourseSite course = loader.load(courseBatchUid);
                    if (course == null) continue;
                    courseIdsSet.add(course.getId().toExternalString());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return courseIdsSet;
    }
}

