/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data.user;

import blackboard.admin.data.FieldValidationUtility;
import blackboard.admin.data.IAdminObject;
import blackboard.admin.persist.user.ObserverAssociationLoader;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbEnum;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.user.impl.BbObserverAssociation;
import blackboard.platform.api.PublicAPI;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import java.text.MessageFormat;

@PublicAPI
public class ObserverAssociation
extends BbObserverAssociation
implements IAdminObject {
    private static final long serialVersionUID = 5528818091628223755L;

    public ObserverAssociation() {
        this._bbAttributes.removeBbAttribute("RowStatus");
        this._bbAttributes.setId("DataSourceId", Id.UNSET_ID);
        this._bbAttributes.setString("ObserverBatchUid", null);
        this._bbAttributes.setString("UserBatchUid", null);
        this._bbAttributes.setString("DataSourceBatchUid", null);
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)IAdminObject.RowStatus.DEFAULT);
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)IAdminObject.RecStatus.DEFAULT);
        this._bbAttributes.reset();
    }

    @Override
    public void setDataSourceId(Id iDataSourceId) {
        this._bbAttributes.setId("DataSourceId", iDataSourceId);
        this._bbAttributes.getBbAttribute("DataSourceBatchUid").setIsDirty(false);
    }

    @Override
    public Id getDataSourceId() {
        return this._bbAttributes.getSafeId("DataSourceId");
    }

    @Override
    public String getDataSourceBatchUid() {
        return this._bbAttributes.getSafeString("DataSourceBatchUid");
    }

    @Override
    public void setDataSourceBatchUid(String batchUid) {
        this._bbAttributes.setString("DataSourceBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("DataSourceId").setIsDirty(false);
    }

    @Override
    public IAdminObject.RecStatus getRecStatus() {
        return (IAdminObject.RecStatus)this._bbAttributes.getBbEnum("RecStatus");
    }

    @Override
    public void setRecStatus(IAdminObject.RecStatus eRecStatus) {
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)eRecStatus);
    }

    @Override
    public IAdminObject.RowStatus getRowStatus() {
        return (IAdminObject.RowStatus)this._bbAttributes.getBbEnum("RowStatus");
    }

    @Override
    public void setRowStatus(IAdminObject.RowStatus eRowStatus) {
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)eRowStatus);
    }

    public String getObserverBatchUid() {
        return this._bbAttributes.getSafeString("ObserverBatchUid");
    }

    public void setObserverBatchUid(String batchUid) {
        this._bbAttributes.setString("ObserverBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("ObserverId").setIsDirty(false);
    }

    public void setObserverId(Id id) {
        super.setObserverId(id);
        this._bbAttributes.getBbAttribute("ObserverBatchUid").setIsDirty(false);
    }

    public String getUsersBatchUid() {
        return this._bbAttributes.getSafeString("UserBatchUid");
    }

    public void setUsersBatchUid(String batchUid) {
        this._bbAttributes.setString("UserBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("UsersId").setIsDirty(false);
    }

    public void setUsersId(Id id) {
        super.setUsersId(id);
        this._bbAttributes.getBbAttribute("UserBatchUid").setIsDirty(false);
    }

    @Override
    public void validate() throws ValidationException {
        Object[] args;
        String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
        MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
        ValidationException ve = new ValidationException();
        if (!FieldValidationUtility.isValidString(this.getDataSourceBatchUid(), true, 256)) {
            args = new Object[]{"DataSourceBatchUid"};
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (!FieldValidationUtility.isValidString(this.getObserverBatchUid(), false, 256)) {
            args = new Object[]{"ObserverBatchUid"};
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (!FieldValidationUtility.isValidString(this.getUsersBatchUid(), false, 256)) {
            args = new Object[]{"UserBatchUid"};
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (this.getUsersBatchUid().equals(this.getObserverBatchUid())) {
            String msg = this.getBundle().getString("error.observer.self");
            ve.addWarning(new ValidationWarning(msg, this.getUsersBatchUid()));
        }
        try {
            ObserverAssociationLoader loader = ObserverAssociationLoader.Default.getInstance();
            loader.load(this.getUsersBatchUid(), this.getObserverBatchUid());
            String msg = this.getBundle().getString("error.observer.already.associated", new String[]{this.getUsersBatchUid(), this.getObserverBatchUid()});
            ve.addWarning(new ValidationWarning(msg, msg));
        }
        catch (PersistenceException e) {
            // empty catch block
        }
        if (!ve.getWarnings().isEmpty()) {
            throw ve;
        }
    }

    private BbResourceBundle getBundle() {
        return BundleManagerFactory.getInstance().getBundle("observer");
    }
}

