/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.manager.impl;

import blackboard.admin.data.TemporarySnapshotSession;
import blackboard.admin.persist.datasource.impl.DataSourceDbPersister;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionManager;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbTypeDML;
import blackboard.db.DbUtil;
import blackboard.persist.PersistenceException;
import blackboard.persist.dao.impl.SimpleDAO;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.SelectQuery;
import blackboard.persist.impl.SimpleDeleteQuery;
import blackboard.persist.impl.SimpleSelectQuery;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.CollectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class TemporarySnapshotSessionDAO
extends SimpleDAO<TemporarySnapshotSession> {
    public TemporarySnapshotSessionDAO() {
        super(TemporarySnapshotSession.class);
    }

    public List<TemporarySnapshotSession> loadBySessionId(String sessionId) {
        SimpleSelectQuery query = new SimpleSelectQuery(this.getDAOSupport().getMap());
        if (sessionId != null && !sessionId.isEmpty()) {
            query.addWhere("sessionId", (Object)sessionId);
        }
        return this.getDAOSupport().loadList((SelectQuery)query);
    }

    private List<TemporarySnapshotSession> loadByStartedBeforeDate(Calendar date) {
        SimpleSelectQuery query = new SimpleSelectQuery(this.getDAOSupport().getMap());
        if (date != null) {
            query.addDateBeforeWhere("dateStarted", date);
        }
        return this.getDAOSupport().loadList((SelectQuery)query);
    }

    public void deleteBySessionId(String sessionId) {
        SimpleDeleteQuery query = new SimpleDeleteQuery(this.getDAOSupport().getMap());
        query.addWhere("sessionId", (Object)sessionId);
        this.getDAOSupport().delete((Query)query);
    }

    public void purgeAllSessionsOlderThan(int minutesToInvalid) throws PersistenceException {
        GregorianCalendar expirationDate = new GregorianCalendar();
        ((Calendar)expirationDate).add(12, -1 * minutesToInvalid);
        this.runPurgeSnapshotSessions(this.loadByStartedBeforeDate(expirationDate));
    }

    private void runPurgeSnapshotSessions(List<TemporarySnapshotSession> sessions) throws PersistenceException {
        Connection con = null;
        try {
            con = ConnectionManager.getDefaultConnection();
            for (String tableName : DataSourceDbPersister.SNAPSHOT_TABLE_NAMES) {
                this.runDeleteInStatement(con, tableName, sessions);
            }
        }
        catch (ConnectionNotAvailableException cna) {
            throw new PersistenceException((Throwable)cna);
        }
        finally {
            ConnectionManager.releaseDefaultConnection((Connection)con);
        }
    }

    private void getSessionIdInClauses(List<TemporarySnapshotSession> sessions, StringBuilder sessionIds, String columnName) {
        DbTypeDML dml = BbDatabase.getDefaultInstance().getType().getDML();
        int batchSize = dml.getDefaultInExpressionParameterLimit();
        List goodSessions = CollectionUtils.splitListIntoGroups(sessions, (int)batchSize);
        for (int i = 0; i < goodSessions.size(); ++i) {
            if (i > 0) {
                sessionIds.append(" AND ");
            } else {
                sessionIds.append(" WHERE ");
            }
            sessionIds.append(columnName);
            sessionIds.append(" IN ");
            this.getSessionIdInClauseHelper((List)goodSessions.get(i), sessionIds);
        }
    }

    private void getSessionIdInClauseHelper(List<TemporarySnapshotSession> sessions, StringBuilder sessionIds) {
        sessionIds.append("('");
        for (TemporarySnapshotSession s : sessions) {
            sessionIds.append(s.getSessionId());
            sessionIds.append("','");
        }
        if (sessions.size() > 0) {
            sessionIds.delete(sessionIds.length() - 3, sessionIds.length() - 1);
        } else {
            sessionIds.append(" '");
        }
        sessionIds.append(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDeleteInStatement(Connection con, String tableName, List<TemporarySnapshotSession> sessions) {
        Statement stmt = null;
        String columnName = tableName == "tmp_ccc_key_mappings" || tableName == "tmp_ccc_badpk1" ? "session_guid" : "session_id";
        StringBuilder stmtBuilder = new StringBuilder();
        stmtBuilder.append("DELETE FROM ");
        stmtBuilder.append(tableName);
        this.getSessionIdInClauses(sessions, stmtBuilder, columnName);
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(stmtBuilder.toString());
        }
        catch (SQLException sqe) {
            LogServiceFactory.getInstance().logError(((Object)((Object)this)).getClass().getName(), (Throwable)sqe);
        }
        finally {
            DbUtil.close((Statement)stmt);
        }
    }
}

