/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.persist.category.CourseCategoryPersister;
import blackboard.admin.persist.category.impl.CourseCategoryDbLoader;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryDeleteDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryInsertDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryPersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import java.util.List;

public class CourseCategoryDbPersister
extends SnapshotDbPersister<CourseCategory>
implements CourseCategoryPersister {
    String[] CONSTRAINTS = new String[]{"GATEWAY_CATEGORIES_PK", "GATEWAY_CATEGORIES_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "gc");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "gc", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "gc");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((CourseCategory)obj);
        super.save(CourseCategoryPersisterDbMap.MAP, obj, strSessionId);
        this.resolveReplacementBatchUid((CourseCategory)obj);
    }

    @Override
    public Results save(List<CourseCategory> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(CourseCategoryPersisterDbMap.MAP, objList, strSessionId);
    }

    @Override
    public Results remove(List<CourseCategory> objList) throws PersistenceException {
        return super.remove(CourseCategoryDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(CourseCategory objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.save(CourseCategoryPersisterDbMap.MAP, objToSave, strSessionId);
    }

    @Override
    public void insert(CourseCategory objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(CourseCategoryInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(CourseCategory objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(CourseCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    @Override
    public void update(CourseCategory objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(CourseCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    private void resolveReplacementBatchUid(CourseCategory objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    @Override
    public void remove(CourseCategory objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(CourseCategoryDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    @Override
    public void changeKey(CourseCategory objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(CourseCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    private void resolveBatchUid(CourseCategory objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        CourseCategoryDbLoader loader = (CourseCategoryDbLoader)this._pm.getLoader("CourseCategoryLoader");
        CourseCategory obj = new CourseCategory();
        obj.setId(objInput.getId());
        BbList<CourseCategory> list = loader.load(obj);
        CourseCategory CourseCategory2 = this.getSingleItem(list, obj);
        objInput.setBatchUid(CourseCategory2.getBatchUid());
    }

    private void resolveBatchUid(List<CourseCategory> list) throws PersistenceException {
        for (CourseCategory obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

