/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.persist.category.OrganizationCategoryPersister;
import blackboard.admin.persist.category.impl.OrganizationCategoryDbLoader;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryDeleteDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryInsertDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryPersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import java.util.List;

public class OrganizationCategoryDbPersister
extends SnapshotDbPersister<OrganizationCategory>
implements OrganizationCategoryPersister {
    String[] CONSTRAINTS = new String[]{"COMMUNITY_CATEGORIES_PK", "COMMUNITY_CATEGORIES_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "cc");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "cc", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "cc");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((OrganizationCategory)obj);
        super.save(OrganizationCategoryPersisterDbMap.MAP, obj, strSessionId);
        this.resolveReplacementBatchUid((OrganizationCategory)obj);
    }

    @Override
    public Results save(List<OrganizationCategory> objList, String strSessionId) throws PersistenceException {
        return super.save(OrganizationCategoryPersisterDbMap.MAP, objList, strSessionId);
    }

    @Override
    public Results remove(List<OrganizationCategory> objList) throws PersistenceException {
        return super.remove(OrganizationCategoryDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(OrganizationCategory objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.save(OrganizationCategoryPersisterDbMap.MAP, objToSave, strSessionId);
    }

    @Override
    public void insert(OrganizationCategory objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(OrganizationCategoryInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(OrganizationCategory objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(OrganizationCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    @Override
    public void update(OrganizationCategory objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(OrganizationCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    private void resolveReplacementBatchUid(OrganizationCategory objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    @Override
    public void remove(OrganizationCategory objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(OrganizationCategoryDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    @Override
    public void changeKey(OrganizationCategory objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        try {
            this.update(objToSave);
        }
        catch (PersistenceException pe) {
            this._checkForConstraintViolation(pe, this.CONSTRAINTS);
        }
    }

    private void resolveBatchUid(OrganizationCategory objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        OrganizationCategoryDbLoader loader = (OrganizationCategoryDbLoader)this._pm.getLoader("OrganizationCategoryLoader");
        OrganizationCategory obj = new OrganizationCategory();
        obj.setId(objInput.getId());
        BbList<OrganizationCategory> list = loader.load(obj);
        OrganizationCategory OrganizationCategory2 = this.getSingleItem(list, obj);
        objInput.setBatchUid(OrganizationCategory2.getBatchUid());
    }
}

