/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.persist.category.OrganizationCategoryMembershipPersister;
import blackboard.admin.persist.category.impl.OrganizationCategoryMembershipDbLoader;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryMembershipDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryMembershipDeleteDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ValidationException;
import blackboard.data.category.BbOrganizationCategoryMembership;
import blackboard.data.category.OrgCategoryUID;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.category.OrgCategoryUIDDAO;
import blackboard.persist.category.OrganizationCategoryDbLoader;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Query;
import blackboard.util.StringUtil;
import blackboard.util.UuidFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrganizationCategoryMembershipDbPersister
extends SnapshotDbPersister<OrganizationCategoryMembership>
implements OrganizationCategoryMembershipPersister {
    String[] CONSTRAINTS = new String[]{"COMMUNITY_COURSE_CATEGORIES_PK", "COMMUNITY_COURSE_CATEGORY_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "ccc");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "ccc", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "ccc");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((OrganizationCategoryMembership)obj);
        String batchUID = this.resolveCCCBatchUid((OrganizationCategoryMembership)obj);
        super.save(OrganizationCategoryMembershipDbMap.MAP, obj, strSessionId);
        this.saveCCCBatchUID((OrganizationCategoryMembership)obj, batchUID);
    }

    @Override
    public Results save(List<OrganizationCategoryMembership> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        HashMap<OrganizationCategoryMembership, String> batchUIDs = new HashMap<OrganizationCategoryMembership, String>();
        String batchUID = null;
        for (OrganizationCategoryMembership ocm : objList) {
            try {
                batchUID = this.resolveCCCBatchUid(ocm);
                batchUIDs.put(ocm, batchUID);
            }
            catch (PersistenceException e) {}
        }
        Results results = super.save(OrganizationCategoryMembershipDbMap.MAP, objList, strSessionId);
        for (Map.Entry entry : batchUIDs.entrySet()) {
            if (this.isEntryInErrors((OrganizationCategoryMembership)entry.getKey(), results)) continue;
            this.saveCCCBatchUID((OrganizationCategoryMembership)entry.getKey(), (String)entry.getValue(), results);
        }
        return results;
    }

    private boolean isEntryInErrors(OrganizationCategoryMembership ocm, Results results) {
        String orgBatchUid = ocm.getOrganizationBatchUid();
        String categoryBatchUid = ocm.getCategoryBatchUid();
        OrganizationCategoryMembership errPrm = null;
        String errCategoryBatchUid = null;
        for (Results.Error err : results.getList()) {
            errPrm = (OrganizationCategoryMembership)err.getObject();
            String errOrgBatchUid = errPrm.getOrganizationBatchUid();
            errCategoryBatchUid = errPrm.getCategoryBatchUid();
            if (!orgBatchUid.equals(errOrgBatchUid) || !categoryBatchUid.equals(errCategoryBatchUid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Results remove(List<OrganizationCategoryMembership> objList) throws PersistenceException {
        return super.remove(OrganizationCategoryMembershipDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(OrganizationCategoryMembership objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        String batchUID = this.resolveCCCBatchUid(objToSave);
        super.save(OrganizationCategoryMembershipDbMap.MAP, objToSave, strSessionId);
        this.saveCCCBatchUID(objToSave, batchUID);
    }

    @Override
    public void save(OrganizationCategoryMembership objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        String batchUID = this.resolveCCCBatchUid(objToSave);
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(OrganizationCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.saveCCCBatchUID(objToSave, batchUID);
    }

    @Override
    public void insert(OrganizationCategoryMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        try {
            String batchUID = this.resolveCCCBatchUid(objToSave);
            AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(OrganizationCategoryMembershipDbMap.MAP, (BbObject)objToSave);
            super.runQuery((Query)query, null);
            this.saveCCCBatchUID(objToSave, batchUID);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(OrganizationCategoryMembership objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(OrganizationCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    @Override
    public void remove(OrganizationCategoryMembership objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(OrganizationCategoryMembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(OrganizationCategoryMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("CategoryBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        OrganizationCategoryMembershipDbLoader loader = (OrganizationCategoryMembershipDbLoader)this._pm.getLoader("OrganizationCategoryMembershipLoader");
        OrganizationCategoryMembership obj = new OrganizationCategoryMembership();
        obj.setId(objInput.getId());
        BbList<OrganizationCategoryMembership> list = loader.load(obj);
        OrganizationCategoryMembership OrganizationCategoryMembership2 = this.getSingleItem(list, obj);
        objInput.setOrganizationBatchUid(OrganizationCategoryMembership2.getOrganizationBatchUid());
        objInput.setCategoryBatchUid(OrganizationCategoryMembership2.getCategoryBatchUid());
    }

    private void resolveBatchUid(List<OrganizationCategoryMembership> list) throws PersistenceException {
        for (OrganizationCategoryMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }

    private String resolveCCCBatchUid(OrganizationCategoryMembership obj) throws PersistenceException {
        Id courseId = null;
        Id catId = null;
        courseId = CourseDbLoader.Default.getInstance().loadByBatchUid(obj.getOrganizationBatchUid()).getId();
        catId = ((OrganizationCategoryDbLoader)OrganizationCategoryDbLoader.Default.getInstance()).loadByBatchUid(obj.getCategoryBatchUid()).getId();
        BbOrganizationCategoryMembership ocm = null;
        try {
            if (null != courseId && null != catId) {
                ocm = ((blackboard.persist.category.OrganizationCategoryMembershipDbLoader)blackboard.persist.category.OrganizationCategoryMembershipDbLoader.Default.getInstance()).loadByCourseAndCategory(courseId, catId);
            }
        }
        catch (KeyNotFoundException e) {
        }
        catch (PersistenceException e) {
            throw e;
        }
        if (null != ocm && Id.isValidPkId((Id)ocm.getId())) {
            try {
                new OrgCategoryUIDDAO().loadByOrgCategoryMembershipId(ocm.getId());
                return null;
            }
            catch (Exception e) {
                return UuidFactory.createUuid();
            }
        }
        return UuidFactory.createUuid();
    }

    private void saveCCCBatchUID(OrganizationCategoryMembership obj, String batchUID, Results results) {
        block2: {
            try {
                this.saveCCCBatchUID(obj, batchUID);
            }
            catch (Exception e) {
                if (results == null) break block2;
                results.addError((BbObject)obj, e);
            }
        }
    }

    private void saveCCCBatchUID(OrganizationCategoryMembership obj, String batchUID) {
        if (null != obj && Id.isValid((Id)obj.getId()) && StringUtil.notEmpty((String)batchUID)) {
            OrgCategoryUIDDAO uidDAO = new OrgCategoryUIDDAO();
            uidDAO.deleteByOrgCategoryMembershipId(obj.getId());
            OrgCategoryUID membershipUID = new OrgCategoryUID();
            membershipUID.setBatchUID(batchUID);
            membershipUID.setOrgCategoryMembershipId(obj.getId());
            uidDAO.persist((Identifiable)membershipUID);
        }
    }
}

