/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl.soap.admincategory;

import blackboard.admin.data.category.AdminCategory;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.persist.category.CourseCategoryLoader;
import blackboard.admin.persist.category.CourseCategoryPersister;
import blackboard.admin.persist.category.OrganizationCategoryLoader;
import blackboard.admin.persist.category.OrganizationCategoryPersister;
import blackboard.admin.persist.category.impl.soap.admincategory.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.persistence.PersistenceServiceFactory;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "admincategory.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        AdminCategory pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            for (OrganizationCategory organizationCategory : list) {
                p.insert(organizationCategory);
                aList.add(organizationCategory.getId().toExternalString());
            }
        } else {
            CourseCategoryPersister p = CourseCategoryPersister.Default.getInstance();
            for (CourseCategory courseCategory : list) {
                p.insert(courseCategory);
                aList.add(courseCategory.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ValidationException {
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        AdminCategory pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            for (OrganizationCategory organizationCategory : list) {
                p.update(organizationCategory);
                aList.add(organizationCategory.getId().toExternalString());
            }
        } else {
            CourseCategoryPersister p = CourseCategoryPersister.Default.getInstance();
            for (CourseCategory courseCategory : list) {
                p.update(courseCategory);
                aList.add(courseCategory.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ValidationException {
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        AdminCategory pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            for (OrganizationCategory organizationCategory : list) {
                p.save(organizationCategory);
                aList.add(organizationCategory.getId().toExternalString());
            }
        } else {
            CourseCategoryPersister p = CourseCategoryPersister.Default.getInstance();
            for (CourseCategory courseCategory : list) {
                p.save(courseCategory);
                aList.add(courseCategory.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Persister p;
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(props, obj);
        AdminCategory pObj = list.get(0);
        Results results = null;
        if (pObj instanceof OrganizationCategory) {
            p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            results = p.save(list, session);
        } else {
            p = CourseCategoryPersister.Default.getInstance();
            results = p.save(list, session);
        }
        Iterator<? extends AdminCategory> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            AdminCategory tmp = iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(obj);
        AdminCategory pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            p.remove((OrganizationCategory)pObj);
        } else {
            CourseCategoryPersister p = CourseCategoryPersister.Default.getInstance();
            p.remove((CourseCategory)pObj);
        }
    }

    public static String removeList(String obj) throws PersistenceException {
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(obj);
        AdminCategory pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            return ObjectSerializer.serializeObject((Object)p.remove(list));
        }
        CourseCategoryPersister p = CourseCategoryPersister.Default.getInstance();
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid, String persisterType) throws PersistenceException {
        return ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String persisterType, String sessionId) throws PersistenceException {
        ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId, String persisterType) throws PersistenceException {
        SnapshotPersister p = ServerUtility.getPersister(persisterType);
        p.closeSession(strSessionId);
    }

    public static String load(String batchUid, String loaderType) throws PersistenceException, KeyNotFoundException {
        AdminCategory obj = null;
        if (loaderType.equals("OrganizationCategoryLoader")) {
            OrganizationCategoryLoader oLoader = OrganizationCategoryLoader.Default.getInstance();
            obj = oLoader.load(batchUid);
        } else {
            CourseCategoryLoader cLoader = CourseCategoryLoader.Default.getInstance();
            obj = cLoader.load(batchUid);
        }
        return ClientUtility.convertToString(obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        List<? extends AdminCategory> list = ServerUtility.unMarshallObjects(template);
        if (list.isEmpty()) {
            return "";
        }
        AdminCategory pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryLoader oLoader = OrganizationCategoryLoader.Default.getInstance();
            list = oLoader.load((OrganizationCategory)pObj);
        } else {
            CourseCategoryLoader cLoader = CourseCategoryLoader.Default.getInstance();
            list = cLoader.load((CourseCategory)pObj);
        }
        return ClientUtility.convertToString(list);
    }

    private static SnapshotPersister getPersister(String type) throws PersistenceException {
        return (SnapshotPersister)PersistenceServiceFactory.getInstance().getDbPersistenceManager().getPersister(type);
    }

    public static List<? extends AdminCategory> unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }

    public static List<? extends AdminCategory> unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

