/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.AdminCourseXmlDef;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Organization;
import blackboard.admin.persist.course.CourseSiteXmlPersister;
import blackboard.admin.persist.course.OrganizationXmlPersister;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdminCourseXmlPersisterImpl
extends AdminPersister
implements AdminCourseXmlDef,
CourseSiteXmlPersister,
OrganizationXmlPersister {
    @Override
    public Element persist(Organization obj, Document doc) {
        return this.persist((AdminCourse)obj, doc);
    }

    @Override
    public Element persist(CourseSite obj, Document doc) {
        return this.persist((AdminCourse)obj, doc);
    }

    public Element persist(AdminCourse obj, Document doc) {
        Element rootElement = doc.createElement("group");
        this.persistSourceIdNode(obj, rootElement, doc);
        this.persistGroupTypeNode(obj, rootElement, doc);
        this.persistDescriptionNode(obj, rootElement, doc);
        this.persistTimeFrameNode(obj, rootElement, doc);
        this.persistExtensionNode(obj, rootElement, doc);
        return rootElement;
    }

    protected void persistSourceIdNode(AdminCourse obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getBatchUid());
        rootElement.appendChild(childElement);
    }

    protected void persistGroupTypeNode(AdminCourse obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("grouptype");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"typevalue", (String)String.valueOf(ConversionUtility.serviceLevelToInt(obj.getServiceLevelType())));
        rootElement.appendChild(childElement);
    }

    protected void persistDescriptionNode(AdminCourse obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("description");
        if (obj.getBbAttributes().getBbAttribute("CourseId").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"short", (String)obj.getCourseId());
        }
        if (obj.getBbAttributes().getBbAttribute("Title").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"long", (String)obj.getTitle());
        }
        if (obj.getBbAttributes().getBbAttribute("Description").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"full", (String)obj.getDescription());
        }
        rootElement.appendChild(childElement);
    }

    protected void persistTimeFrameNode(AdminCourse obj, Element rootElement, Document doc) {
        Element childElement = null;
        Element depElement = null;
        childElement = doc.createElement("timeframe");
        if (obj.getBbAttributes().getBbAttribute("StartDate").getValue() != null) {
            depElement = XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"begin", (String)TimeFormat.calendarToString(obj.getStartDate()));
            depElement.setAttribute("restrict", "0");
        }
        if (obj.getBbAttributes().getBbAttribute("EndDate").getValue() != null) {
            depElement = XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"end", (String)TimeFormat.calendarToString(obj.getEndDate()));
            depElement.setAttribute("restrict", "0");
        }
        if (obj.getBbAttributes().getBbAttribute("EnrollmentStartDate").getValue() != null) {
            depElement = XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_enroll_start", (String)TimeFormat.calendarToString(obj.getEnrollmentStartDate()));
            depElement.setAttribute("restrict", "0");
        }
        if (obj.getBbAttributes().getBbAttribute("EnrollmentEndDate").getValue() != null) {
            depElement = XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_enroll_end", (String)TimeFormat.calendarToString(obj.getEnrollmentEndDate()));
            depElement.setAttribute("restrict", "0");
        }
        rootElement.appendChild(childElement);
    }

    protected void persistExtensionNode(AdminCourse obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("extension");
        if (obj.getBbAttributes().getBbAttribute("ReplacementBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_replacementkey", (String)obj.getReplacementBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("TemplateBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_templatekey", (String)obj.getTemplateBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("DataSourceBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_datasource_key", (String)obj.getDataSourceBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("RowStatus").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_row_status", (String)String.valueOf(ConversionUtility.rowStatusToInt(obj.getRowStatus())));
        }
        if (obj.getBbAttributes().getBbAttribute("IsAvailable").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_available", (String)ConversionUtility.booleanToYN(obj.getIsAvailable(false)));
        }
        if (obj.getBbAttributes().getBbAttribute("ShowInCatalog").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_catalog", (String)ConversionUtility.booleanToYN(obj.getShowInCatalog()));
        }
        if (obj.getBbAttributes().getBbAttribute("HasDescriptionPage").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_description_page", (String)ConversionUtility.booleanToYN(obj.getHasDescriptionPage()));
        }
        if (obj.getBbAttributes().getBbAttribute("AllowGuests").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_allow_guests", (String)ConversionUtility.booleanToYN(obj.getAllowGuests()));
        }
        if (obj.getBbAttributes().getBbAttribute("AllowObservers").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_allow_observers", (String)ConversionUtility.booleanToYN(obj.getAllowObservers()));
        }
        if (obj.getBbAttributes().getBbAttribute("PaceType").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_pace", (String)String.valueOf(ConversionUtility.paceToInt(obj.getPaceType())));
        }
        if (obj.getBbAttributes().getBbAttribute("NavStyle").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_navstyle", (String)obj.getNavStyle().toFieldName());
        }
        if (obj.getBbAttributes().getBbAttribute("DurationType").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_duration", (String)String.valueOf(ConversionUtility.durationToInt(obj.getDurationType())));
        }
        if (obj.getBbAttributes().getBbAttribute("EnrollmentType").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_enrollment_type", (String)String.valueOf(ConversionUtility.enrollmentTypeToInt(obj.getEnrollmentType())));
        }
        if (obj.getBbAttributes().getBbAttribute("InstitutionName").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_institution_name", (String)obj.getInstitutionName());
        }
        if (obj.getBbAttributes().getBbAttribute("ClassificationBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_classificationkey", (String)obj.getClassificationBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("Fee").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_fee", (String)String.valueOf(obj.getFee()));
        }
        if (obj.getDataSourceId().isSet()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_data_source_id", (String)obj.getDataSourceId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("id").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_id", (String)obj.getId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("ButtonStyleId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_buttonstyles_id", (String)obj.getButtonStyleId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("ClassificationId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_classification_id", (String)obj.getClassificationId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("Locale").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_locale", (String)obj.getLocale());
        }
        if (obj.getBbAttributes().getBbAttribute("IsLocaleEnforced").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_locale_enforced_indicator", (String)ConversionUtility.booleanToYN(obj.getIsLocaleEnforced()));
        }
        if (obj.getBbAttributes().getBbAttribute("embed") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_embedded_source", (String)obj.getBbAttributes().getSafeString("embed"));
        }
        if (obj.getBbAttributes().getBbAttribute("NumDaysOfUse").getIsDirty()) {
            if (obj.getBbAttributes().getBbAttribute("NumDaysOfUse").getValue() == null) {
                XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_days_of_use", (String)String.valueOf(-1));
            } else {
                XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_days_of_use", (String)String.valueOf(obj.getNumDaysOfUse()));
            }
        }
        if (obj.getBbAttributes().getBbAttribute("x_bb_content_package") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_content_package", (String)obj.getBbAttributes().getSafeString("x_bb_content_package"));
        }
        if (obj.getBbAttributes().getSafeBoolean("AssociationRefreshRequired").booleanValue()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"course_std_sub_doc_associations", (String)"");
        }
        rootElement.appendChild(childElement);
    }
}

