/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.CourseSiteDbLoader;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.DataIntegrationCloneOperation;
import blackboard.admin.persist.course.impl.mapping.AdminCourseDeleteDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCourseInsertDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCoursePersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ImmutableException;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.data.course.CourseSettingCXHelper;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Query;
import blackboard.platform.contentsystem.manager.DocumentManagerEx;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.dataintegration.DataIntegration;
import blackboard.platform.dataintegration.DataIntegrationLogFactory;
import blackboard.platform.dataintegration.DataIntegrationManagerFactory;
import blackboard.platform.dataintegration.mapping.CourseCloneConfig;
import blackboard.platform.dataintegration.mapping.CourseCloneExecutor;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.Log;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.queue.QueuedTaskManagerFactory;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.ExceptionUtil;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CourseSiteDbPersister
extends SnapshotDbPersister<CourseSite>
implements CourseSitePersister,
CourseCloneExecutor {
    String[] CONSTRAINTS = new String[]{"COURSE_MAIN_PK", "COURSE_MAIN_AK1", "COURSE_MAIN_AK2", "COURSE_MAIN_AK3"};
    String[] IMMUTABLE = new String[]{"immutable"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        super.checkApiLicensing();
        return super._createSession(dataSourceBatchUid, "course");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super.checkApiLicensing();
        super._createSession(dataSourceBatchUid, "course", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        super.closeSession(strSessionId, "course");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((CourseSite)obj, strSessionId);
    }

    @Override
    public Results save(List<CourseSite> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        RemoteResults csFolderCheckResults = new RemoteResults(objList.size());
        ListIterator<CourseSite> it = objList.listIterator();
        RemoteResults res = new RemoteResults();
        while (it.hasNext()) {
            CourseSite cst = it.next();
            String courseId = null;
            try {
                courseId = cst.getCourseId();
                CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
                if (!StringUtil.notEmpty((String)courseId) || courseLoader.doesCourseIdExist(courseId) || !this.courseFilesFolderHasContent(cst)) continue;
                String msg = "Error saving " + courseId + ". An existing Course Files folder exists and has file content.  Either delete the folder or empty it's file content";
                LogServiceFactory.getInstance().logError(msg);
                csFolderCheckResults.addError((BbObject)cst, (Exception)((Object)new PersistenceException(msg)));
                it.remove();
            }
            catch (Exception e) {
                String message = courseId == null ? e.getMessage() : "Error saving " + courseId + ". " + e.getMessage();
                LogServiceFactory.getInstance().logError(message);
                res.addError((BbObject)cst, e);
                throw new PersistenceException(message);
            }
        }
        Results moreResults = super.save(AdminCoursePersisterDbMap.PROCESS_INTEGRATION_MAP, objList, strSessionId);
        res.addAllResults(moreResults);
        this.flushCacheById(objList);
        ConversionUtility.mergeResults(csFolderCheckResults, res);
        return res;
    }

    private boolean courseFilesFolderHasContent(CourseSite cst) throws PersistenceException {
        return ContentSystemServiceExFactory.getInstance().getDocumentManagerEx().getCourseHomeDirImmediateChildNum(cst.getCourseId(), true) > 0;
    }

    @Override
    public Results remove(List<CourseSite> objList) throws PersistenceException {
        return this.remove(objList, false);
    }

    @Override
    public Results remove(List<CourseSite> objList, boolean removeContent) throws PersistenceException {
        super.checkApiLicensing();
        try {
            CourseSiteDbPersister.archiveCourseContent(objList);
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logWarning("Failure occurred during course archival", (Throwable)exc);
        }
        if (removeContent) {
            DocumentManagerEx docMgrEx = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
            try {
                String[] batchUids = new String[objList.size()];
                int i = 0;
                for (CourseSite courseSite : objList) {
                    batchUids[i++] = courseSite.getBatchUid();
                }
                docMgrEx.removeCourseContent(batchUids);
            }
            catch (Exception e) {
                throw new PersistenceException("Problem removing course content", (Throwable)e);
            }
        }
        Results res = super.remove(AdminCourseDeleteDbMap.MAP, objList);
        this.flushCacheById(objList);
        return res;
    }

    @Override
    public void save(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
            this.flushCacheById((Identifiable)objToSave);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            this._checkForConstraintViolation(pe, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(CourseSite objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        try {
            super.save(AdminCoursePersisterDbMap.PROCESS_INTEGRATION_MAP, objToSave, strSessionId);
            this.flushCacheById((Identifiable)objToSave);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            throw pe;
        }
    }

    @Override
    public void insert(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(AdminCourseInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
            this.flushCacheById((Identifiable)objToSave);
        }
        catch (PersistenceException e) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)e, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    private void resolveReplacementBatchUid(CourseSite objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    @Override
    public void remove(CourseSite objToRemove) throws KeyNotFoundException, PersistenceException {
        super.checkApiLicensing();
        try {
            CourseSiteDbPersister.archiveCourseContent(objToRemove);
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logWarning("Failure occurred during course archival", (Throwable)exc);
        }
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(AdminCourseDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
        this.flushCacheById((Identifiable)objToRemove);
    }

    @Override
    public void changeKey(CourseSite objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        super.checkApiLicensing();
        objToSave.setReplacementBatchUid(newKey);
        try {
            this.update(objToSave);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    @Override
    public void clone(final String srcCrsBatchUid, final String tgtCrsBatchUid, final CloneConfig cfg) throws PersistenceException, KeyNotFoundException, ValidationException, ConstraintViolationException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    AdminCourseCloneOperator op = new AdminCourseCloneOperator(CourseSiteDbPersister.this._pm, CourseSiteDbPersister.this._appVersion);
                    CourseDbLoader loader = (CourseDbLoader)CourseSiteDbPersister.this._pm.getLoader("CourseDbLoader");
                    Course src = loader.loadByBatchUid(srcCrsBatchUid);
                    Course tgt = loader.loadByBatchUid(tgtCrsBatchUid);
                    op.clone(cfg, src, tgt);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable rootCause = pae.getCause();
            if (rootCause instanceof PersistenceException) {
                if (rootCause instanceof KeyNotFoundException) {
                    throw (KeyNotFoundException)rootCause;
                }
                super._checkForConstraintViolation(new PersistenceException(rootCause), this.CONSTRAINTS);
            }
            if (rootCause instanceof ValidationException) {
                throw (ValidationException)rootCause;
            }
            if (rootCause instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)rootCause;
            }
            throw new PersistenceException(rootCause);
        }
    }

    protected static void archiveCourseContent(List list) throws PersistenceException, IOException, FileSystemException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CourseSiteDbPersister.archiveCourseContent((AdminCourse)iter.next());
        }
    }

    protected static void archiveCourseContent(AdminCourse crs) throws PersistenceException, IOException, FileSystemException {
        FileSystemService service = FileSystemServiceFactory.getInstance();
        CourseSiteLoader cLoader = CourseSiteLoader.Default.getInstance();
        CourseSite vCrs = cLoader.load(crs.getBatchUid());
        CourseFileManager fMgr = (CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE);
        File fCourseDir = fMgr.getRootDirectory(vCrs.getCourseId());
        File archiveDir = new File(service.getRecycleDirectory(), "1");
        File absArchiveDir = new File(archiveDir, vCrs.getCourseId());
        if (absArchiveDir.exists()) {
            FileUtil.delete((File)absArchiveDir);
        }
        if (fCourseDir.exists()) {
            FileUtil.moveDirectory((File)fCourseDir, (File)absArchiveDir);
        }
        ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager().purgeCourseResources((Course)vCrs, absArchiveDir);
    }

    private void resolveBatchUid(CourseSite objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        CourseSiteDbLoader loader = (CourseSiteDbLoader)this._pm.getLoader("CourseSiteLoader");
        CourseSite obj = new CourseSite();
        obj.setId(objInput.getId());
        BbList<CourseSite> list = loader.load(obj);
        CourseSite CourseSite2 = this.getSingleItem(list, obj);
        objInput.setBatchUid(CourseSite2.getBatchUid());
    }

    private void resolveBatchUid(List<CourseSite> list) throws PersistenceException {
        for (CourseSite courseSite : list) {
            this.resolveBatchUid(courseSite);
        }
    }

    public void queuedClone(final String srcCrsBatchUid, final String tgtCrsBatchUid, CourseCloneConfig cfg) {
        final CloneConfig cc = this.buildCloneConfig(cfg);
        DataIntegration di = null;
        try {
            di = cfg.getDataIntegrationId() == null ? null : DataIntegrationManagerFactory.getInstance().loadById(cfg.getDataIntegrationId());
        }
        catch (Exception e) {
            DataIntegrationLogFactory.getSystemInstance().logError("Error loading DataIntegration while attempting a Course Content Population action.", (Throwable)e);
        }
        final Id dataIntegrationId = null == di ? null : di.getId();
        final String dataSetUid = cfg.getDataSetUid();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
                    Course srcSite = courseLoader.loadByBatchUid(srcCrsBatchUid);
                    Course tgtSite = courseLoader.loadByBatchUid(tgtCrsBatchUid);
                    QueueTask task = DataIntegrationCloneOperation.createTask(srcSite, tgtSite, cc, true, dataIntegrationId, dataSetUid);
                    QueuedTaskManagerFactory.getInstance().addTask(task);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Log log = di == null ? DataIntegrationLogFactory.getSystemInstance() : DataIntegrationLogFactory.getInstanceByDataIntegration((DataIntegration)di);
            log.logError("An error occurred while executing Data Integration Content Population", (Throwable)e);
        }
    }

    public CloneConfig buildCloneConfig(CourseCloneConfig cfg) {
        CloneConfig cc = new CloneConfig();
        if (cfg.isExactCopy()) {
            cc.setCopyType(CloneConfig.CopyType.COPY_EXACT_COURSE);
            cc.includeArea(CloneConfig.Area.ALL);
        } else {
            if (cfg.isCopyContentAreas()) {
                cc.includeArea(CloneConfig.Area.CONTENT);
                if (cfg.isCopyAdaptiveReleaseRules()) {
                    cc.includeArea(CloneConfig.Area.AVAILABILITY_RULE);
                }
            }
            if (cfg.isCopyAnnouncements()) {
                cc.includeArea(CloneConfig.Area.ANNOUNCEMENT);
            }
            if (cfg.isCopyBlogs()) {
                cc.includeArea(CloneConfig.Area.BLOG);
            }
            if (cfg.isCopyCalendar()) {
                cc.includeArea(CloneConfig.Area.CALENDAR);
            }
            if (cfg.isCopyCollabSessions()) {
                cc.includeArea(CloneConfig.Area.CHAT_SESSION);
            }
            if (cfg.isCopyContacts()) {
                cc.includeArea(CloneConfig.Area.STAFF_INFORMATION);
            }
            if (cfg.isCopyContentAlignments()) {
                cc.includeArea(CloneConfig.Area.STD_ALIGNMENT);
            }
            if (cfg.isCopyDiscussionBoard()) {
                cc.includeArea(CloneConfig.Area.DISCUSSION_BOARD);
                if (cfg.getDiscussionBoardOptions() != null && cfg.getDiscussionBoardOptions().contains("excludeStarterPosts")) {
                    cc.includeObject(CloneConfig.Area.DISCUSSION_BOARD, "excludeStarterPosts");
                }
            }
            if (cfg.isCopyEarlyWarningSysRules()) {
                cc.includeArea(CloneConfig.Area.EARLY_WARNING_SYSTEM);
            }
            if (cfg.isCopyGlossary()) {
                cc.includeArea(CloneConfig.Area.GLOSSARY);
            }
            if (cfg.isCopyGradeCenterColumnsAndSettings()) {
                cc.includeArea(CloneConfig.Area.GRADEBOOK);
            }
            if (cfg.isCopyGroupSettings()) {
                cc.includeArea(CloneConfig.Area.GROUP);
            }
            if (cfg.isCopyJournals()) {
                cc.includeArea(CloneConfig.Area.JOURNAL);
            }
            if (cfg.isCopyRubrics()) {
                cc.includeArea(CloneConfig.Area.RUBRIC);
            }
            if (cfg.isCopySettings()) {
                cc.includeArea(CloneConfig.Area.SETTING);
                if (cfg.getSubAreas() != null) {
                    cc.includeObject(CloneConfig.Area.SETTING, CourseSettingCXHelper.LIMITED_SETTINGS);
                    for (String subArea : cfg.getSubAreas()) {
                        cc.includeObject(CloneConfig.Area.SETTING, subArea);
                    }
                }
            }
            if (cfg.isCopyTasks()) {
                cc.includeArea(CloneConfig.Area.TASK);
            }
            if (cfg.isCopyTestSurveysAndPools()) {
                cc.includeArea(CloneConfig.Area.ASSESSMENT);
            }
            if (cfg.isCopyEnrollments()) {
                cc.includeArea(CloneConfig.Area.MEMBERSHIP);
            }
            if (cfg.getCustomAreas() != null) {
                for (String customArea : cfg.getCustomAreas()) {
                    cc.includeCxComponent(customArea);
                }
            }
            if (cfg.isProtectedCartridge()) {
                cc.includeArea(CloneConfig.Area.COURSE_CARTRIDGE);
            }
        }
        cc.setCloneOptions(cfg.getCopyLinksToCourseFiles());
        cc.setReconcileFlag(!cfg.isUpdate());
        cc.setQuota(cfg.getQuota());
        if (cfg.isUpdate()) {
            cc.excludeArea(CloneConfig.Area.GRADEBOOK_CLEAR);
        }
        return cc;
    }
}

