/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.persist.course.EnrollmentPersister;
import blackboard.admin.persist.course.impl.EnrollmentDbLoader;
import blackboard.admin.persist.course.impl.mapping.EnrollmentDbMap;
import blackboard.admin.persist.course.impl.mapping.EnrollmentInsertDbMap;
import blackboard.admin.persist.course.impl.mapping.MembershipDeleteDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import java.util.List;

public class EnrollmentDbPersister
extends SnapshotDbPersister<Enrollment>
implements EnrollmentPersister {
    String[] CONSTRAINTS = new String[]{"COURSE_USERS_PK", "COURSE_USERS_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "cu");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "cu", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "cu");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((Enrollment)obj, strSessionId);
    }

    @Override
    public Results save(List<Enrollment> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        Results results = super.save(EnrollmentDbMap.MAP, objList, strSessionId);
        this._pm.refreshLoader("CourseMembershipDbLoader");
        if (results.getErrorCount() == 0) {
            this.sendPostEnrollmentEvents(objList);
        }
        return results;
    }

    @Override
    public Results remove(List<Enrollment> objList) throws PersistenceException {
        return super.remove(MembershipDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(Enrollment objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(EnrollmentDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(Enrollment objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(EnrollmentDbMap.MAP, objToSave, strSessionId);
    }

    @Override
    public void insert(Enrollment objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(EnrollmentInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(Enrollment objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(EnrollmentDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void remove(Enrollment objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(MembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(Enrollment objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("PersonBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        EnrollmentDbLoader loader = (EnrollmentDbLoader)this._pm.getLoader("EnrollmentLoader");
        Enrollment obj = new Enrollment();
        obj.setId(objInput.getId());
        BbList<Enrollment> list = loader.load(obj);
        Enrollment enrollment = this.getSingleItem(list, obj);
        objInput.setCourseSiteBatchUid(enrollment.getCourseSiteBatchUid());
        objInput.setPersonBatchUid(enrollment.getPersonBatchUid());
    }

    private void resolveBatchUid(List<Enrollment> list) throws PersistenceException {
        for (Enrollment obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

