/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.cxutil.CSResource;
import blackboard.admin.cxutil.CSResourceStatusMap;
import blackboard.admin.manager.impl.TemporarySnapshotSessionManagerFactory;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseCopyLoggerFactory;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.persist.course.impl.clone.CoreCloneOperatorFactory;
import blackboard.admin.persist.course.impl.clone.CourseCopyLogger;
import blackboard.admin.persist.course.impl.clone.DebugCloneCallback;
import blackboard.admin.persist.course.impl.clone.PostCourseCloneMessageHandler;
import blackboard.admin.persist.course.impl.clone.operator.AnnouncementCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.AvailabilityRuleCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.BlogCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CalendarCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CategoryMembershipCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ChatArchiveCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ChatSessionCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentTocCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseCorrectionCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseFilesCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseModulePageCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseStatisticsCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseTocCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseTocOrderingOperator;
import blackboard.admin.persist.course.impl.clone.operator.DropBoxCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.FileManagerCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.GlossaryCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.GradebookCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.GroupCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.JournalCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.LinkCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.MembershipCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.PageBannerCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.PostGradebookCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ReconciliationCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ScormCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.SettingCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.StaffInformationCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.SyncGroupAppsCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.TaskCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.extension.ExtensionPointCloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.data.navigation.CourseToc;
import blackboard.db.ConnectionManager;
import blackboard.db.DatabaseTransaction;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.platform.contentsystem.manager.DocumentManagerEx;
import blackboard.platform.contentsystem.manager.PrivateDocumentManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.context.Context;
import blackboard.platform.context.ContextManager;
import blackboard.platform.context.ContextManagerFactory;
import blackboard.platform.coursemap.CourseMapManagerFactory;
import blackboard.platform.extension.service.ExtensionRegistryFactory;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.Log;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.vxi.data.VirtualHost;
import blackboard.platform.vxi.service.VirtualInstallationManager;
import blackboard.platform.vxi.service.VirtualInstallationManagerFactory;
import blackboard.util.ExceptionUtil;
import blackboard.util.FileUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AdminCourseCloneOperator
extends CloneOperator {
    private final ArrayList<CloneOperator> _operatorList = new ArrayList(38);
    private AsynchronousDirectoryClone _thread;

    public AdminCourseCloneOperator(BbPersistenceManager pm, AppVersion appVersion) {
        super(pm, appVersion, new HashMap<String, Map<String, String>>(), new CSResourceStatusMap());
        this._operatorList.add(new CourseFilesCloneOperator(this));
        this._operatorList.add(new CategoryMembershipCloneOperator(this));
        this._operatorList.add(new MembershipCloneOperator(this));
        this._operatorList.add(new CourseModulePageCloneOperator(this));
        this._operatorList.add(new GroupCloneOperator(this));
        this._operatorList.add(new AnnouncementCloneOperator(this));
        this._operatorList.add(new CalendarCloneOperator(this));
        this.addCoreCloneOperator(CoreCloneOperatorFactory.CoreCloneOperationType.Rubric);
        this._operatorList.add(new ContentCloneOperator(this));
        this._operatorList.add(new ReconciliationCloneOperator(this));
        this._operatorList.add(new StaffInformationCloneOperator(this));
        this._operatorList.add(new CourseTocCloneOperator(this));
        this._operatorList.add(new ContentTocCloneOperator(this));
        this.addCoreCloneOperator(CoreCloneOperatorFactory.CoreCloneOperationType.Assessment);
        this._operatorList.add(new GradebookCloneOperator(this));
        this.addCoreCloneOperator(CoreCloneOperatorFactory.CoreCloneOperationType.DiscussionBoard);
        this._operatorList.add(new BlogCloneOperator(this));
        this._operatorList.add(new JournalCloneOperator(this));
        this._operatorList.add(new SettingCloneOperator(this));
        this._operatorList.add(new DropBoxCloneOperator(this));
        this._operatorList.add(new FileManagerCloneOperator(this));
        this._operatorList.add(new TaskCloneOperator(this));
        this._operatorList.add(new ChatSessionCloneOperator(this));
        this._operatorList.add(new ChatArchiveCloneOperator(this));
        this._operatorList.add(new CourseStatisticsCloneOperator(this));
        this._operatorList.add(new LinkCloneOperator(this));
        this._operatorList.add(new GlossaryCloneOperator(this));
        this._operatorList.add(new CourseTocOrderingOperator(this));
        this._operatorList.add(new AvailabilityRuleCloneOperator(this));
        this._operatorList.add(new PageBannerCloneOperator(this));
        this.addCoreCloneOperator(CoreCloneOperatorFactory.CoreCloneOperationType.GoalSubDocumentAssociation);
        this.addCoreCloneOperator(CoreCloneOperatorFactory.CoreCloneOperationType.GoalAlignment);
        this._operatorList.add(new CourseCorrectionCloneOperator(this));
        this._operatorList.add(new ExtensionPointCloneOperator(this));
        this._operatorList.add(new SyncGroupAppsCloneOperator(this));
        this._operatorList.add(new PostGradebookCloneOperator(this));
        this._operatorList.add(new ScormCloneOperator(this));
    }

    private void addCoreCloneOperator(CoreCloneOperatorFactory.CoreCloneOperationType opType) {
        Collection coreOps = ExtensionRegistryFactory.getInstance().getExtensions("blackboard.cmsadmin.coreCloneOperatorFactory");
        for (CoreCloneOperatorFactory op : coreOps) {
            CloneOperator operator;
            if (!op.supports(opType) || (operator = op.getCloneOperator(this, opType)) == null) continue;
            this._operatorList.add(operator);
        }
    }

    @Override
    public void init(Course src, Course tgt, String sessionId, CloneConfig cfg) {
        super.init(src, tgt, sessionId, cfg);
        for (CloneOperator operator : this._operatorList) {
            try {
                operator.init(src, tgt, this._sessionId, cfg);
            }
            catch (Throwable t) {
                operator.setInGoodState(false);
                ExceptionUtil.checkForThreadDeath((Throwable)t);
                LogServiceFactory.getInstance().logError("Caught Exception while initiating the Clone Operator: " + operator, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clone(CloneConfig cfg, Course srcCourse, Course tgtCourse) throws PersistenceException {
        try {
            this.startCourseCloneLogger(cfg, srcCourse, tgtCourse);
            LogService logger = LogServiceFactory.getInstance();
            if (tgtCourse.isChild()) {
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("clone.invalidtarget.ischild");
                logger.logFatal(msg);
                throw new PersistenceException(msg);
            }
            if (srcCourse.getBatchUid().equals(tgtCourse.getBatchUid())) {
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("clone.invalidtarget");
                logger.logFatal(msg);
                throw new PersistenceException(msg);
            }
            if (this._bDebug && cfg.getCallback() == null) {
                cfg.setCallback(new DebugCloneCallback());
            }
            long oStart = System.currentTimeMillis();
            try {
                CourseTocDbLoader loader = CourseTocDbLoader.Default.getInstance();
                BbList list = loader.loadByCourseId(tgtCourse.getId());
                cfg.setOriginalTargetCourseTocList((ArrayList<CourseToc>)list);
                this._sessionId = this.createSession();
                this.init(srcCourse, tgtCourse, this._sessionId, cfg);
                this.setQuota(cfg);
                ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager().createFolder(this._tgtSite, "");
                Context ctx = ContextManagerFactory.getInstance().getContext();
                this._thread = new AsynchronousDirectoryClone(cfg, this._srcSite, this._tgtSite, ctx);
                this._thread.start();
                this.doDatabaseTranslation();
                ContentSystemServiceExFactory.getInstance().getSecurityManagerEx().rebuildXythosContext();
                long lStart = System.currentTimeMillis();
                this.loadMapping();
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("clone.map.load");
                this.doCallbackSegment(CloneCallback.Stage.LOAD_ID_MAP, msg, System.currentTimeMillis() - lStart);
                lStart = System.currentTimeMillis();
                this.doContentDirectoryTranslation();
                msg = ConfigurationManager.getGlobalLocaleExceptionMessage("clone.file");
                this.doCallbackSegment(CloneCallback.Stage.FILE_COPY, msg, System.currentTimeMillis() - lStart);
                this.doEmbeddedDatabaseIdTranslation();
                this.doPostEvent();
                logger.logInfo("Copy completed");
            }
            catch (Exception e) {
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("clone.general.failure");
                logger.logFatal(msg, (Throwable)e);
                logger.logInfo("Copy completed with Errors");
                throw new PersistenceException(msg, (Throwable)e);
            }
            finally {
                CourseMapManagerFactory.getInstance().invalidateCache(tgtCourse.getId());
                this.releaseResources();
            }
            String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("clone.exit");
            this.doCallbackSegment(CloneCallback.Stage.TERMINUS, msg, System.currentTimeMillis() - oStart);
        }
        finally {
            this.endCourseCloneLogger();
        }
    }

    private void endCourseCloneLogger() {
        Log logger = LogServiceFactory.getInstance().getDefaultLog();
        if (logger instanceof CourseCopyLogger) {
            CourseCopyLogger courseCopyLogger = (CourseCopyLogger)logger;
            courseCopyLogger.cleanup();
            LogServiceFactory.getInstance().setDefaultThreadLog(null);
        }
    }

    private void startCourseCloneLogger(CloneConfig cfg, Course srcCourse, Course tgtCourse) {
        try {
            if (!cfg.canUseCourseCopyLog()) {
                return;
            }
            if (cfg.isCloneForDecrossList()) {
                return;
            }
            CourseCopyLogger cloneLogger = CourseCopyLoggerFactory.getInstance().createLog(cfg, tgtCourse);
            LogServiceFactory.getInstance().setDefaultThreadLog((Log)cloneLogger);
            cloneLogger.logHeader(cfg, srcCourse, tgtCourse);
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Failed to create Course Copy logs.  Using default log instead.", (Throwable)e);
        }
    }

    private void setQuota(CloneConfig cfg) throws Exception {
        DocumentManagerEx docMgrEx = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
        long quota = cfg.getQuota();
        if (0L == quota) {
            quota = docMgrEx.getQuotaForCourseCopy(this._tgtSite, this._srcSite);
        }
        if (0L < quota || -1L == quota) {
            docMgrEx.setDirectoryQuota(this._tgtSite, quota, true);
        }
    }

    private void doPostEvent() {
        try {
            PostCourseCloneMessageHandler.submit(this._srcSite.getId(), this._tgtSite.getId(), this._cfg);
            CSResourceStatusMap.registerLinks(this.getCsLinkStatusList(CSResource.CSStatus.Succeeded));
            CSResourceStatusMap.registerLinks(this.getCsLinkStatusList(CSResource.CSStatus.InsufficientPermission));
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Could not post course copy event.", (Throwable)e);
        }
    }

    @Override
    public void doDatabaseTranslation() {
        for (CloneOperator operator : this._operatorList) {
            if (!operator.isInGoodState()) continue;
            try {
                operator.doDatabaseTranslation();
            }
            catch (Throwable t) {
                operator.setInGoodState(false);
                ExceptionUtil.checkForThreadDeath((Throwable)t);
                LogServiceFactory.getInstance().logError("Caught Exception while processing the Clone Operator: " + operator, t);
            }
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() {
        for (CloneOperator operator : this._operatorList) {
            if (!operator.isInGoodState()) continue;
            try {
                operator.doEmbeddedDatabaseIdTranslation();
            }
            catch (Throwable t) {
                operator.setInGoodState(false);
                ExceptionUtil.checkForThreadDeath((Throwable)t);
                LogServiceFactory.getInstance().logError("Caught Exception while processing the Clone Operator: " + operator, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping() throws Exception {
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select * from tmp_key_maps where session_id = ? and table_name in ( 'ANNOUNCEMENTS', 'ATTEMPT', 'GROUP_ATTEMPT', 'ATTEMPT_STAGED_GRADING', 'GROUP_ATTEMPT_STAGED_GRADING', 'BLOGS', 'BLOG_ENTRY', 'CALENDAR','RUBRIC','RUBRIC_COLUMN','RUBRIC_ROW','RUBRIC_CELL', 'COURSE_CONTENTS', 'COURSE_TOC', 'COURSE_USERS', 'FILES', 'FORUM_MAIN', 'GRADEBOOK_MAIN', 'GROUPS', 'MSG_ATTACHMENT', 'MSG_MAIN', 'QTI_ASI_DATA', 'STAFFINFORMATION', 'TAB', 'TASKS', 'VC_ARCHIVE_EVENT', 'GRADEBOOK_GRADE' ) order by table_name desc");
            DbUtil.setString((PreparedStatement)stmt, (int)1, (String)this._sessionId);
            rst = stmt.executeQuery();
            while (rst.next()) {
                Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                String name = rst.getString("table_name");
                if (oldId == null || newId == null) continue;
                Map<String, String> tmp = this.getDbBasedIdMap(name);
                tmp.put(oldId.toExternalString(), newId.toExternalString());
            }
            Map<String, String> tmp = this.getDbBasedIdMap("COURSE_MAIN");
            tmp.put(this._srcSite.getId().toExternalString(), this._tgtSite.getId().toExternalString());
        }
        catch (Throwable throwable) {
            DbUtil.close(rst);
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((ResultSet)rst);
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        FileSystemService svc = FileSystemServiceFactory.getInstance();
        CourseFileManager fMgr = (CourseFileManager)svc.getFileManager(Course.DATA_TYPE);
        File srcPath = fMgr.getRootDirectory(this._srcSite.getCourseId());
        this._thread.join();
        if (this._thread.getException() != null) {
            throw this._thread.getException();
        }
        for (CloneOperator operator : this._operatorList) {
            if (!operator.isInGoodState()) continue;
            try {
                operator.doContentDirectoryTranslation();
            }
            catch (Throwable t) {
                operator.setInGoodState(false);
                ExceptionUtil.checkForThreadDeath((Throwable)t);
                LogServiceFactory.getInstance().logError("Caught Exception while processing the Clone Operator: " + operator, t);
            }
        }
        File cacheFile = new File(srcPath, "nav_item_courses.db");
        if (cacheFile.exists() && !cacheFile.delete()) {
            LogServiceFactory.getInstance().logWarning("Could not delete cache file: " + cacheFile.getAbsolutePath());
        }
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    private String createSession() throws Exception {
        return TemporarySnapshotSessionManagerFactory.getInstance().createSnapshotSession();
    }

    private void releaseResources() {
        if (this._sessionId == null) {
            return;
        }
        try {
            ConnectionManager.getDefaultInstance().performTransaction(new DatabaseTransaction("AdminCourseCloneOperator.releaseResources"){

                public void run(Connection connection) throws PersistenceException, ValidationException {
                    PreparedStatement stmt = null;
                    try {
                        stmt = connection.prepareStatement("delete from tmp_key_maps where session_id = ?");
                        stmt.setString(1, AdminCourseCloneOperator.this._sessionId);
                        stmt.execute();
                    }
                    catch (SQLException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                    finally {
                        DbUtil.close((Statement)stmt);
                    }
                    TemporarySnapshotSessionManagerFactory.getInstance().deleteBySessionId(AdminCourseCloneOperator.this._sessionId);
                }
            });
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logWarning(exc.getLocalizedMessage(), (Throwable)exc);
        }
    }

    private static class AsynchronousDirectoryClone
    extends Thread {
        private Exception _exc;
        private final File _srcPath;
        private final File _tgtPath;
        private final Course _srcSite;
        private final Course _tgtSite;
        private final CloneConfig _cfg;
        private final Context _ctx;

        public AsynchronousDirectoryClone(CloneConfig cfg, Course srcSite, Course tgtSite, Context ctx) throws Exception {
            super("AdminCourseCloneOperator$AsynchronousDirectoryClone");
            FileSystemService svc = FileSystemServiceFactory.getInstance();
            CourseFileManager fMgr = (CourseFileManager)svc.getFileManager(Course.DATA_TYPE);
            this._srcPath = fMgr.getRootDirectory(srcSite.getCourseId());
            this._tgtPath = fMgr.getRootDirectory(tgtSite.getCourseId());
            this._srcSite = srcSite;
            this._tgtSite = tgtSite;
            this._cfg = cfg;
            this._ctx = ctx;
        }

        @Override
        public void run() {
            try {
                VirtualInstallationManager vim = VirtualInstallationManagerFactory.getInstance();
                VirtualHost vhost = vim.getVirtualHost("localhost");
                ContextManager cMgr = ContextManagerFactory.getInstance();
                cMgr.setContext(vhost.getId(), this._ctx.getCourseId(), this._ctx.getUserId(), this._ctx.getGroupId(), this._ctx.getContentId());
                PrivateDocumentManager docMgr = ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager();
                FileUtil.copyDirectory((File)new File(this._srcPath, "ppg"), (File)new File(this._tgtPath, "ppg"));
                docMgr.copyResources(this._srcSite, this._tgtSite, "ppg");
                if (this._cfg.isAreaIncluded(CloneConfig.Area.ASSESSMENT)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "assessment"), (File)new File(this._tgtPath, "assessment"));
                    docMgr.copyResources(this._srcSite, this._tgtSite, "assessment");
                    FileUtil.copyDirectory((File)new File(this._srcPath, "assignment"), (File)new File(this._tgtPath, "assignment"));
                    docMgr.copyResources(this._srcSite, this._tgtSite, "assignment");
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.CHAT_ARCHIVE)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "collab/archives"), (File)new File(this._tgtPath, "collab/archives"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "content"), (File)new File(this._tgtPath, "content"));
                    docMgr.copyResources(this._srcSite, this._tgtSite, "content");
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "messaging"), (File)new File(this._tgtPath, "messaging"));
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_BOARD) || this._cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_BOARD_ARCHIVE)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "db"), (File)new File(this._tgtPath, "db"));
                    Set<String> dbOpts = this._cfg.getIncludedObjects(CloneConfig.Area.DISCUSSION_BOARD);
                    if (null == dbOpts) {
                        docMgr.copyResources(this._srcSite, this._tgtSite, "db");
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "uploads"), (File)new File(this._tgtPath, "uploads"));
                    }
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "groups"), (File)new File(this._tgtPath, "groups"));
                        docMgr.copyResources(this._srcSite, this._tgtSite, "groups");
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT) && !this._cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "uploads/homepage"), (File)new File(this._tgtPath, "uploads/homepage"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "gradebook"), (File)new File(this._tgtPath, "gradebook"));
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) && this._cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "attempt"), (File)new File(this._tgtPath, "attempt"));
                        docMgr.copyResources(this._srcSite, this._tgtSite, "attempt");
                        docMgr.copyResources(this._srcSite, this._tgtSite, "attempt/grp");
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.SETTING) || this._cfg.isAreaIncluded(CloneConfig.Area.GLOSSARY)) {
                    CloneOperator.copyCourseGlossaryAndSettings(this._srcPath, this._tgtPath, this._cfg);
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "staffinformation"), (File)new File(this._tgtPath, "staffinformation"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.BLOG) || this._cfg.isAreaIncluded(CloneConfig.Area.JOURNAL)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "blog"), (File)new File(this._tgtPath, "blog"));
                    docMgr.copyResources(this._srcSite, this._tgtSite, "blog");
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.ALL) || this._cfg.isAreaIncluded(CloneConfig.Area.JOURNAL)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "pagebanner"), (File)new File(this._tgtPath, "pagebanner"));
                }
            }
            catch (Exception exc) {
                this._exc = exc;
                LogServiceFactory.getInstance().logError("Error in AsynchronousDirectoryClone", (Throwable)exc);
            }
        }

        public Exception getException() {
            return this._exc;
        }
    }
}

