/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.cxutil.CourseContentCopyUtil;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.helper.LessonPlanVtbeComponentDeepCopier;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.FormattedText;
import blackboard.data.content.Content;
import blackboard.data.content.ContentFile;
import blackboard.data.course.Course;
import blackboard.data.navigation.CourseToc;
import blackboard.data.syllabus.CourseSyllabus;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.contentsystem.data.Resource;
import blackboard.platform.contentsystem.data.ResourceFolder;
import blackboard.platform.contentsystem.manager.PrivateDocumentManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.LocationUtil;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.proxytool.ProxyToolManagerFactory;
import blackboard.platform.proxytool.ProxyToolUtil;
import blackboard.platform.proxytool.dao.ProxyTool;
import blackboard.platform.syllabus.CourseSyllabusManager;
import blackboard.platform.syllabus.CourseSyllabusXmlBuilder;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public class ContentCloneOperator
extends CloneOperator {
    public ContentCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long start = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
            return;
        }
        this.executeCartridgeCloneProcedure("course_contents_cp");
        this.executeCloneProcedure("files_ccf_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_contents_files_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("files_registries_ccf_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_content_group_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_contents_reviewed_cp", this._cfg.getMaximumTransactionCount());
        this.updateCourseCartridgeId();
        boolean hadWarnings = this.handleProxyToolCopies(this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT));
        if (hadWarnings) {
            this._cfg.setHadWarnings(hadWarnings);
        }
        this.doCallbackSegment(CloneCallback.Stage.CONTENT, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.content"), System.currentTimeMillis() - start);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "content");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    @Override
    protected void doLocalDirectoryPathTranslation(String strDirectory) throws Exception {
        Map<String, String> contentsMap = this.getDbBasedIdMap("COURSE_CONTENTS");
        File sourceDir = new File(strDirectory);
        String[] fileListing = FileUtil.getDirectoryListing((File)sourceDir);
        if (fileListing == null || fileListing.length == 0) {
            return;
        }
        for (int i = 0; i < fileListing.length; ++i) {
            File dir;
            if (!this.existsInTarget(fileListing[i]) || !(dir = new File(fileListing[i])).isDirectory()) continue;
            String strDestinationDir = CourseContentCopyUtil.resolveTextBasedMapping(contentsMap, dir.getPath());
            FileUtil.moveDirectory((File)dir, (File)new File(strDestinationDir));
        }
    }

    @Override
    protected void doPrivateDirectoryPathTranslation(String strDirectory) {
        Map<String, String> contentsMap = this.getDbBasedIdMap("COURSE_CONTENTS");
        File sourceDir = new File(strDirectory);
        String link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)sourceDir);
        PrivateDocumentManager pMgr = ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager();
        ResourceFolder folder = null;
        List strAllFiles = null;
        try {
            folder = pMgr.loadFolder(this._tgtSite, link);
            strAllFiles = folder.getDirectoryListing();
        }
        catch (KeyNotFoundException knf) {
            return;
        }
        catch (PersistenceException pe) {
            LogServiceFactory.getInstance().logDebug("Failed loading resource listing.", (Throwable)pe);
        }
        if (strAllFiles == null || strAllFiles.isEmpty()) {
            return;
        }
        for (String strResource : strAllFiles) {
            link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strResource));
            try {
                String strDestinationDir;
                Resource resource = pMgr.loadResource(this._tgtSite, link);
                if (resource.getType() == Resource.Type.FILE || StringUtil.isEqual((String)(strDestinationDir = CourseContentCopyUtil.resolveTextBasedMapping(contentsMap, strResource)), (String)strResource)) continue;
                pMgr.moveResources(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strResource)), LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strDestinationDir)));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Could not move resource:" + link, (Throwable)exc);
            }
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
            return;
        }
        this.updateEmbeddedDatabaseIdForMainData();
        this.updateEmbeddedDatabaseIdForExtendedData();
        this.updateEmbeddedDatabaseIdForFiles();
        this.updateEmbeddedDatabaseIdForSyllabuses();
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        csFileHandler.updateCSLinks(this._srcSite.getId(), this._tgtSite.getId(), Content.DATA_TYPE, this.getDbBasedIdMap("COURSE_CONTENTS"), this.getDbBasedIdMap("XYTHOS_DATAVALUES"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEmbeddedDatabaseIdForSyllabuses() throws Exception {
        PreparedStatement select = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            String qrySelect = "select pk1, title from COURSE_CONTENTS where crsmain_pk1 = ? and cnthndlr_handle = 'resource/x-bb-syllabus'";
            select = con.prepareStatement(qrySelect);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            ResultSet rst = select.executeQuery();
            while (rst.next()) {
                Id contentId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                String title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                this.updatedEmbeddedDatabaseIdForSyllabus(contentId, title);
            }
            DbUtil.close((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.close(select);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)select);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private void updatedEmbeddedDatabaseIdForSyllabus(Id contentId, String title) {
        try {
            Map<String, String> contentIdMap = this.getDbBasedIdMap("COURSE_CONTENTS");
            CourseSyllabusXmlBuilder builder = new CourseSyllabusXmlBuilder();
            File syllabusFile = new CourseSyllabusManager().getSyllabusFile(this._tgtSite, contentId);
            CourseSyllabus syllabus = builder.loadCourseSyllabus(syllabusFile);
            FormattedText description = this.updateCsLinks(contentIdMap, contentId, title, syllabus.getDescription());
            syllabus.setDescription(description);
            FormattedText learningObjectives = this.updateCsLinks(contentIdMap, contentId, title, syllabus.getLearningObjectives());
            syllabus.setLearningObjectives(learningObjectives);
            FormattedText requiredMaterials = this.updateCsLinks(contentIdMap, contentId, title, syllabus.getRequiredMaterials());
            syllabus.setRequiredMaterials(requiredMaterials);
            builder.createXmlFile(syllabus, syllabusFile);
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Failed to update embedded links in Syllabus with title: " + title, (Throwable)e);
        }
    }

    private FormattedText updateCsLinks(Map<String, String> contentIdMap, Id contentId, String title, FormattedText originalTextAsFormattedText) {
        String originalText;
        if (StringUtil.isEmpty((FormattedText)originalTextAsFormattedText)) {
            return originalTextAsFormattedText;
        }
        String updatedText = originalText = originalTextAsFormattedText.getText();
        if (contentIdMap != null && contentIdMap.containsValue(contentId.toExternalString())) {
            CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), contentId, title, "cx.import.copy.link.component.name.content.item");
            try {
                updatedText = this.parseVTBEText(originalText, resultSet);
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logError("Failed to update Course Files link in the Course Content with title: " + title, (Throwable)e);
            }
            this.addCsLinkStatus(resultSet);
        }
        return new FormattedText(updatedText, originalTextAsFormattedText.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForMainData() throws Exception {
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select pk1, main_data, title from COURSE_CONTENTS where crsmain_pk1 = ?";
        String qryUpdate = "update COURSE_CONTENTS set main_data = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(qrySelect);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            ResultSet rst = select.executeQuery();
            Map<String, String> filesIdMap = this.getDbBasedIdMap("FILES");
            Map<String, String> contentIdMap = this.getDbBasedIdMap("COURSE_CONTENTS");
            while (rst.next()) {
                Id contentId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Content.DATA_TYPE, (Container)this._pm.getContainer());
                String text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"main_data", null);
                String title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                if (text == null || text.length() == 0) continue;
                String replace = text;
                replace = CourseContentCopyUtil.resolveTextBasedMapping(filesIdMap, replace);
                if (contentIdMap != null && contentIdMap.containsValue(contentId.toExternalString())) {
                    CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), contentId, title, "cx.import.copy.link.component.name.content.item");
                    try {
                        replace = this.parseVTBEText(replace, resultSet);
                    }
                    catch (Exception e) {
                        LogServiceFactory.getInstance().logError("Failed to update Course Files link in the Course Content with title: " + title, (Throwable)e);
                    }
                    this.addCsLinkStatus(resultSet);
                }
                if (text.equals(replace)) continue;
                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                Bb5Util.setId((PreparedStatement)update, (int)2, (Id)contentId);
                update.execute();
            }
            DbUtil.close((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.close(select);
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)select);
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private void updateEmbeddedDatabaseIdForExtendedData() throws Exception {
        new LessonPlanVtbeComponentDeepCopier(this, this._tgtSite).updateEmbeddedDatabaseIdForExtendedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEmbeddedDatabaseIdForFiles() throws Exception {
        boolean copyCSItemsByArea = this._cfg.shouldCopyCSItemByArea();
        Map<String, String> filesIdMap = this.getDbBasedIdMap("FILES");
        if (filesIdMap.isEmpty()) {
            return;
        }
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select f.pk1, f.file_name, f.link_name, c.pk1, c.title, c.cnthndlr_handle from FILES f, COURSE_CONTENTS c, COURSE_CONTENTS_FILES t where c.pk1 = t.course_contents_pk1 and t.files_pk1 = f.pk1 and c.crsmain_pk1 = ? and f.storage_type = 'CS'";
        String qryUpdate = "update FILES set file_name = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(qrySelect);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            ResultSet rst = select.executeQuery();
            Map<String, String> xythosIdMap = this.getDbBasedIdMap("XYTHOS_DATAVALUES");
            CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
            while (rst.next()) {
                Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)ContentFile.DATA_TYPE, (Container)this._pm.getContainer());
                String fileName = DbUtil.getString((ResultSet)rst, (String)"file_name", null);
                String linkName = DbUtil.getString((ResultSet)rst, (String)"link_name", null);
                String contentTitle = DbUtil.getString((ResultSet)rst, (String)"title", null);
                if (!StringUtil.notEmpty((String)fileName) || !filesIdMap.containsValue(cId.toExternalString())) continue;
                CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), cId, contentTitle, "cx.import.copy.link.component.name.content.item");
                try {
                    String newFileName = csFileHandler.copyCSFileByXythosIdUrl(fileName, this._cfg.getSrcHomeDir(), this._cfg.getCsDir(), this._tgtSite, this._srcSite, copyCSItemsByArea, xythosIdMap, linkName, resultSet, true, this._cfg.isFromAdminPanel(), this._cfg.getExcludedCsFolderIds());
                    if (StringUtil.notEmpty((String)newFileName) && !StringUtil.isEqual((String)fileName, (String)newFileName)) {
                        DbUtil.setString((PreparedStatement)update, (int)1, (String)newFileName);
                        Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                        update.execute();
                    }
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to update Course Files link for the File with link name: " + linkName, (Throwable)e);
                }
                this.addCsLinkStatus(resultSet);
            }
            DbUtil.close((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.close(select);
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)select);
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected CourseToc matchTocByAttributes(CourseToc srcToc, List<CourseToc> tgtTocList) {
        for (CourseToc toc : tgtTocList) {
            String srcLabel = srcToc.getPersistentLabel();
            String destLabel = toc.getPersistentLabel();
            String srcHandle = srcToc.getInternalHandle();
            String destHandle = toc.getInternalHandle();
            if (ObjectUtils.equals((Object)srcLabel, (Object)destLabel) && srcToc.getTargetType() == toc.getTargetType() && ObjectUtils.equals((Object)srcHandle, (Object)destHandle)) {
                return toc;
            }
            if (ObjectUtils.equals((Object)srcLabel, (Object)destLabel) || srcToc.getTargetType() != toc.getTargetType() || !ObjectUtils.equals((Object)srcHandle, (Object)destHandle)) continue;
            if (!srcLabel.startsWith("COURSE_DEFAULT") && destLabel.startsWith("COURSE_DEFAULT")) {
                int tocPos = destLabel.indexOf(".");
                String tocSec = destLabel.substring(tocPos + 1);
                int tocPosSec = tocSec.indexOf(".");
                String tocFin = tocSec.substring(0, tocPosSec);
                String tocFinLabel = tocFin + ".label";
                if (srcLabel.equals(tocFin) || srcLabel.endsWith(tocFinLabel)) {
                    return toc;
                }
            }
            if (!srcLabel.startsWith("COURSE_DEFAULT") || destLabel.startsWith("COURSE_DEFAULT")) continue;
            String tmp = srcLabel;
            int srcTocPos = tmp.indexOf(".");
            String srcTocSec = tmp.substring(srcTocPos + 1);
            int srcTocPostSec = srcTocSec.indexOf(".");
            String srcTocFin = srcTocSec.substring(0, srcTocPostSec);
            String srcTocFinLabel = srcTocFin + ".label";
            if (!destLabel.equals(srcTocFin) && !destLabel.endsWith(srcTocFinLabel)) continue;
            return toc;
        }
        return null;
    }

    protected CourseToc matchTocById(Id id, List<CourseToc> srcTocList) {
        for (CourseToc toc : srcTocList) {
            if (!toc.getId().equals((Object)id)) continue;
            return toc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleProxyToolCopies(boolean exact) throws Exception {
        boolean bl;
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        boolean hadWarnings = false;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select tk.old_pk1, tk.new_pk1, pt.pk1, pl.url, ch.handle from tmp_key_maps tk, course_contents cc, content_handlers ch, proxy_tools pt, proxy_links pl where session_id = ? and table_name = ?  and tk.old_pk1 = cc.pk1 and cc.cnthndlr_handle = ch.handle and ch.proxy_tools_pk1 = pt.pk1 and pt.active_ind = 'Y' and pt.available_ind = 'Y' and pt.pk1 = pl.proxy_tools_pk1 and pl.link_type = 'content-copied' and pl.content_handlers_pk1 = ch.pk1");
            stmt.setString(1, this._sessionId);
            stmt.setString(2, "COURSE_CONTENTS");
            rst = stmt.executeQuery();
            while (rst.next()) {
                Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)Content.DATA_TYPE, (Container)this._pm.getContainer());
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Content.DATA_TYPE, (Container)this._pm.getContainer());
                Id ptId = Bb5Util.unmarshallId((ResultSet)rst, (String)"pk1", (DataType)ProxyTool.DATA_TYPE, (Container)this._pm.getContainer());
                String url = rst.getString("url");
                String handle = rst.getString("handle");
                if (oldId == null || newId == null || ptId == null || url == null || url.trim().length() == 0) continue;
                ProxyTool proxyTool = ProxyToolManagerFactory.getInstance().loadToolById(ptId);
                boolean res = ProxyToolUtil.getInstance().sendContentCopiedEx(proxyTool, handle, oldId, this._srcSite.getId(), newId, this._tgtSite.getId(), url, null, exact);
                if (res) continue;
                LogServiceFactory.getInstance().logError("Failed to copy proxy tool content for Tool:" + ptId.toExternalString() + " at " + proxyTool.getBaseurl() + " for " + proxyTool.getOurGuid() + ", Original Content Id: " + oldId.toExternalString());
                hadWarnings = true;
            }
            bl = hadWarnings;
        }
        catch (Throwable throwable) {
            DbUtil.close(rst);
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((ResultSet)rst);
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCourseCartridgeId() throws Exception {
        Connection con = null;
        PreparedStatement stmt = null;
        String qryUpdate = "update course_main set cartridge_pk1 = ? where batch_uid = ?";
        if (this._srcSite.getCartridgeId() == null || !this._srcSite.getCartridgeId().isSet()) {
            return;
        }
        if (this._tgtSite.getCartridgeId() != null && this._tgtSite.getCartridgeId().isSet()) {
            return;
        }
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_CARTRIDGE)) {
            return;
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._srcSite.getCartridgeId());
            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)2, (String)this._tgtSite.getBatchUid());
            stmt.execute();
            this._tgtSite.setCartridgeId(this._srcSite.getCartridgeId());
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCartridgeCloneProcedure(String procedureName) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CartridgeCloneQuery.getCloneQuery(procedureName, con);
            CartridgeCloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, this._cfg.getMaximumTransactionCount(), this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK), stmt);
            stmt.execute();
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    static class CartridgeCloneQuery {
        CartridgeCloneQuery() {
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con) throws SQLException {
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, boolean bGradebook, CallableStatement stmt) throws SQLException {
            String cartridgeInd = "N";
            if (tgtCourse.getCartridgeId() == null || !tgtCourse.getCartridgeId().isSet() || srcCourse.getCartridgeId().equals((Object)tgtCourse.getCartridgeId())) {
                cartridgeInd = "Y";
            }
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setString(3, cartridgeInd);
            stmt.setInt(4, commitFrequency);
            stmt.setString(5, sessionId);
            DbUtil.setString((PreparedStatement)stmt, (int)6, (String)DbUtil.booleanToYN((!bGradebook ? 1 : 0) != 0));
        }
    }
}

