/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.platform.contentsystem.manager.DocumentManagerEx;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.util.Map;

public class CourseFilesCloneOperator
extends CloneOperator {
    public CourseFilesCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        try {
            Map<String, String> idMap = this.getDbBasedIdMap("XYTHOS_DATAVALUES");
            if (this._cfg.shouldCopyAnyCSItems()) {
                CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
                this.initCourseFilesFolder(this._cfg, csFileHandler, idMap);
                if (this._cfg.shouldCopyAllCSItems()) {
                    String homeDir = this._cfg.getSrcHomeDir();
                    String csDir = this._cfg.getCsDir();
                    csFileHandler.copyCourseFiles(homeDir, csDir, idMap, this._tgtSite, this._srcSite, this._cfg);
                }
            }
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Failed to copy course files", (Throwable)e);
        }
    }

    private void initCourseFilesFolder(CloneConfig config, CSFileCopyHandler handler, Map<String, String> idMap) throws FileSystemException {
        CloneConfig.CopyType copyType = config.getCopyType();
        CSFileCopyHandler.Operation operation = copyType == CloneConfig.CopyType.COPY_EXACT_COURSE ? CSFileCopyHandler.Operation.CopyExact : CSFileCopyHandler.Operation.Copy;
        if (config.getCsDirVerified()) {
            config.resetCsDir();
        }
        String csDir = handler.getCSDir(config.getRawCsDir(), this._tgtSite, operation, idMap, !config.getCsDirVerified());
        config.setCsDir(csDir);
        config.setCsDirVerified(true);
        if (StringUtil.notEmpty((String)csDir)) {
            handler.updateACL(config.getCsDir(), this._tgtSite.getCourseId(), this._tgtSite.isOrganization());
        }
        DocumentManagerEx mgr = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
        config.setSrcHomeDir(mgr.getHomeDirectory(this._srcSite));
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return null;
    }
}

