/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.cxutil.CourseContentCopyUtil;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.helper.LessonPlanVtbeComponentDeepCopier;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.content.Content;
import blackboard.data.course.Course;
import blackboard.data.navigation.CourseToc;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionManager;
import blackboard.db.DatabaseTransaction;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.content.ContentDbLoader;
import blackboard.persist.content.ContentDbPersister;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.persist.navigation.CourseTocDbPersister;
import blackboard.platform.content.event.ContentLifecycleEventManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.LocationUtil;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CourseTocCloneOperator
extends ContentCloneOperator {
    private final ArrayList<AsynchronousDirectoryClone> _threadList = new ArrayList();

    public CourseTocCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || !this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            return;
        }
        Map<CourseToc, CourseToc> tocMap = this.reconcileCourseToc();
        for (Map.Entry<CourseToc, CourseToc> entry : tocMap.entrySet()) {
            CourseToc srcToc = entry.getKey();
            CourseToc tgtToc = entry.getValue();
            if (srcToc.getTargetType() == CourseToc.Target.CONTENT_ITEM) {
                this.executeContentItemCourseTocCloneProcedure(srcToc);
                continue;
            }
            if (srcToc.getContentId() == null || srcToc.getContentId() == Id.UNSET_ID) continue;
            this.executeCourseTocCloneProcedure(srcToc, tgtToc);
        }
        this.copyCourseGroupAssociations();
        this.updateCourseCartridgeId();
        this.handleDirectoryIdMapping();
        boolean hadWarnings = this.handleProxyToolCopies(this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT));
        if (hadWarnings) {
            this._cfg.setHadWarnings(hadWarnings);
        }
        this.doCallbackSegment(CloneCallback.Stage.COURSE_TOC, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc"), System.currentTimeMillis() - lStart);
    }

    private void copyCourseGroupAssociations() {
        if (this._cfg.isAreaIncluded(CloneConfig.Area.GROUP) && this._cfg.getCopyType() != CloneConfig.CopyType.COPY_EXACT_COURSE) {
            try {
                this.executeCloneProcedure("course_content_group_cp", this._cfg.getMaximumTransactionCount());
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logError("Failed to copy course groups.  Group attendance will not be copied", (Throwable)e);
            }
        }
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || !this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            return;
        }
        Exception exc = null;
        for (AsynchronousDirectoryClone thread : this._threadList) {
            thread.join();
            if (exc != null) continue;
            exc = thread.getException();
        }
        if (exc != null) {
            throw exc;
        }
    }

    private void executeContentItemCourseTocCloneProcedure(final CourseToc srcToc) throws Exception {
        ConnectionManager cm = this._bbDatabase.getConnectionManager();
        cm.performTransaction(new DatabaseTransaction("executeContentItemCourseTocCloneProcedure"){

            public void run(Connection con) throws PersistenceException, ValidationException {
                CallableStatement stmt = null;
                try {
                    stmt = con.prepareCall("{ call course_contents_copyx ( ?, ?, ?, ?, ?, ?, ?, ? ) }");
                    Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)CourseTocCloneOperator.this._srcSite.getId());
                    Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)srcToc.getContentId());
                    Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)CourseTocCloneOperator.this._tgtSite.getId());
                    Bb5Util.setId((PreparedStatement)stmt, (int)4, null);
                    DbUtil.setInteger((PreparedStatement)stmt, (int)5, (int)1);
                    DbUtil.setString((PreparedStatement)stmt, (int)6, (String)CourseTocCloneOperator.this._sessionId);
                    DbUtil.setString((PreparedStatement)stmt, (int)7, (String)DbUtil.booleanToYN((boolean)CourseTocCloneOperator.this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_CARTRIDGE)));
                    stmt.registerOutParameter(8, 12);
                    stmt.execute();
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)stmt);
                }
            }
        });
    }

    private void executeCourseTocCloneProcedure(final CourseToc srcToc, final CourseToc tgtToc) throws Exception {
        ConnectionManager cm = this._bbDatabase.getConnectionManager();
        cm.performTransaction(new DatabaseTransaction("executeCourseTocCloneProcedure"){

            public void run(Connection con) throws PersistenceException, ValidationException {
                CallableStatement stmt = null;
                try {
                    StringBuilder sqlStmt = new StringBuilder();
                    sqlStmt.append("{ call one_course_content_cp");
                    sqlStmt.append(" ( ?, ?, ?, ?, ?, ?, ? ) } ");
                    stmt = con.prepareCall(sqlStmt.toString());
                    Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)CourseTocCloneOperator.this._srcSite.getId());
                    Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)srcToc.getContentId());
                    Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)CourseTocCloneOperator.this._tgtSite.getId());
                    Bb5Util.setId((PreparedStatement)stmt, (int)4, (Id)tgtToc.getContentId());
                    stmt.setString(5, CourseTocCloneOperator.this._sessionId);
                    DbUtil.setString((PreparedStatement)stmt, (int)6, (String)DbUtil.booleanToYN((!CourseTocCloneOperator.this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK) ? 1 : 0) != 0));
                    DbUtil.setString((PreparedStatement)stmt, (int)7, (String)DbUtil.booleanToYN((boolean)CourseTocCloneOperator.this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_CARTRIDGE)));
                    stmt.execute();
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(stmt);
                        throw throwable;
                    }
                }
                DbUtil.close((Statement)stmt);
            }
        });
    }

    private Map<CourseToc, CourseToc> reconcileCourseToc() throws Exception {
        HashMap<CourseToc, CourseToc> tocMap = new HashMap<CourseToc, CourseToc>();
        CourseTocDbLoader cLoader = CourseTocDbLoader.Default.getInstance();
        CourseTocDbPersister cPersister = (CourseTocDbPersister)CourseTocDbPersister.Default.getInstance();
        ContentDbLoader cntLoader = ContentDbLoader.Default.getInstance();
        ContentDbPersister cntPersister = ContentDbPersister.Default.getInstance();
        BbList srcTocList = cLoader.loadByCourseId(this._srcSite.getId());
        BbList tgtTocList = cLoader.loadByCourseId(this._tgtSite.getId());
        List<String> list = this._cfg.getCourseTocIdList();
        for (String idStr : list) {
            Id id = Id.generateId((DataType)CourseToc.DATA_TYPE, (String)idStr);
            CourseToc srcToc = this._cfg.getRegisteredCourseToc(id);
            if (srcToc == null) {
                srcToc = this.matchTocById(id, (List<CourseToc>)srcTocList);
            }
            if (srcToc == null) {
                throw new PersistenceException(ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc.noresolve"));
            }
            if (srcToc.getTargetType() == CourseToc.Target.CONTENT_ITEM) {
                tocMap.put(srcToc, null);
                continue;
            }
            CourseToc tgtToc = this.matchTocByAttributes(srcToc, (List<CourseToc>)tgtTocList);
            if (tgtToc == null) {
                Content tgtCnt = null;
                if (srcToc.getContentId() != null && srcToc.getContentId() != Id.UNSET_ID) {
                    Content srcCnt = cntLoader.loadById(srcToc.getContentId());
                    tgtCnt = this.cloneContent(cntPersister, srcCnt);
                }
                tgtToc = this.cloneCourseToc(cPersister, srcToc, tgtCnt);
                tgtTocList.add(tgtToc);
            }
            tocMap.put(srcToc, tgtToc);
        }
        return tocMap;
    }

    private Content cloneContent(ContentDbPersister cntPersister, Content srcCnt) throws ValidationException, PersistenceException {
        Content tgtCnt = new Content();
        tgtCnt.setAllowGuests(srcCnt.getAllowGuests());
        tgtCnt.setAllowObservers(srcCnt.getAllowObservers());
        tgtCnt.setBody(srcCnt.getBody());
        tgtCnt.setContentHandler(srcCnt.getContentHandler());
        tgtCnt.setStartDate(srcCnt.getStartDate());
        tgtCnt.setEndDate(srcCnt.getEndDate());
        tgtCnt.setIsAvailable(srcCnt.getIsAvailable());
        tgtCnt.setIsDescribed(srcCnt.getIsDescribed());
        tgtCnt.setIsFolder(srcCnt.getIsFolder());
        tgtCnt.setIsFromCartridge(srcCnt.getIsFromCartridge());
        tgtCnt.setIsLesson(srcCnt.getIsLesson());
        tgtCnt.setIsSequential(srcCnt.getIsSequential());
        tgtCnt.setIsTracked(srcCnt.getIsTracked());
        tgtCnt.setLaunchInNewWindow(srcCnt.getLaunchInNewWindow());
        tgtCnt.setOfflineName(srcCnt.getOfflineName());
        tgtCnt.setOfflinePath(srcCnt.getOfflinePath());
        tgtCnt.setRenderType(srcCnt.getRenderType());
        tgtCnt.setTitle(srcCnt.getPersistentTitle());
        tgtCnt.setTitleColor(srcCnt.getTitleColor());
        tgtCnt.setUrl(srcCnt.getUrl());
        tgtCnt.setCourseId(this._tgtSite.getId());
        tgtCnt.setId(Id.UNSET_ID);
        tgtCnt.setViewMode(srcCnt.getViewMode());
        tgtCnt.setExtendedData(srcCnt.getExtendedData());
        ContentLifecycleEventManager.setEventContext((BbObject)tgtCnt, (ContentLifecycleEventManager.EventContext)ContentLifecycleEventManager.EventContext.CourseCopy);
        cntPersister.persist(tgtCnt);
        return tgtCnt;
    }

    private CourseToc cloneCourseToc(CourseTocDbPersister cPersister, CourseToc srcToc, Content tgtCnt) throws Exception {
        CourseToc tgtToc = new CourseToc();
        tgtToc.setAllowGuests(srcToc.getAllowGuests());
        tgtToc.setAllowObservers(srcToc.getAllowObservers());
        String internalHandle = srcToc.getInternalHandle();
        if (StringUtil.isEmpty((String)internalHandle)) {
            internalHandle = null;
        }
        tgtToc.setInternalHandle(internalHandle);
        tgtToc.setIsEnabled(srcToc.getIsEnabled());
        tgtToc.setIsEntryPoint(srcToc.getIsEntryPoint());
        tgtToc.setLabel(srcToc.getPersistentLabel());
        tgtToc.setLaunchInNewWindow(srcToc.getLaunchInNewWindow());
        tgtToc.setTargetType(srcToc.getTargetType());
        tgtToc.setUrl(srcToc.getUrl());
        tgtToc.setCourseId(this._tgtSite.getId());
        if (tgtCnt != null) {
            tgtToc.setContentId(tgtCnt.getId());
        }
        cPersister.persist(tgtToc);
        this.saveNewKey("COURSE_TOC", srcToc.getId(), tgtToc.getId());
        return tgtToc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDirectoryIdMapping() throws Exception {
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        File srcPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._srcSite.getCourseId());
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select * from tmp_key_maps where session_id = ? and table_name = ? order by table_name desc");
            stmt.setString(1, this._sessionId);
            stmt.setString(2, "COURSE_CONTENTS");
            rst = stmt.executeQuery();
            AsynchronousDirectoryClone thread = new AsynchronousDirectoryClone();
            while (rst.next()) {
                Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                if (oldId == null || newId == null) continue;
                thread.addPaths(new File(srcPath, "content" + File.separator + oldId.toExternalString()), new File(tgtPath, "content" + File.separator + newId.toExternalString()));
                this._threadList.add(thread);
            }
            thread.start();
        }
        catch (Throwable throwable) {
            DbUtil.close(rst);
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((ResultSet)rst);
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || !this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            return;
        }
        this.updateEmbeddedDatabaseIdForMainData();
        this.updateEmbeddedDatabaseIdForExtendedData();
        this.updateEmbeddedDatabaseIdForFiles();
        this.updateEmbeddedDatabaseIdForSyllabuses();
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        csFileHandler.updateCSLinks(this._srcSite.getId(), this._tgtSite.getId(), Content.DATA_TYPE, this.getDbBasedIdMap("COURSE_CONTENTS"), this.getDbBasedIdMap("XYTHOS_DATAVALUES"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForMainData() throws Exception {
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select pk1, main_data, title from COURSE_CONTENTS where crsmain_pk1 = ? and pk1 in ( select new_pk1 from tmp_key_maps where session_id = ? and table_name='COURSE_CONTENTS' )";
        String qryUpdate = "update COURSE_CONTENTS set main_data = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(qrySelect);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            select.setString(2, this._sessionId);
            ResultSet rst = select.executeQuery();
            Map<String, String> filesIdMap = this.getDbBasedIdMap("FILES");
            Map<String, String> contentIdMap = this.getDbBasedIdMap("COURSE_CONTENTS");
            while (rst.next()) {
                Id contentId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Content.DATA_TYPE, (Container)this._pm.getContainer());
                String text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"main_data", null);
                String title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                if (text == null || text.length() == 0) continue;
                String replace = text;
                replace = CourseContentCopyUtil.resolveTextBasedMapping(filesIdMap, replace);
                if (contentIdMap != null && contentIdMap.containsValue(contentId.toExternalString())) {
                    CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), contentId, title, "cx.import.copy.link.component.name.content.item");
                    try {
                        replace = this.parseVTBEText(replace, resultSet);
                    }
                    catch (Exception e) {
                        LogServiceFactory.getInstance().logError("Failed to update Course Files link in the Course Content with title: " + title, (Throwable)e);
                    }
                    this.addCsLinkStatus(resultSet);
                }
                if (text.equals(replace)) continue;
                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                Bb5Util.setId((PreparedStatement)update, (int)2, (Id)contentId);
                update.execute();
            }
            DbUtil.close((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.close(select);
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)select);
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private void updateEmbeddedDatabaseIdForExtendedData() throws Exception {
        new LessonPlanVtbeComponentDeepCopier(this, this._tgtSite).updateEmbeddedDatabaseIdForExtendedData();
    }

    private class AsynchronousDirectoryClone
    extends Thread {
        private final Map<File, File> _map;
        StringBuffer _sb;

        public AsynchronousDirectoryClone() {
            super("CloneOperator$AsynchronousDirectoryClone");
            this._map = new HashMap<File, File>();
            this._sb = new StringBuffer();
        }

        public void addPaths(File srcPath, File tgtPath) {
            this._map.put(srcPath, tgtPath);
        }

        @Override
        public void run() {
            for (Map.Entry<File, File> entry : this._map.entrySet()) {
                File srcPath = entry.getKey();
                File tgtPath = entry.getValue();
                try {
                    if (srcPath.exists()) {
                        FileUtil.copyDirectory((File)srcPath, (File)tgtPath);
                    }
                    String srcLink = LocationUtil.getRelativeLink((String)CourseTocCloneOperator.this._srcSite.getCourseId(), (File)srcPath);
                    String tgtLink = LocationUtil.getRelativeLink((String)CourseTocCloneOperator.this._tgtSite.getCourseId(), (File)tgtPath);
                    ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager().copyResources(CourseTocCloneOperator.this._srcSite, CourseTocCloneOperator.this._tgtSite, srcLink, tgtLink);
                }
                catch (Exception exc) {
                    LogServiceFactory.getInstance().logError("Failed to copy local folder/private document folder", (Throwable)exc);
                    this._sb.append(exc.getLocalizedMessage());
                    this._sb.append(" ");
                }
            }
        }

        public Exception getException() {
            if (this._sb.length() > 0) {
                return new Exception(this._sb.toString());
            }
            return null;
        }
    }
}

