/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CourseContentCopyUtil;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.contentsystem.data.Resource;
import blackboard.platform.contentsystem.data.ResourceFolder;
import blackboard.platform.contentsystem.manager.PrivateDocumentManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.LocationUtil;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.Map;

public class DropBoxCloneOperator
extends CloneOperator {
    public DropBoxCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
            return;
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("files_cuu_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("course_user_uploads_cp", this._cfg.getMaximumTransactionCount());
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.GROUP) && this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("files_gu_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("group_uploads_cp", this._cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.DROP_BOX, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.dropbox"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return this.getDirectoryTranslation(dir, "FILES");
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "uploads");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
        this.doLocalContentDirectoryTranslation();
        this.doPrivateDirectoryTranslation();
    }

    public void doLocalContentDirectoryTranslation() throws Exception {
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        File sourceDir = new File(tgtPath.getAbsolutePath());
        Map<String, String> groupsMap = this.getDbBasedIdMap("GROUPS");
        Map<String, String> fileMap = this.getDbBasedIdMap("FILES");
        String[] fileListing = FileUtil.getDirectoryListing((File)(sourceDir = new File(sourceDir, "groups")));
        if (fileListing == null || fileListing.length == 0) {
            return;
        }
        for (String element : fileListing) {
            String[] subListing;
            File dir = new File(element);
            if (!dir.isDirectory()) continue;
            String strDestinationDir = CourseContentCopyUtil.resolveTextBasedMapping(groupsMap, dir.getPath());
            File groupDirectory = new File(strDestinationDir);
            FileUtil.moveDirectory((File)dir, (File)groupDirectory);
            for (String element2 : subListing = FileUtil.getDirectoryListing((File)new File(strDestinationDir))) {
                File subDir = new File(element2);
                if (!subDir.isDirectory()) continue;
                String childDirectory = subDir.getName();
                childDirectory = CourseContentCopyUtil.resolveTextBasedMapping(fileMap, childDirectory);
                FileUtil.moveDirectory((File)subDir, (File)new File(groupDirectory, childDirectory));
            }
        }
    }

    public void doPrivateDirectoryTranslation() throws Exception {
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        File sourceDir = new File(tgtPath.getAbsolutePath());
        Map<String, String> groupsMap = this.getDbBasedIdMap("GROUPS");
        Map<String, String> fileMap = this.getDbBasedIdMap("FILES");
        sourceDir = new File(sourceDir, "groups");
        PrivateDocumentManager pMgr = ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager();
        ResourceFolder folder = null;
        List fileListing = null;
        try {
            folder = pMgr.loadFolder(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)sourceDir));
            fileListing = folder.getDirectoryListing();
        }
        catch (KeyNotFoundException knf) {
            return;
        }
        catch (PersistenceException pe) {
            LogServiceFactory.getInstance().logDebug("Failed loading resource listing.", (Throwable)pe);
        }
        if (fileListing == null || fileListing.isEmpty()) {
            return;
        }
        for (String element : fileListing) {
            String link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(element));
            try {
                String strDestinationDir;
                Resource resource = pMgr.loadResource(this._tgtSite, link);
                if (resource.getType() == Resource.Type.FILE || StringUtil.isEqual((String)(strDestinationDir = CourseContentCopyUtil.resolveTextBasedMapping(groupsMap, element)), (String)element)) continue;
                pMgr.moveResources(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(element)), LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strDestinationDir)));
                ResourceFolder aFolder = pMgr.loadFolder(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strDestinationDir)));
                List subListing = aFolder.getDirectoryListing();
                if (subListing == null || subListing.isEmpty()) continue;
                for (String element2 : subListing) {
                    String childDirectory;
                    String link2 = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(element2));
                    Resource resource2 = pMgr.loadResource(this._tgtSite, link2);
                    if (resource2.getType() == Resource.Type.FILE || StringUtil.isEqual((String)(childDirectory = CourseContentCopyUtil.resolveTextBasedMapping(fileMap, element2)), (String)element2)) continue;
                    pMgr.moveResources(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(element2)), LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(childDirectory)));
                }
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Could not move resource:" + link, (Throwable)exc);
            }
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }
}

