/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.util.FileUtil;
import java.io.File;

public class GlossaryCloneOperator
extends CloneOperator {
    public static final String GLOSSARY_PROPERTIES = "glossary.properties";
    public static final String GLOSSARY_HTML = "glossary_r7.html";
    public static final String GLOSSARY_CSV = "glossary_export.xls";
    public static final String GLOSSARY_PANEL = "gloss_panel.html";

    public GlossaryCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GLOSSARY)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        FileUtil.delete((File)new File(tgtPath, GLOSSARY_CSV));
        FileUtil.delete((File)new File(tgtPath, GLOSSARY_HTML));
        FileUtil.delete((File)new File(tgtPath, GLOSSARY_PANEL));
        this.doCallbackSegment(CloneCallback.Stage.GLOSSARY, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.glossary"), System.currentTimeMillis() - lStart);
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }
}

