/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.data.gradebook.impl.Attempt;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.contentsystem.data.ResourceFile;
import blackboard.platform.contentsystem.manager.IDocumentManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.gradebook2.AttemptStagedGrading;
import blackboard.platform.gradebook2.DelegatedGrader;
import blackboard.platform.gradebook2.GradableItem;
import blackboard.platform.gradebook2.GradeDetail;
import blackboard.platform.gradebook2.GradeHistoryEntry;
import blackboard.platform.gradebook2.GradebookPrivateDocumentStoreUtil;
import blackboard.platform.gradebook2.GroupAttempt;
import blackboard.platform.gradebook2.GroupAttemptStagedGrading;
import blackboard.platform.gradebook2.impl.GradableItemDAO;
import blackboard.platform.gradebook2.impl.ReconcilerHelper;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.CollectionUtils;
import blackboard.util.FileUtil;
import blackboard.util.IOUtil;
import blackboard.util.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class GradebookCloneOperator
extends CloneOperator {
    private static final String ATTEMPT = "attempt";
    private static final String GRADEBOOK_LOG = "gradebook_log";
    private static final String GROUP_ATTEMPT = "group_attempt";
    private static final String GRADEBOOK_GRADE = "gradebook_grade";
    private static final String INSTRUCTOR_NOTES = "instructor_notes";
    private static final String INSTRUCTOR_COMMENTS = "instructor_comments";
    private static final String COMMENTS = "comments";
    private static final String FOR_STUDENT_COMMENTS = "for_student_comments";
    private static final String GRADEBOOK_GRADE_ID_MAP = "GRADEBOOK_GRADE";
    private static final String GROUP_ATTEMPT_ID_MAP = "GROUP_ATTEMPT";
    private static final String GRADEBOOK_MAIN_ID_MAP = "GRADEBOOK_MAIN";
    private static final String ATTEMPT_ID_MAP = "ATTEMPT";
    private static final String STAGED_ATTEMPT_ID_MAP = "ATTEMPT_STAGED_GRADING";
    private static final String STAGED_GROUP_ATTEMPT_ID_MAP = "GROUP_ATTEMPT_STAGED_GRADING";
    private static final String GRADEBOOK_LOG_ID_MAP = "GRADEBOOK_LOG";
    private boolean _translatingGroupAttempt = false;

    public GradebookCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
            return;
        }
        boolean deleteExisting = this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK_CLEAR);
        if (deleteExisting) {
            this.executeGradebookProcedure("cleanup_dst_gradebook");
        }
        this.executeCloneProcedure("gradebook_type_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_grading_period_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gb_student_info_layout_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_translator_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_symbol_cp", this._cfg.getMaximumTransactionCount());
        boolean includeGrades = this._cfg.isAreaIncluded(CloneConfig.Area.GRADES);
        this.executeCloneProcedureForGb("gradebook_main_cp", this._cfg.getMaximumTransactionCount(), includeGrades);
        this.executeCloneProcedureForGb("gradebook_formula_cp", this._cfg.getMaximumTransactionCount(), includeGrades);
        this.executeCloneProcedureForGb("gradebook_custom_view_cp", this._cfg.getMaximumTransactionCount(), includeGrades);
        this.executeCloneProcedureForGb("gradebook_settings_cp", this._cfg.getMaximumTransactionCount(), deleteExisting);
        this.executeCloneProcedureForGb("gradebook_color_scheme_cp", this._cfg.getMaximumTransactionCount(), deleteExisting);
        this.executeCloneProcedure("interactive_count_col_def_cp", this._cfg.getMaximumTransactionCount());
        if (includeGrades && this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("group_attempt_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("gradebook_grade_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("gradebook_log_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("gradebook_courseusers_ext_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("qti_result_data_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("attempt_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("update_gradebook_grade_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("files_af_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("attempt_files_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("group_attempt_files_cp", this._cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("interactive_count_cp", this._cfg.getMaximumTransactionCount());
            this.executeDelegatedGradersClone();
            this.executeStagedGradingClone();
        } else if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeDelegatedGradersClone();
        } else {
            GradableItemDAO gradableItemDAO = GradableItemDAO.get();
            List gradableItems = gradableItemDAO.getGradableItemByCourse(this._tgtSite.getId());
            Set reconcilerUserIdsWithinCourse = new ReconcilerHelper(this._tgtSite.getId()).getReconcilerUserIdsWithinCourse();
            for (GradableItem gradableItem : gradableItems) {
                if (!gradableItem.isDelegatedGrading()) continue;
                for (Id reconcilerUserIdWithinCourse : reconcilerUserIdsWithinCourse) {
                    DelegatedGrader grader = new DelegatedGrader();
                    grader.setUserId(reconcilerUserIdWithinCourse);
                    grader.setType(DelegatedGrader.GraderType.ALL);
                    gradableItem.addDelegatedGrader(grader, false);
                }
                if (!CollectionUtils.notEmpty((Collection)reconcilerUserIdsWithinCourse)) continue;
                gradableItemDAO.persist(gradableItem);
            }
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.RUBRIC)) {
            this.executeCloneProcedure("rubric_assoc_gb_cp", this._cfg.getMaximumTransactionCount());
            if (includeGrades && this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
                this.executeCloneProcedure("rubric_eval_cp", this._cfg.getMaximumTransactionCount());
            }
        }
        this.doCallbackSegment(CloneCallback.Stage.GRADEBOOK, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.gradebook"), System.currentTimeMillis() - lStart);
    }

    private void executeStagedGradingClone() throws Exception {
        this.executeCloneProcedure("attempt_staged_grading_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("grp_attempt_staged_grading_cp", this._cfg.getMaximumTransactionCount());
    }

    private void executeDelegatedGradersClone() throws Exception {
        this.executeCloneProcedure("delegated_grader_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("delegated_grader_user_cp", this._cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("delegated_grader_group_cp", this._cfg.getMaximumTransactionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeGradebookProcedure(String procedureName) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareCall("{ call " + procedureName + " ( ? ) } ");
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._tgtSite.getId());
            stmt.execute();
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        if (this._translatingGroupAttempt) {
            return this.getDirectoryTranslation(dir, GROUP_ATTEMPT_ID_MAP);
        }
        return this.getDirectoryTranslation(dir, ATTEMPT_ID_MAP);
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        File gbPath = new File(tgtPath, "gradebook");
        File cachePath = new File(gbPath, "cache");
        if (cachePath.exists()) {
            FileUtil.delete((File)cachePath);
        }
        this.doDirectoryPathTranslation(gbPath.getAbsolutePath());
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) && this._cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
            this._translatingGroupAttempt = false;
            File attemptDir = new File(tgtPath, ATTEMPT);
            this.doDirectoryPathTranslation(attemptDir.getAbsolutePath());
            File groupAttemptDir = new File(attemptDir, "grp");
            this._translatingGroupAttempt = true;
            this.doDirectoryPathTranslation(groupAttemptDir.getAbsolutePath());
            this._translatingGroupAttempt = false;
        }
        if (GradebookPrivateDocumentStoreUtil.hasEmbeddedGradingNotesAndFeedbackFiles((Course)this._srcSite)) {
            List notesAndFeedabackFiles = GradebookPrivateDocumentStoreUtil.getAllEmbeddedGradingNotesAndFeedbackFiles((Course)this._srcSite);
            for (String notesAndFeedabackFile : notesAndFeedabackFiles) {
                this.copyPrivateFileToTargetCourse(notesAndFeedabackFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPrivateFileToTargetCourse(String fullPathOfSrcFile) throws PersistenceException, KeyNotFoundException {
        String relativePathToTargetFile;
        Matcher matcher = GradebookPrivateDocumentStoreUtil.GRADE_COMMENTS_URL_PATTERN.matcher(fullPathOfSrcFile);
        if (matcher.find() && StringUtil.notEmpty((String)(relativePathToTargetFile = this.relativePathToTargetCourse(fullPathOfSrcFile, matcher)))) {
            String relativePathToSourceFile = GradebookPrivateDocumentStoreUtil.extractGradebookNotesAndFeedbackRelativePath((String)fullPathOfSrcFile);
            String fileName = FileUtil.getFileName((String)relativePathToSourceFile);
            ResourceFile sourceFile = ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager().loadFile(this._srcSite, relativePathToSourceFile);
            InputStream sourceInputStream = sourceFile.getContents();
            try {
                ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager().createFile(this._tgtSite, relativePathToTargetFile, fileName, sourceInputStream, IDocumentManager.DuplicateFileHandling.Replace, null);
            }
            finally {
                IOUtil.silentClose((Closeable)sourceInputStream);
            }
        }
    }

    private String relativePathToTargetCourse(String fullpathOfSrcFile, Matcher gradebookCommentPrivateLinkMatcher) throws PersistenceException {
        String srcTypeId = gradebookCommentPrivateLinkMatcher.group(1);
        String srcIdString = gradebookCommentPrivateLinkMatcher.group(2);
        String fullPathOfTargetFile = "";
        if (ATTEMPT.equals(srcTypeId)) {
            GradebookPrivateDocumentStoreUtil.StagingMatcherResult result = GradebookPrivateDocumentStoreUtil.matchForStagingId((String)fullpathOfSrcFile);
            fullPathOfTargetFile = result.hasStagingId() ? this.getTargetAttemptPath(srcIdString, result.getStagingIdStr(), false) : this.getTargetAttemptPath(srcIdString, false);
        } else if ("attemptNotes".equals(srcTypeId)) {
            GradebookPrivateDocumentStoreUtil.StagingMatcherResult result = GradebookPrivateDocumentStoreUtil.matchForStagingId((String)fullpathOfSrcFile);
            fullPathOfTargetFile = result.hasStagingId() ? this.getTargetAttemptPath(srcIdString, result.getStagingIdStr(), true) : this.getTargetAttemptPath(srcIdString, true);
        } else if ("groupattempt".equals(srcTypeId)) {
            GradebookPrivateDocumentStoreUtil.StagingMatcherResult result = GradebookPrivateDocumentStoreUtil.matchForStagingId((String)fullpathOfSrcFile);
            fullPathOfTargetFile = result.hasStagingId() ? this.getTargetGroupAttemptPath(srcIdString, result.getStagingIdStr(), false) : this.getTargetGroupAttemptPath(srcIdString, false);
        } else if ("groupattemptNotes".equals(srcTypeId)) {
            GradebookPrivateDocumentStoreUtil.StagingMatcherResult result = GradebookPrivateDocumentStoreUtil.matchForStagingId((String)fullpathOfSrcFile);
            fullPathOfTargetFile = result.hasStagingId() ? this.getTargetGroupAttemptPath(srcIdString, result.getStagingIdStr(), true) : this.getTargetGroupAttemptPath(srcIdString, true);
        } else if ("gradeHistory".equals(srcTypeId)) {
            fullPathOfTargetFile = this.getTargetGradeHistoryPath(gradebookCommentPrivateLinkMatcher, srcIdString, false);
        } else if ("gradeHistoryNotes".equals(srcTypeId)) {
            fullPathOfTargetFile = this.getTargetGradeHistoryPath(gradebookCommentPrivateLinkMatcher, srcIdString, true);
        } else if ("gradeDetail".equals(srcTypeId)) {
            fullPathOfTargetFile = this.getTargetGradeDetailPath(srcIdString, false);
        } else if ("gradeDetailNotes".equals(srcTypeId)) {
            fullPathOfTargetFile = this.getTargetGradeDetailPath(srcIdString, true);
        } else {
            LogServiceFactory.getInstance().logError("Unknown path element: " + srcTypeId);
        }
        return GradebookPrivateDocumentStoreUtil.extractGradebookNotesAndFeedbackRelativePath((String)fullPathOfTargetFile);
    }

    private String getTargetGradeDetailPath(String srcIdString, boolean notesFlag) throws PersistenceException {
        Map<String, String> gradabookGradeIdMap = this.getDbBasedIdMap(GRADEBOOK_GRADE_ID_MAP);
        String targetGradeIdString = gradabookGradeIdMap.get(srcIdString);
        if (StringUtil.isEmpty((String)targetGradeIdString)) {
            LogServiceFactory.getInstance().logError("getTargetGradeDetailPath: Failed to find matching grade for id " + srcIdString);
            return "";
        }
        Id targetGradeId = Id.generateId((DataType)GradeDetail.DATA_TYPE, (String)targetGradeIdString);
        String fullPathOfTargetFile = GradebookPrivateDocumentStoreUtil.getOverrideGradeFilePath((Id)targetGradeId, (boolean)notesFlag);
        return fullPathOfTargetFile;
    }

    private String getTargetGradeHistoryPath(Matcher gradebookCommentPrivateLinkMatcher, String srcIdString, boolean notesFlag) throws PersistenceException {
        Map<String, String> gradebookGradeIdMap = this.getDbBasedIdMap(GRADEBOOK_GRADE_ID_MAP);
        String targetGradeIdString = gradebookGradeIdMap.get(srcIdString);
        if (StringUtil.isEmpty((String)targetGradeIdString)) {
            LogServiceFactory.getInstance().logError("getTargetGradeHistoryPath: Failed to find matching grade for id " + srcIdString);
            return "";
        }
        Id targetGradeId = Id.generateId((DataType)GradeDetail.DATA_TYPE, (String)targetGradeIdString);
        String historyTimeAndFilePath = gradebookCommentPrivateLinkMatcher.group(3);
        Long historyTime = GradebookPrivateDocumentStoreUtil.extractHistoryTime((String)historyTimeAndFilePath);
        if (null == historyTime) {
            return "";
        }
        return GradebookPrivateDocumentStoreUtil.getGradeHistoryFilePath((Id)targetGradeId, (long)historyTime, (boolean)notesFlag);
    }

    private String getTargetGroupAttemptPath(String srcIdString, boolean notesFlag) throws PersistenceException {
        Map<String, String> groupAttemptIdMap = this.getDbBasedIdMap(GROUP_ATTEMPT_ID_MAP);
        String targetGroupAttemptIdString = groupAttemptIdMap.get(srcIdString);
        if (StringUtil.isEmpty((String)targetGroupAttemptIdString)) {
            LogServiceFactory.getInstance().logError("getTargetGroupAttemptPath: Failed to find matching group attempt for id " + srcIdString);
            return "";
        }
        Id targetGroupAttemptId = Id.generateId((DataType)GroupAttempt.DATA_TYPE, (String)targetGroupAttemptIdString);
        String fullPathOfTargetFile = GradebookPrivateDocumentStoreUtil.getGroupAttemptFilePath((Id)targetGroupAttemptId, (boolean)notesFlag);
        return fullPathOfTargetFile;
    }

    private String getTargetGroupAttemptPath(String srcIdString, String srcStagedId, boolean notesFlag) throws PersistenceException {
        Map<String, String> groupAttemptIdMap = this.getDbBasedIdMap(GROUP_ATTEMPT_ID_MAP);
        String targetGroupAttemptIdString = groupAttemptIdMap.get(srcIdString);
        if (StringUtil.isEmpty((String)targetGroupAttemptIdString)) {
            LogServiceFactory.getInstance().logError("getTargetGroupAttemptPath: Failed to find matching group attempt for id " + srcIdString);
            return "";
        }
        Id targetGroupAttemptId = Id.generateId((DataType)GroupAttempt.DATA_TYPE, (String)targetGroupAttemptIdString);
        Map<String, String> stagedIdMap = this.getDbBasedIdMap(STAGED_GROUP_ATTEMPT_ID_MAP);
        String targetStagedGroupAttemptIdString = stagedIdMap.get(srcStagedId);
        if (StringUtil.isEmpty((String)targetStagedGroupAttemptIdString)) {
            LogServiceFactory.getInstance().logError("getTargetGroupAttemptPath: Failed to find matching group attempt for id " + srcStagedId);
            return "";
        }
        Id targetStagedGroupAttemptId = Id.generateId((DataType)GroupAttemptStagedGrading.DATA_TYPE, (String)targetStagedGroupAttemptIdString);
        String fullPathOfTargetFile = GradebookPrivateDocumentStoreUtil.getGroupAttemptFilePath((Id)targetGroupAttemptId, (Id)targetStagedGroupAttemptId, (boolean)notesFlag);
        return fullPathOfTargetFile;
    }

    private String getTargetAttemptPath(String srcIdString, boolean notesFlag) throws PersistenceException {
        Map<String, String> attemptIdMap = this.getDbBasedIdMap(ATTEMPT_ID_MAP);
        String targetAttemptIdString = attemptIdMap.get(srcIdString);
        if (StringUtil.isEmpty((String)targetAttemptIdString)) {
            LogServiceFactory.getInstance().logError("getTargetAttemptPath: Failed to find matching attempt for id " + srcIdString);
            return "";
        }
        Id targetAttemptId = Id.generateId((DataType)Attempt.DATA_TYPE, (String)targetAttemptIdString);
        String fullPathOfTargetFile = GradebookPrivateDocumentStoreUtil.getAttemptFilePath((Id)targetAttemptId, (boolean)notesFlag);
        return fullPathOfTargetFile;
    }

    private String getTargetAttemptPath(String srcIdString, String srcStagedId, boolean notesFlag) throws PersistenceException {
        Map<String, String> attemptIdMap = this.getDbBasedIdMap(ATTEMPT_ID_MAP);
        String targetAttemptIdString = attemptIdMap.get(srcIdString);
        if (StringUtil.isEmpty((String)targetAttemptIdString)) {
            LogServiceFactory.getInstance().logError("getTargetAttemptPath: Failed to find matching attempt for id " + srcIdString);
            return "";
        }
        Id targetAttemptId = Id.generateId((DataType)Attempt.DATA_TYPE, (String)targetAttemptIdString);
        Map<String, String> stagedIdMap = this.getDbBasedIdMap(STAGED_ATTEMPT_ID_MAP);
        String targetStagedAttemptIdString = stagedIdMap.get(srcStagedId);
        if (StringUtil.isEmpty((String)targetStagedAttemptIdString)) {
            LogServiceFactory.getInstance().logError("getTargetAttemptPath: Failed to find matching staged attempt for id " + srcStagedId);
            return "";
        }
        Id targetStagedAttemptId = Id.generateId((DataType)AttemptStagedGrading.DATA_TYPE, (String)targetStagedAttemptIdString);
        String fullPathOfTargetFile = GradebookPrivateDocumentStoreUtil.getAttemptFilePath((Id)targetAttemptId, (Id)targetStagedAttemptId, (boolean)notesFlag);
        return fullPathOfTargetFile;
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        this.updateEmbeddedDatabaseIdForVTBE();
        this.updateXidsInFeedbackAndNotes(GradeDetail.DATA_TYPE, GRADEBOOK_GRADE_ID_MAP, GRADEBOOK_GRADE, FOR_STUDENT_COMMENTS, COMMENTS);
        this.updateXidsInFeedbackAndNotes(Attempt.DATA_TYPE, ATTEMPT_ID_MAP, ATTEMPT, INSTRUCTOR_COMMENTS, INSTRUCTOR_NOTES);
        this.updateXidsInFeedbackAndNotes(GroupAttempt.DATA_TYPE, GROUP_ATTEMPT_ID_MAP, GROUP_ATTEMPT, INSTRUCTOR_COMMENTS, INSTRUCTOR_NOTES);
        this.updateXidsInFeedbackAndNotes(GradeHistoryEntry.DATA_TYPE, GRADEBOOK_LOG_ID_MAP, GRADEBOOK_LOG, FOR_STUDENT_COMMENTS, INSTRUCTOR_COMMENTS);
        this.updateXidsInHistoryFeedbackAndNotes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForVTBE() throws Exception {
        Map<String, String> gradableItemIdMap = this.getDbBasedIdMap(GRADEBOOK_MAIN_ID_MAP);
        if (gradableItemIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement update = null;
        Connection con = null;
        String selectClause = "select pk1, description, title from GRADEBOOK_MAIN ";
        String qryUpdate = "update GRADEBOOK_MAIN set description = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            update = con.prepareStatement(qryUpdate);
            selectStmtList = this.prepareStatement(selectClause, gradableItemIdMap.values(), GradableItem.DATA_TYPE, con, this._cfg);
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String text = null;
                        String title = null;
                        try {
                            String replace;
                            Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)GradableItem.DATA_TYPE, (Container)this._pm.getContainer());
                            text = DbUtil.getString((ResultSet)rst, (String)"description", null);
                            title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                            if (!StringUtil.notEmpty((String)text) || StringUtil.isEqual((String)text, (String)(replace = this.parseVTBEText(text, resultSet = new CSResultSet(this._tgtSite.getId(), cId, title, "cx.import.copy.link.component.name.grade.column"))))) continue;
                            DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                            Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                            update.execute();
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Gradebook Column with title: " + title + ", description:" + text, (Throwable)e);
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                        }
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Gradebook Columns for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateXidsInHistoryFeedbackAndNotes() throws Exception {
        Map<String, String> gradableItemIdMap = this.getDbBasedIdMap(GRADEBOOK_MAIN_ID_MAP);
        if (gradableItemIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement updateFeedbackAndNotes = null;
        PreparedStatement updateFeedback = null;
        PreparedStatement updateNotes = null;
        Connection con = null;
        StringBuilder selectSQL = new StringBuilder();
        selectSQL.append("SELECT l.gradebook_main_pk1, l.date_logged, l.instructor_comments, l.for_student_comments ");
        selectSQL.append("FROM gradebook_log l INNER JOIN ");
        selectSQL.append("gradebook_main m ON m.pk1 = l.gradebook_main_pk1 ");
        String qryUpdateFeedbackAndNotes = this.getUpdateGradebookLogFeedBackAndNotesSQL(true, true);
        String qryUpdateFeedback = this.getUpdateGradebookLogFeedBackAndNotesSQL(true, false);
        String qryUpdateNotes = this.getUpdateGradebookLogFeedBackAndNotesSQL(false, true);
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            selectStmtList = this.prepareStatement(selectSQL.toString(), gradableItemIdMap.values(), GradableItem.DATA_TYPE, con, this._cfg, null, "m.crsmain_pk1");
            updateFeedbackAndNotes = con.prepareStatement(qryUpdateFeedbackAndNotes);
            updateFeedback = con.prepareStatement(qryUpdateFeedback);
            updateNotes = con.prepareStatement(qryUpdateNotes);
            String defaultGradingCommentsTitle = GradebookPrivateDocumentStoreUtil.getDefaultGradingCommentsTitle();
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String feedback = null;
                        String notes = null;
                        try {
                            Id gradableItemId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)GradableItem.DATA_TYPE, (Container)this._pm.getContainer());
                            feedback = DbUtil.getString((ResultSet)rst, (String)FOR_STUDENT_COMMENTS, null);
                            notes = DbUtil.getString((ResultSet)rst, (String)INSTRUCTOR_COMMENTS, null);
                            Calendar dateAttempted = DbUtil.getCalendar((ResultSet)rst, (String)"date_logged");
                            resultSet = new CSResultSet(this._tgtSite.getId(), null, defaultGradingCommentsTitle, "cx.import.copy.link.component.name.grade.column");
                            String replaceFeedback = null;
                            boolean feedbackChanged = false;
                            if (StringUtil.notEmpty((String)feedback) && !StringUtil.isEqual((String)feedback, (String)(replaceFeedback = this.parseVTBEText(feedback, resultSet)))) {
                                feedbackChanged = true;
                            }
                            String replaceNotes = null;
                            boolean notesChanged = false;
                            if (StringUtil.notEmpty((String)notes) && !StringUtil.isEqual((String)notes, (String)(replaceNotes = this.parseVTBEText(notes, resultSet)))) {
                                notesChanged = true;
                            }
                            if (notesChanged && feedbackChanged) {
                                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)updateFeedbackAndNotes, (int)1, (String)replaceFeedback);
                                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)updateFeedbackAndNotes, (int)2, (String)replaceNotes);
                                Bb5Util.setId((PreparedStatement)updateFeedbackAndNotes, (int)3, (Id)gradableItemId);
                                DbUtil.setCalendar((PreparedStatement)updateFeedbackAndNotes, (int)4, (Calendar)dateAttempted);
                                updateFeedbackAndNotes.execute();
                            } else if (notesChanged) {
                                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)updateNotes, (int)1, (String)replaceNotes);
                                Bb5Util.setId((PreparedStatement)updateFeedbackAndNotes, (int)2, (Id)gradableItemId);
                                DbUtil.setCalendar((PreparedStatement)updateFeedbackAndNotes, (int)3, (Calendar)dateAttempted);
                                updateNotes.execute();
                            } else if (feedbackChanged) {
                                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)updateFeedback, (int)1, (String)replaceFeedback);
                                Bb5Util.setId((PreparedStatement)updateFeedbackAndNotes, (int)2, (Id)gradableItemId);
                                DbUtil.setCalendar((PreparedStatement)updateFeedbackAndNotes, (int)3, (Calendar)dateAttempted);
                                updateFeedback.execute();
                            }
                            if (resultSet == null) continue;
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Gradebook Column with title: " + defaultGradingCommentsTitle, (Throwable)e);
                            continue;
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                            continue;
                        }
                        this.addCsLinkStatus(resultSet);
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Announcements for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(updateFeedbackAndNotes);
            DbUtil.close(updateFeedback);
            DbUtil.close(updateNotes);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)updateFeedbackAndNotes);
        DbUtil.close((Statement)updateFeedback);
        DbUtil.close((Statement)updateNotes);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private String getUpdateGradebookLogFeedBackAndNotesSQL(boolean includeFeedback, boolean includeNotes) {
        StringBuilder sql = new StringBuilder("update gradebook_log set ");
        if (includeFeedback) {
            sql.append("for_student_comments = ? ");
        }
        if (includeFeedback && includeNotes) {
            sql.append(", ");
        }
        if (includeNotes) {
            sql.append("instructor_comments= ? ");
        }
        sql.append("where gradebook_main_pk1 = ? and date_logged=? ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateXidsInFeedbackAndNotes(DataType dataType, String mapId, String tableName, String feedbackColumnName, String notesColumnName) throws Exception {
        Map<String, String> idMap = this.getDbBasedIdMap(mapId);
        if (idMap.isEmpty()) {
            return;
        }
        try (FeedBackAndNotesJdbcHelper jdbcHelper = null;){
            jdbcHelper = new FeedBackAndNotesJdbcHelper(idMap, dataType, tableName, feedbackColumnName, notesColumnName, this._cfg);
            List<FeedBackAndNotesJdbcHelper.Result> results = jdbcHelper.loadFeedbackAndNotes();
            String defaultGradingCommentsTitle = GradebookPrivateDocumentStoreUtil.getDefaultGradingCommentsTitle();
            for (FeedBackAndNotesJdbcHelper.Result result : results) {
                String feedback = result.feedback;
                String notes = result.notes;
                Id id = result.id;
                CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), id, defaultGradingCommentsTitle, "cx.import.copy.link.component.name.grade.column");
                try {
                    String replaceFeedback = null;
                    boolean feedbackChanged = false;
                    if (StringUtil.notEmpty((String)feedback) && !StringUtil.isEqual((String)feedback, (String)(replaceFeedback = this.parseVTBEText(feedback, resultSet)))) {
                        feedbackChanged = true;
                    }
                    String replaceNotes = null;
                    boolean notesChanged = false;
                    if (StringUtil.notEmpty((String)notes) && !StringUtil.isEqual((String)notes, (String)(replaceNotes = this.parseVTBEText(notes, resultSet)))) {
                        notesChanged = true;
                    }
                    if (notesChanged && feedbackChanged) {
                        jdbcHelper.updateFeedbackAndNotes(id, replaceFeedback, replaceNotes);
                    } else if (notesChanged) {
                        jdbcHelper.updateNotes(id, replaceNotes);
                    } else if (feedbackChanged) {
                        jdbcHelper.updateFeedback(id, replaceFeedback);
                    }
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Gradebook Column with title: " + defaultGradingCommentsTitle, (Throwable)e);
                }
                this.addCsLinkStatus(resultSet);
                jdbcHelper.closeResultSet();
            }
        }
    }

    private class FeedBackAndNotesJdbcHelper {
        private String _tableName;
        private String _feedbackColumnName;
        private String _notesColumnName;
        private DataType _dataType;
        private Map<String, String> _idMap;
        private List<PreparedStatement> _selectStmtList = null;
        private PreparedStatement _updateFeedbackAndNotes;
        private PreparedStatement _updateFeedback;
        private PreparedStatement _updateNotes;
        private Connection _con;
        private ResultSet _resultSet;
        private CloneConfig _config;

        public FeedBackAndNotesJdbcHelper(Map<String, String> idMap, DataType dataType, String tableName, String feedbackColumnName, String notesColumnName, CloneConfig config) throws Exception {
            this._tableName = tableName;
            this._feedbackColumnName = feedbackColumnName;
            this._notesColumnName = notesColumnName;
            this._idMap = idMap;
            this._dataType = dataType;
            this._config = config;
            this._con = GradebookCloneOperator.this._bbDatabase.getConnectionManager().getConnection();
            this.prepareSelectSQL(this._con);
            this.prepareUpdateSQL(this._con);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Result> loadFeedbackAndNotes() throws Exception {
            ArrayList<Result> results = new ArrayList<Result>();
            for (PreparedStatement select : this._selectStmtList) {
                try {
                    this._resultSet = select.executeQuery();
                    while (this._resultSet.next()) {
                        Id id = Bb5Util.unmarshallId((ResultSet)this._resultSet, (int)1, (DataType)this._dataType, (Container)GradebookCloneOperator.this._pm.getContainer());
                        String feedback = DbUtil.getString((ResultSet)this._resultSet, (String)this._feedbackColumnName, null);
                        String notes = DbUtil.getString((ResultSet)this._resultSet, (String)this._notesColumnName, null);
                        Result result = new Result(id, feedback, notes);
                        results.add(result);
                    }
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Feedback adn Notes for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
            return results;
        }

        public void updateFeedbackAndNotes(Id id, String feedback, String notes) throws Exception {
            DbUtil.setNClob((BbDatabase)GradebookCloneOperator.this._bbDatabase, (PreparedStatement)this._updateFeedbackAndNotes, (int)1, (String)feedback);
            DbUtil.setNClob((BbDatabase)GradebookCloneOperator.this._bbDatabase, (PreparedStatement)this._updateFeedbackAndNotes, (int)2, (String)notes);
            Bb5Util.setId((PreparedStatement)this._updateFeedbackAndNotes, (int)3, (Id)id);
            this._updateFeedbackAndNotes.execute();
        }

        public void updateFeedback(Id id, String feedback) throws Exception {
            DbUtil.setNClob((BbDatabase)GradebookCloneOperator.this._bbDatabase, (PreparedStatement)this._updateFeedback, (int)1, (String)feedback);
            Bb5Util.setId((PreparedStatement)this._updateFeedback, (int)2, (Id)id);
            this._updateFeedback.execute();
        }

        public void updateNotes(Id id, String notes) throws Exception {
            DbUtil.setNClob((BbDatabase)GradebookCloneOperator.this._bbDatabase, (PreparedStatement)this._updateNotes, (int)1, (String)notes);
            Bb5Util.setId((PreparedStatement)this._updateNotes, (int)2, (Id)id);
            this._updateNotes.execute();
        }

        public void prepareSelectSQL(Connection con) throws Exception {
            this._selectStmtList = GradebookCloneOperator.this.prepareStatement(this.getSelectSQL(), this._idMap.values(), this._dataType, con, this._config);
        }

        public void prepareUpdateSQL(Connection con) throws SQLException {
            this._updateFeedbackAndNotes = con.prepareStatement("update " + this._tableName + " set " + this._feedbackColumnName + " = ?, " + this._notesColumnName + " =? where pk1 = ?");
            this._updateFeedback = con.prepareStatement("update " + this._tableName + " set " + this._feedbackColumnName + "= ? where pk1 = ?");
            this._updateNotes = con.prepareStatement("update " + this._tableName + " set " + this._notesColumnName + "= ? where pk1 = ?");
        }

        public void close() {
            DbUtil.close((Statement)this._updateFeedbackAndNotes);
            DbUtil.close((Statement)this._updateFeedback);
            DbUtil.close((Statement)this._updateNotes);
            GradebookCloneOperator.this._bbDatabase.getConnectionManager().releaseConnection(this._con);
        }

        public void closeResultSet() {
            DbUtil.close((ResultSet)this._resultSet);
        }

        private String getSelectSQL() {
            return "select pk1, " + this._feedbackColumnName + ", " + this._notesColumnName + " from " + this._tableName;
        }

        private class Result {
            public Id id;
            public String feedback;
            public String notes;

            public Result(Id id, String feedback, String notes) {
                this.id = id;
                this.feedback = feedback;
                this.notes = notes;
            }
        }
    }
}

