/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.navigation.CourseToc;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.platform.log.LogServiceFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LinkCloneOperator
extends CloneOperator {
    public LinkCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        List<CourseToc> courseTocModules;
        long lStart = System.currentTimeMillis();
        if (this._cfg.isAreaIncluded(CloneConfig.Area.SETTING)) {
            this.executeCloneProcedure("link_ct_cp", this._cfg.getMaximumTransactionCount());
        } else if (this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC) && !(courseTocModules = this.reconcileCourseTocModules()).isEmpty()) {
            this.executeCourseTocLinkCloneProcedure(courseTocModules);
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.ANNOUNCEMENT)) {
            this.executeCloneProcedure("link_a_cp", this._cfg.getMaximumTransactionCount());
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            this.executeCloneProcedure("link_cc_cp", this._cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.LINK, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.link"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }

    private List<CourseToc> reconcileCourseTocModules() {
        ArrayList<CourseToc> courseTocModules = new ArrayList<CourseToc>();
        List<String> courseTocIds = this._cfg.getCourseTocIdList();
        for (String tocIdStr : courseTocIds) {
            try {
                Id courseTocId = Id.generateId((DataType)CourseToc.DATA_TYPE, (String)tocIdStr);
                CourseToc courseToc = CourseTocDbLoader.Default.getInstance().loadById(courseTocId);
                if (courseToc.getTargetType() != CourseToc.Target.MODULE) continue;
                courseTocModules.add(courseToc);
            }
            catch (PersistenceException e) {}
        }
        return courseTocModules;
    }

    private void executeCourseTocLinkCloneProcedure(List<CourseToc> courseTocModules) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        for (CourseToc module : courseTocModules) {
            try {
                con = this._bbDatabase.getConnectionManager().getConnection();
                StringBuilder sqlStmt = new StringBuilder();
                sqlStmt.append("{ call link_ct_spe_cp ( ?, ?, ?, ? ) }");
                stmt = con.prepareCall(sqlStmt.toString());
                Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._srcSite.getId());
                Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)this._tgtSite.getId());
                DbUtil.setString((PreparedStatement)stmt, (int)3, (String)this._sessionId);
                Bb5Util.setId((PreparedStatement)stmt, (int)4, (Id)module.getId());
                stmt.execute();
            }
            catch (SQLException sqe) {
                try {
                    LogServiceFactory.getInstance().logFatal("Stored Procedure link_ct_spe_cp failed execution", (Throwable)sqe);
                    throw sqe;
                }
                catch (Throwable throwable) {
                    DbUtil.close(stmt);
                    this._bbDatabase.getConnectionManager().releaseConnection(con);
                    throw throwable;
                }
            }
            DbUtil.close((Statement)stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
        }
    }
}

