/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.navigation.CourseNavigationApplicationDbPersister;
import blackboard.persist.navigation.CourseNavigationItemDbPersister;
import blackboard.persist.navigation.CourseTocDbPersister;

public class ReconciliationCloneOperator
extends CloneOperator {
    public ReconciliationCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.getReconcileFlag().booleanValue()) {
            return;
        }
        this.removeAllPointsOfReconciliation();
        this.doCallbackSegment(CloneCallback.Stage.RECONCILIATION, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.reconciliation"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }

    private void removeAllPointsOfReconciliation() throws Exception {
        Course course = this._tgtSite;
        ReconciliationCloneOperator.removeAllPointsOfReconciliation(course);
    }

    protected static void removeAllPointsOfReconciliation(Course course) throws PersistenceException, KeyNotFoundException {
        CourseNavigationApplicationDbPersister navAppPersister = (CourseNavigationApplicationDbPersister)CourseNavigationApplicationDbPersister.Default.getInstance();
        navAppPersister.deleteByCourseId(course.getId());
        CourseTocDbPersister tocPersister = (CourseTocDbPersister)CourseTocDbPersister.Default.getInstance();
        tocPersister.deleteByCourseId(course.getId());
        CourseNavigationItemDbPersister navItemPersister = (CourseNavigationItemDbPersister)CourseNavigationItemDbPersister.Default.getInstance();
        navItemPersister.deleteByCourseId(course.getId());
    }
}

