/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.data.course.Course;
import blackboard.data.gradebook.impl.OutcomeDefinition;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.gradebook.impl.OutcomeDefinitionDbLoader;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.IOUtil;
import blackboard.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScormCloneOperator
extends CloneOperator {
    public ScormCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return this.getDirectoryTranslation(dir, null);
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
            return;
        }
        this.updateScormGradebookItems();
    }

    private void updateScormGradebookItems() throws Exception {
        List<OutcomeDefinition> scormOutcomeDefinitions = this.getScormOutcomeDefinitions();
        for (OutcomeDefinition od : scormOutcomeDefinitions) {
            String courseIdStr = this._tgtSite.getCourseId();
            Id contentId = od.getContentId();
            if (null == contentId) {
                LogServiceFactory.getInstance().logError("There is no course content set for the scorm grade column " + od.getTitle() + ". This cloumn is skipped.");
                continue;
            }
            String scormContentId = od.getContentId().getExternalString();
            String odIdStr = od.getId().getExternalString();
            String scormItemId = od.getLinkId();
            CourseFileManager fileMgr = (CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE);
            File contentDir = null;
            File gradebookItems = null;
            File gradebookItemsNew = null;
            try {
                contentDir = new File(new File(fileMgr.getRootDirectory(courseIdStr), "content"), scormContentId);
                gradebookItems = new File(contentDir, "gradebookItems.txt");
                gradebookItemsNew = new File(contentDir, "newgradebookItems.txt");
            }
            catch (FileSystemException fse) {
                LogServiceFactory.getInstance().logError("Failed to update Scorm gradebookItems due to FileSystemException : courseIdStr is " + courseIdStr + ", scormContentId is" + scormContentId + ", OutcomeDefinitionId is" + odIdStr + ", scormItemId is " + scormItemId, (Throwable)fse);
                throw fse;
            }
            if (!gradebookItems.exists()) continue;
            FileReader fr = null;
            BufferedReader br = null;
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                fr = new FileReader(gradebookItems);
                br = new BufferedReader(fr);
                fw = new FileWriter(gradebookItemsNew);
                bw = new BufferedWriter(fw);
                String line = br.readLine();
                while (line != null) {
                    if (line.contains(scormItemId) && line.startsWith("@X@")) {
                        line = "@X@" + odIdStr + ":" + scormItemId + "\n";
                    }
                    bw.append(line);
                    bw.flush();
                    fw.flush();
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                try {
                    LogServiceFactory.getInstance().logError("Failed to update Scorm gradebookItems: courseIdStr is " + courseIdStr + ", scormContentId is" + scormContentId + ", OutcomeDefinitionId is" + odIdStr + ", scormItemId is " + scormItemId, (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtil.silentClose(br);
                    IOUtil.silentClose((Closeable)fr);
                    IOUtil.silentClose(bw);
                    IOUtil.silentClose(fw);
                    throw throwable;
                }
            }
            IOUtil.silentClose((Closeable)br);
            IOUtil.silentClose((Closeable)fr);
            IOUtil.silentClose((Closeable)bw);
            IOUtil.silentClose((Closeable)fw);
            if (!gradebookItems.delete()) {
                LogServiceFactory.getInstance().logError("Couldn't delete old gradebookItems file.");
                throw new IOException("Couldn't delete old gradebookItems file.");
            }
            if (gradebookItemsNew.renameTo(gradebookItems)) continue;
            LogServiceFactory.getInstance().logError("Couldn't rename new file to gradebookItems file.");
            throw new IOException("Couldn't rename new file to gradebookItems file.");
        }
    }

    private List<OutcomeDefinition> getScormOutcomeDefinitions() throws PersistenceException, KeyNotFoundException {
        ArrayList<OutcomeDefinition> scormOutcomeDefinitions = new ArrayList<OutcomeDefinition>();
        OutcomeDefinitionDbLoader ocLoader = (OutcomeDefinitionDbLoader)OutcomeDefinitionDbLoader.Default.getInstance();
        List odList = ocLoader.loadByCourseId(this._tgtSite.getId());
        for (OutcomeDefinition od : odList) {
            if (!StringUtil.notEmpty((String)od.getHandlerUrl()) || !od.getHandlerUrl().startsWith("/webapps/bb-cntplayer")) continue;
            scormOutcomeDefinitions.add(od);
        }
        return scormOutcomeDefinitions;
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }
}

