/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.data.course.Group;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.course.GroupMembershipListener;
import blackboard.persist.course.impl.GroupDAO;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.course.CourseGroupManagerFactory;
import blackboard.platform.extension.service.ExtensionRegistryFactory;
import blackboard.util.CollectionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SyncGroupAppsCloneOperator
extends CloneOperator {
    public SyncGroupAppsCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
            return;
        }
        Set<Id> groupIds = this.loadNewGroupIds();
        for (Id groupId : groupIds) {
            Group group = (Group)GroupDAO.get().loadById(groupId);
            CourseGroupManagerFactory.getInstance().sendGroupCreatedByCXNotifications(group);
        }
        Collection groupMembershipListeners = ExtensionRegistryFactory.getInstance().getExtensions("blackboard.platform.groupMembershipListener");
        for (GroupMembershipListener groupMembershipListener : groupMembershipListeners) {
            this.syncAttendance(groupMembershipListener);
        }
    }

    private void syncAttendance(GroupMembershipListener groupMembershipListener) {
        List tgtGroups;
        if (this._cfg.isAreaIncluded(CloneConfig.Area.GROUP) && this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) && CollectionUtils.notEmpty((Collection)(tgtGroups = GroupDAO.get().loadByCourseId(this._tgtSite.getId())))) {
            for (Group tgtGroup : tgtGroups) {
                groupMembershipListener.onCourseCopyNewOrExisting(tgtGroup.getId());
            }
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Id> loadNewGroupIds() throws Exception {
        HashSet<Id> hashSet;
        HashSet<Id> groupIds = new HashSet<Id>();
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select new_pk1 from tmp_key_maps where session_id = ? and table_name ='GROUPS' ");
            DbUtil.setString((PreparedStatement)stmt, (int)1, (String)this._sessionId);
            rst = stmt.executeQuery();
            while (rst.next()) {
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Group.DATA_TYPE, (Container)this._pm.getContainer());
                groupIds.add(newId);
            }
            hashSet = groupIds;
        }
        catch (Throwable throwable) {
            DbUtil.close(rst);
            DbUtil.close(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((ResultSet)rst);
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
        return hashSet;
    }
}

