/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.task.Task;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class TaskCloneOperator
extends CloneOperator {
    public TaskCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        LogServiceFactory.getInstance().log("TaskCloneOperator.doDatabaseTranslation()", LogService.Verbosity.DEBUG);
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.TASK)) {
            return;
        }
        this.executeCloneProcedure("tasks_cp", this._cfg.getMaximumTransactionCount());
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("tasks_users_cp", this._cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.TASK, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.task"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        this.updateEmbeddedDatabaseIdForVTBE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForVTBE() throws Exception {
        Map<String, String> tasksIdMap = this.getDbBasedIdMap("TASKS");
        if (tasksIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement update = null;
        Connection con = null;
        String selectClause = "select pk1, description, subject from TASKS ";
        String qryUpdate = "update TASKS set description = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            update = con.prepareStatement(qryUpdate);
            selectStmtList = this.prepareStatement(selectClause, tasksIdMap.values(), Task.DATA_TYPE, con, this._cfg);
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String text = null;
                        String subject = null;
                        try {
                            String replace;
                            Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Task.DATA_TYPE, (Container)this._pm.getContainer());
                            text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"description", null);
                            subject = DbUtil.getString((ResultSet)rst, (String)"subject", null);
                            if (!StringUtil.notEmpty((String)text) || StringUtil.isEqual((String)text, (String)(replace = this.parseVTBEText(text, resultSet = new CSResultSet(this._tgtSite.getId(), cId, subject, "cx.import.copy.link.component.name.task"))))) continue;
                            DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                            Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                            update.execute();
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Task with subject: " + subject + ", description:" + text, (Throwable)e);
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                        }
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Tasks for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }
}

