/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator.extension;

import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.extension.CopyComponentLogger;
import blackboard.data.calendar.CalendarEntry;
import blackboard.data.content.Content;
import blackboard.data.course.Course;
import blackboard.data.course.Group;
import blackboard.data.gradebook.impl.Attempt;
import blackboard.data.gradebook.impl.OutcomeDefinition;
import blackboard.data.qti.asi.AsiObject;
import blackboard.db.DbUtil;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.datatypeext.DataTypeExtensionFactory;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.platform.cx.component.CopyControl;
import blackboard.platform.cx.component.CxComponentLogger;
import blackboard.platform.gradebook2.AttemptDetail;
import blackboard.platform.gradebook2.GradableItem;
import blackboard.platform.gradebook2.GroupAttempt;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class CopyControlImpl
implements CopyControl {
    private final CloneOperator _operator;
    private final CloneConfig _cloneConfig;
    private final String _sessionId;
    private final Course _srcCourse;
    private final Course _destCourse;
    private final CopyComponentLogger _logger;

    public CopyControlImpl(CloneOperator operator) {
        this._operator = operator;
        this._cloneConfig = operator.getCloneConfig();
        this._srcCourse = operator.getSourceCourse();
        this._destCourse = operator.getTargetCourse();
        this._sessionId = operator.getSessionId();
        this._logger = new CopyComponentLogger();
    }

    public Id getDestinationCourseId() {
        return this._destCourse.getId();
    }

    public CxComponentLogger getLogger() {
        return this._logger;
    }

    public Id getSourceCourseId() {
        return this._srcCourse.getId();
    }

    public boolean isExact() {
        return this._cloneConfig.isAreaIncluded(CloneConfig.Area.ALL);
    }

    public String copyVTBEText(String originalText, Id parentId, String parentTitle) {
        CSResultSet resultSet = new CSResultSet(this._destCourse.getId(), parentId, parentTitle, null);
        String result = originalText;
        try {
            result = this._operator.parseVTBEText(originalText, resultSet);
        }
        catch (Exception e) {
            this._logger.logError("Failed to update Course Files link to item " + parentId.toExternalString(), e);
        }
        this._operator.addCsLinkStatus(resultSet);
        return result;
    }

    public CloneConfig getConfiguration() {
        return this._cloneConfig;
    }

    public Id lookupIdMapping(Id oldId) {
        GetNewKeyQuery qry = new GetNewKeyQuery(this._sessionId, oldId);
        try {
            qry.run();
            return qry.getNewId();
        }
        catch (PersistenceException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public boolean isCourseMembershipIncluded() {
        return this._cloneConfig.isAreaIncluded(CloneConfig.Area.MEMBERSHIP);
    }

    public boolean isCourseGradebookIncluded() {
        return this._cloneConfig.isAreaIncluded(CloneConfig.Area.GRADEBOOK);
    }

    private static class GetNewKeyQuery
    extends StoredProcedureQuery {
        private static final HashMap<DataType, String> DATA_TYPE_MAP = new HashMap();
        private String _sessionId;
        private Id _oldId;
        private Id _newId = Id.UNSET_ID;

        public GetNewKeyQuery(String sessionId, Id oldId) {
            super("get_new_key");
            this._sessionId = sessionId;
            this._oldId = oldId;
            this.addInputParameter("p_table_name");
            this.addInputParameter("p_old_pk1");
            this.addInputParameter("p_session_id");
            this.addOutputParameter("p_new_pk1");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            DbUtil.setString((PreparedStatement)stmt, (int)this.getColumnPosition("p_table_name"), (String)this.tableNameFromDataType(this._oldId.getDataType()));
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("p_old_pk1"), (Id)this._oldId);
            DbUtil.setString((PreparedStatement)stmt, (int)this.getColumnPosition("p_session_id"), (String)this._sessionId);
            stmt.registerOutParameter(this.getColumnPosition("p_new_pk1"), -5);
        }

        public void processResults(CallableStatement stmt) throws SQLException {
            long newPk1 = stmt.getLong(this.getColumnPosition("p_new_pk1"));
            if (!stmt.wasNull()) {
                try {
                    this._newId = Id.generateId((DataType)this._oldId.getDataType(), (long)newPk1);
                }
                catch (PersistenceException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void processResults(ResultSet rst) throws SQLException {
            throw new RuntimeException("This method should never be called.");
        }

        public Id getNewId() {
            return this._newId;
        }

        protected String tableNameFromDataType(DataType dataType) {
            String tableName = DATA_TYPE_MAP.get(dataType);
            if (tableName == null) {
                throw new RuntimeException("Datatype " + dataType + " not supported.");
            }
            return tableName;
        }

        public boolean getUseResultSet() {
            return false;
        }

        static {
            DATA_TYPE_MAP.put(Attempt.DATA_TYPE, "ATTEMPT");
            DATA_TYPE_MAP.put(AttemptDetail.DATA_TYPE, "ATTEMPT");
            DATA_TYPE_MAP.put(CalendarEntry.DATA_TYPE, "CALENDAR");
            DATA_TYPE_MAP.put(Content.DATA_TYPE, "COURSE_CONTENTS");
            DATA_TYPE_MAP.put(GradableItem.DATA_TYPE, "GRADEBOOK_MAIN");
            DATA_TYPE_MAP.put(OutcomeDefinition.DATA_TYPE, "GRADEBOOK_MAIN");
            DATA_TYPE_MAP.put(Group.DATA_TYPE, "GROUPS");
            DATA_TYPE_MAP.put(GroupAttempt.DATA_TYPE, "GROUP_ATTEMPT");
            DATA_TYPE_MAP.put(AsiObject.DATA_TYPE, "QTI_ASI_DATA");
            DATA_TYPE_MAP.put(DataTypeExtensionFactory.getDataTypeExtensionByKey((String)"rubric").getDataType(), "RUBRIC");
        }
    }
}

