/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator.helper;

import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.platform.gradebook2.BaseGradingSchema;
import blackboard.platform.gradebook2.GradableItem;
import blackboard.platform.gradebook2.GradebookType;
import blackboard.platform.gradebook2.GradingSchema;
import blackboard.platform.gradebook2.InteractiveActivityManagerFactory;
import blackboard.platform.gradebook2.impl.GradableItemDAO;
import blackboard.platform.gradebook2.impl.GradebookTypeDAO;
import blackboard.platform.gradebook2.impl.GradingSchemaDAO;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.UuidFactory;
import java.util.List;

public class GradebookColumnCopier {
    private Id _sourceCourseId;
    private Id _targetCourseId;
    private List<String> _itemLinkrefsToCopy;

    public GradebookColumnCopier(Id sourceCourseId, Id targetCourseId, List<String> itemLinkrefsToCopy) {
        this._sourceCourseId = sourceCourseId;
        this._targetCourseId = targetCourseId;
        this._itemLinkrefsToCopy = itemLinkrefsToCopy;
    }

    public void copy(OnCopyHandler callbackHandler, boolean newIdent) {
        GradingSchema schema = null;
        try {
            schema = this.getSchemaId();
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("could not load default grading schema", (Throwable)e);
            return;
        }
        for (String linkrefid : this._itemLinkrefsToCopy) {
            GradableItem sourceItem = GradableItemDAO.get().getGradableItemByCourseIdAndLinkRefId(this._sourceCourseId, linkrefid);
            if (null == sourceItem) continue;
            GradableItem copiedItem = new GradableItem();
            copiedItem.setCourseId(this._targetCourseId);
            copiedItem.setTitle(sourceItem.getTitle());
            copiedItem.setDisplayTitle(sourceItem.getDisplayTitle());
            copiedItem.setPoints(sourceItem.getPoints());
            copiedItem.setToolComputedPoints(sourceItem.getToolComputedPoints());
            copiedItem.setScoreProviderHandle(sourceItem.getScoreProviderHandle());
            copiedItem.setGradingSchemaId(schema.getId());
            copiedItem.setUserCreatedColumn(false);
            copiedItem.setLinkId(newIdent ? UuidFactory.createFormattedUuid() : sourceItem.getLinkId());
            copiedItem.setGradingDecimalPlaces(sourceItem.getGradingDecimalPlaces());
            if (Id.isValid((Id)sourceItem.getCategoryId())) {
                try {
                    GradebookType category = (GradebookType)GradebookTypeDAO.get().loadById(sourceItem.getCategoryId());
                    if (!category.getUserDefined()) {
                        copiedItem.setCategoryId(GradebookTypeDAO.get().getSystemTypeIdByCourseAndTitle(this._targetCourseId, category.getTitle()));
                    }
                }
                catch (KeyNotFoundException e) {
                    LogServiceFactory.getInstance().logWarning("Unable to load category.", (Throwable)e);
                }
            }
            if (!callbackHandler.beforeCopy(sourceItem, copiedItem)) continue;
            GradableItemDAO.get().persist(copiedItem);
            InteractiveActivityManagerFactory.getInstance().copyDefinitions(sourceItem.getId(), copiedItem.getId());
            callbackHandler.afterCopy(sourceItem, copiedItem);
        }
    }

    private GradingSchema getSchemaId() throws Exception {
        List schemas = GradingSchemaDAO.get().loadByCourseIdAndTitle(this._targetCourseId, BaseGradingSchema.Type.DEFAULT.getTitle(), true);
        if (schemas != null && schemas.size() > 0) {
            return (GradingSchema)schemas.get(0);
        }
        throw new Exception();
    }

    public static class BaseOnCopyHandler
    implements OnCopyHandler {
        @Override
        public boolean beforeCopy(GradableItem originalItem, GradableItem copiedItem) {
            return true;
        }

        @Override
        public void afterCopy(GradableItem originalItem, GradableItem copiedItem) {
        }
    }

    public static interface OnCopyHandler {
        public boolean beforeCopy(GradableItem var1, GradableItem var2);

        public void afterCopy(GradableItem var1, GradableItem var2);
    }
}

