/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.soap.admincourse;

import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Organization;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.OrganizationLoader;
import blackboard.admin.persist.course.OrganizationPersister;
import blackboard.admin.persist.course.impl.soap.admincourse.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.ValidationException;
import blackboard.data.user.User;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.PersistenceRuntimeException;
import blackboard.persist.user.UserDbLoader;
import blackboard.platform.context.ContextManagerFactory;
import blackboard.platform.context.impl.ContextImpl;
import blackboard.platform.persistence.PersistenceServiceFactory;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "admincourse.id.list";

    public static void clone(String srcCrsBatchUid, String tgtCrsBatchUid, String strCfg) throws PersistenceException, ValidationException, ConstraintViolationException {
        CloneConfig cfg = (CloneConfig)ObjectSerializer.deSerializeObject((String)strCfg);
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister("CourseSitePersister");
        ContextImpl c = (ContextImpl)ContextManagerFactory.getInstance().getContext();
        User currentUser = c.getUser();
        User admin = UserDbLoader.Default.getInstance().loadByUserName("administrator");
        c.setUser(admin);
        p.clone(srcCrsBatchUid, tgtCrsBatchUid, cfg);
        c.setUser(currentUser);
    }

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        SnapshotPersister p = ServerUtility.getPersister(list);
        for (AdminCourse adminCourse : list) {
            if (p instanceof OrganizationPersister) {
                ((OrganizationPersister)p).insert((Organization)adminCourse);
            } else {
                ((CourseSitePersister)p).insert((CourseSite)adminCourse);
            }
            aList.add(adminCourse.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        SnapshotPersister p = ServerUtility.getPersister(list);
        for (AdminCourse adminCourse : list) {
            if (p instanceof OrganizationPersister) {
                ((OrganizationPersister)p).update((Organization)adminCourse);
            } else {
                ((CourseSitePersister)p).update((CourseSite)adminCourse);
            }
            aList.add(adminCourse.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        SnapshotPersister p = ServerUtility.getPersister(list);
        for (AdminCourse adminCourse : list) {
            if (p instanceof OrganizationPersister) {
                ((OrganizationPersister)p).save((Organization)adminCourse);
            } else {
                ((CourseSitePersister)p).save((CourseSite)adminCourse);
            }
            aList.add(adminCourse.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(props, obj, CourseSite.DATA_TYPE);
        SnapshotPersister p = ServerUtility.getPersister(list);
        Results results = Authority.delegateAdminCoursePersistence(list, p, session, null, false);
        Iterator<? extends AdminCourse> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            AdminCourse tmp = iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException {
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        SnapshotPersister p = ServerUtility.getPersister(list);
        AdminCourse cSite = list.get(0);
        if (p instanceof OrganizationPersister) {
            try {
                ((OrganizationPersister)p).remove((Organization)cSite);
            }
            catch (ValidationException e) {
                throw new PersistenceException((Throwable)e);
            }
        } else {
            ((CourseSitePersister)p).remove((CourseSite)cSite);
        }
    }

    public static String removeList(String obj) throws PersistenceException {
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        SnapshotPersister p = ServerUtility.getPersister(list);
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid, String persisterType) throws PersistenceException {
        return ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String persisterType, String sessionId) throws PersistenceException {
        ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId, String persisterType) throws PersistenceException {
        SnapshotPersister p = ServerUtility.getPersister(persisterType);
        p.closeSession(strSessionId);
    }

    public static String load(String batchUid, String loaderType) throws PersistenceException, KeyNotFoundException {
        AdminCourse obj = null;
        Loader oLoader = ServerUtility.getLoader(loaderType);
        obj = loaderType.equals("OrganizationLoader") ? ((OrganizationLoader)oLoader).load(batchUid) : ((CourseSiteLoader)oLoader).load(batchUid);
        return ClientUtility.convertToString(obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        List<? extends AdminCourse> list = ServerUtility.unMarshallObjects(template, AdminCourse.DATA_TYPE);
        if (list.isEmpty()) {
            return "";
        }
        AdminCourse pObj = list.get(0);
        if (pObj instanceof Organization) {
            OrganizationLoader oLoader = OrganizationLoader.Default.getInstance();
            list = oLoader.load((Organization)pObj);
        } else {
            CourseSiteLoader cLoader = CourseSiteLoader.Default.getInstance();
            list = cLoader.load((CourseSite)pObj);
        }
        return ClientUtility.convertToString(list);
    }

    public static String convert(String obj) throws PersistenceException, ValidationException {
        throw new PersistenceRuntimeException("No longer supported.");
    }

    private static SnapshotPersister getPersister(List l) throws PersistenceException {
        Object pObj;
        String type = "CourseSitePersister";
        if (l.size() > 0 && (pObj = l.get(0)) instanceof Organization) {
            type = "OrganizationPersister";
        }
        return ServerUtility.getPersister(type);
    }

    private static SnapshotPersister getPersister(String type) throws PersistenceException {
        return (SnapshotPersister)PersistenceServiceFactory.getInstance().getDbPersistenceManager().getPersister(type);
    }

    private static Loader getLoader(String type) throws PersistenceException {
        return PersistenceServiceFactory.getInstance().getDbPersistenceManager().getLoader(type);
    }

    public static List<? extends AdminCourse> unMarshallObjects(String src, DataType dType) throws PersistenceException {
        return ServerUtility.unMarshallObjects(new Properties(), src, dType);
    }

    public static List<? extends AdminCourse> unMarshallObjects(Properties props, String src, DataType dType) throws PersistenceException {
        try {
            props.setProperty("DATA_TYPE_TOGGLE", dType.getName());
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

