/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.data.institutinalhierarchy.CourseAssociation;
import blackboard.admin.data.institutinalhierarchy.InstitutionalHierarchyNode;
import blackboard.admin.data.institutinalhierarchy.OrganizationAssociation;
import blackboard.admin.data.institutinalhierarchy.UserAssociation;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourceManager;
import blackboard.admin.persist.datasource.impl.mapping.DataSourceDbMap;
import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.base.BbList;
import blackboard.data.datasource.BbDataSource;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.datasource.impl.DataSourceCache;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.SelectQuery;
import blackboard.persist.impl.SimpleSelectQuery;
import blackboard.persist.impl.mapping.Mapping;
import blackboard.platform.term.Term;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;

public class DataSourceDbLoader
extends AdminNewBaseDbLoader<DataSource>
implements DataSourceLoader {
    private static final String GROUP = "course_main";
    private static final String MEMBERSHIP = "course_users";
    private static final String PERSON = "users";
    private static final String COURSE_CATEGORIES = "gateway_categories";
    private static final String ORGANIZATION_CATEGORIES = "community_categories";
    private static final String COURSE_CATEGORY_MEMBERSHIP = "gateway_course_categories";
    private static final String ORGANIZATION_CATEGORY_MEMBERSHIP = "community_course_categories";
    private static final String PORTAL_ROLE_MEMBERSHIP = "user_roles";
    private static final String OBSERVER_ASSOCIATION = "observer_user";
    private static final String COURSE_COURSE = "course_course";
    private static final String TERM = "term";
    private static final String NODE = "mi_node";
    private static final String USER_ASSOCIATION = "domain_user_coll";
    private static final String COURSE_ASSOCIATION = "domain_course_coll";
    private static final String ORGANIZATION_ASSOCIATION = "domain_organization_coll";

    @Override
    public DataSource loadByBatchUid(String batchUid) throws PersistenceException {
        SimpleSelectQuery query = new SimpleSelectQuery(DataSourceDbMap.MAP);
        query.addWhere("BatchUid", (Object)batchUid);
        DataSource ds = (DataSource)super.loadObject((SelectQuery)query, null);
        DataSourceCache.getInstance().putDataSourceInCache((BbDataSource)ds);
        return ds;
    }

    @Override
    public DataSource loadDefault() throws PersistenceException, KeyNotFoundException {
        return this.loadByBatchUid("SYSTEM");
    }

    @Override
    public BbList<DataSource> loadAll() throws PersistenceException {
        super.checkApiLicensing();
        SimpleSelectQuery query = new SimpleSelectQuery(DataSourceDbMap.MAP);
        BbList dsList = super.loadList((SelectQuery)query, null);
        for (DataSource ds : dsList) {
            DataSourceCache.getInstance().putDataSourceInCache((BbDataSource)ds);
        }
        return dsList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSourceObjectCount loadAdminObjectCount(String dataSourceBatchUid, DataType dataType, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        DataSourceObjectCount dCount;
        super.checkApiLicensing();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rst = null;
        String tableName = DataSourceDbLoader.getDbTableName(dataType);
        DataSource ds = this.loadByBatchUid(dataSourceBatchUid);
        List<DataType> nonRowStatusEntityDataTypes = Arrays.asList(DataSourceManager.NON_ROW_STATUS_ENTITY_DATA_TYPES);
        StringBuilder query = new StringBuilder();
        boolean isNonRowStatusDataType = nonRowStatusEntityDataTypes.contains(dataType);
        query.append("select count(*) from ");
        query.append(tableName);
        query.append(" where data_src_pk1 = ? ");
        if (!isNonRowStatusDataType && status != null) {
            query.append("and row_status = ?");
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query.toString());
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)ds.getId());
            if (!isNonRowStatusDataType && status != null) {
                Mapping map = DataSourceDbMap.MAP.getMapping("RowStatus");
                map.marshall(this._pm.getContainer(), stmt, 2, (Object)status);
            }
            rst = stmt.executeQuery();
            dCount = this.unmarshall(rst, tableName);
        }
        catch (SQLException sqe) {
            try {
                throw new PersistenceException((Throwable)sqe);
                catch (ConnectionNotAvailableException cna) {
                    throw new PersistenceException((Throwable)cna);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rst);
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((ResultSet)rst);
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
        return dCount;
    }

    protected static String getDbTableName(DataType dataType) throws KeyNotFoundException {
        if (dataType.equals((Object)CourseSite.DATA_TYPE)) {
            return GROUP;
        }
        if (dataType.equals((Object)Organization.DATA_TYPE)) {
            return GROUP;
        }
        if (dataType.equals((Object)OrganizationMembership.DATA_TYPE)) {
            return MEMBERSHIP;
        }
        if (dataType.equals((Object)Enrollment.DATA_TYPE)) {
            return MEMBERSHIP;
        }
        if (dataType.equals((Object)StaffAssignment.DATA_TYPE)) {
            return MEMBERSHIP;
        }
        if (dataType.equals((Object)Person.DATA_TYPE)) {
            return PERSON;
        }
        if (dataType.equals((Object)CourseCategory.DATA_TYPE)) {
            return COURSE_CATEGORIES;
        }
        if (dataType.equals((Object)OrganizationCategory.DATA_TYPE)) {
            return ORGANIZATION_CATEGORIES;
        }
        if (dataType.equals((Object)CourseCategoryMembership.DATA_TYPE)) {
            return COURSE_CATEGORY_MEMBERSHIP;
        }
        if (dataType.equals((Object)OrganizationCategoryMembership.DATA_TYPE)) {
            return ORGANIZATION_CATEGORY_MEMBERSHIP;
        }
        if (dataType.equals((Object)PortalRoleMembership.DATA_TYPE)) {
            return PORTAL_ROLE_MEMBERSHIP;
        }
        if (dataType.equals((Object)ObserverAssociation.DATA_TYPE)) {
            return OBSERVER_ASSOCIATION;
        }
        if (dataType.equals((Object)AdminCourseCourse.DATA_TYPE)) {
            return COURSE_COURSE;
        }
        if (dataType.equals((Object)Term.DATA_TYPE)) {
            return TERM;
        }
        if (dataType.equals((Object)InstitutionalHierarchyNode.DATA_TYPE)) {
            return NODE;
        }
        if (dataType.equals((Object)UserAssociation.DATA_TYPE)) {
            return USER_ASSOCIATION;
        }
        if (dataType.equals((Object)CourseAssociation.DATA_TYPE)) {
            return COURSE_ASSOCIATION;
        }
        if (dataType.equals((Object)OrganizationAssociation.DATA_TYPE)) {
            return ORGANIZATION_ASSOCIATION;
        }
        throw new KeyNotFoundException("Data type not recognized: " + dataType);
    }

    @Override
    public BbList<DataSourceObjectCount> loadAllAdminObjectCounts(String dataSourceBatchUid, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        BbList list = new BbList();
        List<DataType> nonRowStatusEntityDataTypes = Arrays.asList(DataSourceManager.NON_ROW_STATUS_ENTITY_DATA_TYPES);
        for (DataSourceManager.EntityType element : DataSourceManager.EntityType.values()) {
            if (IAdminObject.RowStatus.ENABLED == status || null == status || !nonRowStatusEntityDataTypes.contains(element.getDataType())) {
                list.add((Object)this.loadAdminObjectCount(dataSourceBatchUid, element.getDataType(), status));
                continue;
            }
            DataSourceObjectCount dsoc = new DataSourceObjectCount();
            dsoc.setObjectCount(0L);
            dsoc.setObjectDataTable(element.getTableName());
            list.add((Object)dsoc);
        }
        return list;
    }

    private DataSourceObjectCount unmarshall(ResultSet rst, String tableName) throws SQLException {
        DataSourceObjectCount dCount = new DataSourceObjectCount();
        if (rst.next()) {
            dCount.setObjectCount(rst.getLong(1));
            dCount.setObjectDataTable(tableName);
        }
        return dCount;
    }

    @Override
    public BbList<DataSourceObjectCount> loadAllAdminObjectCountsForDisable(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        BbList list = new BbList();
        List<DataType> nonRowStatusEntityDataTypes = Arrays.asList(DataSourceManager.NON_ROW_STATUS_ENTITY_DATA_TYPES);
        for (DataSourceManager.EntityType element : DataSourceManager.EntityType.values()) {
            if (nonRowStatusEntityDataTypes.contains(element.getDataType())) continue;
            list.add((Object)this.loadAdminObjectCount(dataSourceBatchUid, element.getDataType(), IAdminObject.RowStatus.ENABLED));
        }
        return list;
    }

    @Override
    public BbList<DataSourceObjectCount> loadAllAdminObjectCountsForPurge(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        BbList list = new BbList();
        List<DataType> nonRowStatusEntityDataTypes = Arrays.asList(DataSourceManager.NON_ROW_STATUS_ENTITY_DATA_TYPES);
        for (DataSourceManager.EntityType element : DataSourceManager.EntityType.values()) {
            if (!nonRowStatusEntityDataTypes.contains(element.getDataType())) {
                list.add((Object)this.loadAdminObjectCount(dataSourceBatchUid, element.getDataType(), IAdminObject.RowStatus.DISABLED));
                continue;
            }
            list.add((Object)this.loadAdminObjectCount(dataSourceBatchUid, element.getDataType(), null));
        }
        return list;
    }
}

