/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.institutinalhierarchy.CourseAssociation;
import blackboard.admin.data.institutinalhierarchy.InstitutionalHierarchyNode;
import blackboard.admin.data.institutinalhierarchy.OrganizationAssociation;
import blackboard.admin.data.institutinalhierarchy.UserAssociation;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.admin.manager.impl.TemporarySnapshotSessionManagerFactory;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryLoaderDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryMembershipLoaderDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryLoaderDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryMembershipLoaderDbMap;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.mapping.AdminCourseCourseLoaderDbMap;
import blackboard.admin.persist.course.impl.mapping.EnrollmentDbMap;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourceManager;
import blackboard.admin.persist.datasource.DataSourceManagerFactory;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.admin.persist.datasource.impl.AdminDeleteProcedureQuery;
import blackboard.admin.persist.datasource.impl.DataSourceDbLoader;
import blackboard.admin.persist.datasource.impl.mapping.DataSourceDbMap;
import blackboard.admin.persist.institutionalhierarchy.mapping.CourseAssociationLoaderDbMap;
import blackboard.admin.persist.institutionalhierarchy.mapping.OrganizationAssociationLoaderDbMap;
import blackboard.admin.persist.institutionalhierarchy.mapping.UserAssociationLoaderDbMap;
import blackboard.admin.persist.role.impl.mapping.PortalRoleMembershipLoaderDbMap;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationLoaderDbMap;
import blackboard.admin.persist.user.impl.mapping.PersonLoaderDbMap;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.RowStatus;
import blackboard.data.ValidationException;
import blackboard.data.datasource.BbDataSource;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.datasource.impl.DataSourceCache;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.NewBaseDbPersister;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.Mapping;
import blackboard.persist.impl.mapping.StringMapping;
import blackboard.platform.LicenseComponent;
import blackboard.platform.LicenseManagerFactory;
import blackboard.platform.dataintegration.impl.DataIntegrationDAO;
import blackboard.platform.institutionalhierarchy.service.impl.NodeDAO;
import blackboard.platform.term.Term;
import blackboard.platform.term.impl.TermDAO;
import blackboard.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class DataSourceDbPersister
extends NewBaseDbPersister<DataSource>
implements DataSourcePersister {
    public static final String[] SNAPSHOT_TABLE_NAMES = new String[]{"tmp_key_maps", "tmp_cc_keys", "tmp_course_keys", "tmp_cu_keys", "tmp_org_keys", "tmp_ou_keys", "tmp_ccc_key_mappings", "tmp_ccc_keys", "tmp_gc_keys", "tmp_obs_user_keys", "tmp_ss_session", "tmp_ccm_keys", "tmp_gcc_keys", "tmp_user_keys", "tmp_ccc_badpk1", "tmp_userrole_keys"};

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        super.init(pm, appVersion);
        LicenseManagerFactory.getInstance().runtimeAssertIsLicensed(LicenseComponent.INTEGRATION_APIS);
    }

    @Override
    public void create(DataSource target) throws PersistenceException, ValidationException {
        super.doPersist(DataSourceDbMap.MAP, (Object)target, null);
        DataSourceCache.getInstance().putDataSourceInCache((BbDataSource)target);
    }

    @Override
    public void modify(DataSource target) throws PersistenceException, ValidationException, KeyNotFoundException {
        target.validate();
        DataSourceLoader dLoader = (DataSourceLoader)this._pm.getLoader("DataSourceLoader");
        DataSource ds = dLoader.loadByBatchUid(target.getBatchUid());
        Connection con = null;
        PreparedStatement stmt = null;
        String query = "update data_source set batch_uid=?, description=? where batch_uid = ?";
        if (target.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            ds.setBatchUid(target.getReplacementBatchUid());
        }
        if (target.getBbAttributes().getBbAttribute("Description").getIsDirty()) {
            ds.setDescription(target.getDescription());
        } else {
            target.setDescription(ds.getDescription());
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)1, (String)ds.getBatchUid());
            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)2, (String)ds.getDescription());
            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)3, (String)target.getBatchUid());
            stmt.executeUpdate();
            DataSourceCache.getInstance().putDataSourceInCache((BbDataSource)target);
        }
        catch (Exception sqe) {
            try {
                throw new PersistenceException((Throwable)sqe);
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeByBatchUid(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        Connection con = null;
        PreparedStatement stmt = null;
        String query = "delete from data_source where batch_uid = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)1, (String)dataSourceBatchUid);
            int rowsDeleted = stmt.executeUpdate();
            if (rowsDeleted == 0) {
                throw new KeyNotFoundException("Data source not found for : " + dataSourceBatchUid);
            }
            DataSourceCache.getInstance().flushDataSourceByBatchUid(dataSourceBatchUid);
            if (StringUtil.notEmpty((String)dataSourceBatchUid)) {
                new DataIntegrationDAO().unslaveIntegrationsByBatchUid(dataSourceBatchUid);
            }
        }
        catch (KeyNotFoundException knf) {
            try {
                throw knf;
                catch (Exception sqe) {
                    throw new PersistenceException((Throwable)sqe);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeById(Id id) throws PersistenceException, KeyNotFoundException {
        Connection con = null;
        PreparedStatement stmt = null;
        String strId = id.toExternalString();
        String query = "delete from data_source where pk1 = ?";
        try {
            int rowsDeleted;
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            DbUtil.setNString((BbDatabase)this._bbDatabase, (PreparedStatement)stmt, (int)1, (String)strId);
            if (Id.isValid((Id)id)) {
                new DataIntegrationDAO().unslaveIntegrationsById(id);
            }
            if ((rowsDeleted = stmt.executeUpdate()) == 0) {
                throw new KeyNotFoundException("Data source not found for : " + strId);
            }
            DataSourceCache.getInstance().flushDataSourceById(id);
        }
        catch (KeyNotFoundException knf) {
            try {
                throw knf;
                catch (Exception sqe) {
                    throw new PersistenceException((Throwable)sqe);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    @Override
    public void disableAllAdminObjects(String dataSrcBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        for (DataSourceManager.EntityType element : DataSourceManager.EntityType.values()) {
            this.disableAdminObjectsByDataType(dataSrcBatchUid, element.getDataType(), cal);
        }
    }

    @Override
    public void disableAdminObjectsByDataType(String dataSrcBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        List<DataType> nonRowStatusEntityDataTypes = Arrays.asList(DataSourceManager.NON_ROW_STATUS_ENTITY_DATA_TYPES);
        if (nonRowStatusEntityDataTypes.contains(dataType)) {
            return;
        }
        Connection con = null;
        PreparedStatement stmt = null;
        String tableName = DataSourceDbLoader.getDbTableName(dataType);
        DataSourceLoader dLoader = (DataSourceLoader)this._pm.getLoader("DataSourceLoader");
        DataSource ds = dLoader.loadByBatchUid(dataSrcBatchUid);
        String query = "update " + tableName + " set row_status = ? where data_src_pk1 = ? ";
        if (cal != null) {
            query = query + "and dtmodified < ?";
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            Mapping map = DataSourceDbMap.MAP.getMapping("RowStatus");
            map.marshall(this._pm.getContainer(), stmt, 1, (Object)IAdminObject.RowStatus.DISABLED);
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)ds.getId());
            if (cal != null) {
                stmt.setTimestamp(3, TimeFormat.calendarToTimestamp(cal));
            }
            stmt.executeUpdate();
        }
        catch (Exception sqe) {
            try {
                throw new PersistenceException((Throwable)sqe);
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    @Override
    public void purgeAllAdminObjects(String dataSrcBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        for (DataSourceManager.EntityType element : DataSourceManager.EntityType.values()) {
            this.purgeAdminObjectsByDataType(dataSrcBatchUid, element.getDataType(), cal);
        }
    }

    @Override
    public void purgeAdminObjectsByDataType(String dataSrcBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        AdminDeleteProcedureQuery query = null;
        if (dataType.equals((Object)Person.DATA_TYPE)) {
            query = new AdminDeleteProcedureQuery(PersonLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
            query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
            query.addParameter("modifiedDate", cal);
            query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
        } else {
            if (dataType.equals((Object)CourseSite.DATA_TYPE) || dataType.equals((Object)Organization.DATA_TYPE)) {
                this.purgeCoursesByDataSourceBatchUid(dataSrcBatchUid, cal);
                return;
            }
            if (dataType.equals((Object)Enrollment.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(EnrollmentDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)StaffAssignment.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(EnrollmentDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)OrganizationMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(EnrollmentDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)CourseCategory.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(CourseCategoryLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)OrganizationCategory.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(OrganizationCategoryLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)CourseCategoryMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(CourseCategoryMembershipLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)OrganizationCategoryMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(OrganizationCategoryMembershipLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)PortalRoleMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(PortalRoleMembershipLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)ObserverAssociation.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(ObserverAssociationLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)AdminCourseCourse.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(AdminCourseCourseLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)Term.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(TermDAO.get().getMap(), DataSourceDbLoader.getDbTableName(dataType));
                Id dataSourceId = DataSourceManagerFactory.getInstance().loadByBatchUid(dataSrcBatchUid).getId();
                query.addParameter("dataSourceId", dataSourceId);
                query.addParameter("dtmodified", cal);
                query.addParameter("rowStatus", Integer.parseInt(RowStatus.Disabled.getValue()));
            } else if (dataType.equals((Object)InstitutionalHierarchyNode.DATA_TYPE)) {
                DbObjectMap nodeMap = NodeDAO.getMap();
                nodeMap.addMapping((Mapping)new StringMapping("DataSourceBatchUid", "data_src_batch_uid", Mapping.Use.INPUT, Mapping.Use.INPUT, false, true));
                query = new AdminDeleteProcedureQuery(nodeMap, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("dtmodified", cal);
            } else if (dataType.equals((Object)UserAssociation.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(UserAssociationLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
            } else if (dataType.equals((Object)CourseAssociation.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(CourseAssociationLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
            } else if (dataType.equals((Object)OrganizationAssociation.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(OrganizationAssociationLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
            } else {
                throw new KeyNotFoundException("Data type not recognized: " + dataType);
            }
        }
        super.runQuery((Query)query, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void purgeSnapshotSessions() throws PersistenceException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.createStatement();
            for (String tableName : SNAPSHOT_TABLE_NAMES) {
                stmt.executeUpdate("delete from " + tableName);
            }
        }
        catch (ConnectionNotAvailableException cna) {
            try {
                throw new PersistenceException((Throwable)cna);
                catch (SQLException sqe) {
                    throw new PersistenceException((Throwable)sqe);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private void purgeCoursesByDataSourceBatchUid(String dataSrcBatchUid, Calendar cal) throws PersistenceException {
        CourseSiteLoader loader = (CourseSiteLoader)this._pm.getLoader("CourseSiteLoader");
        CourseSitePersister persister = (CourseSitePersister)this._pm.getPersister("CourseSitePersister");
        CourseSite crs = new CourseSite();
        crs.setDataSourceBatchUid(dataSrcBatchUid);
        crs.setRowStatus(IAdminObject.RowStatus.DISABLED);
        BbList<CourseSite> list = loader.load(crs);
        for (CourseSite course : list) {
            if (course.getModifiedDate() != null && course.getModifiedDate().after(cal)) continue;
            persister.remove(course);
        }
    }

    @Override
    public String beginSnapshotSession() throws PersistenceException {
        return TemporarySnapshotSessionManagerFactory.getInstance().createSnapshotSession();
    }

    @Override
    public void beginSnapshotSession(String sessionId) throws PersistenceException {
        TemporarySnapshotSessionManagerFactory.getInstance().createSnapshotSession(sessionId);
    }

    @Override
    public void endSnapshotSession(String sessionId) throws PersistenceException {
        TemporarySnapshotSessionManagerFactory.getInstance().deleteBySessionId(sessionId);
    }
}

