/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourceManager;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataSourceManagerImpl
implements DataSourceManager {
    @Override
    public List<DataSource> loadAll() throws PersistenceException {
        return DataSourceLoader.Default.getInstance().loadAll();
    }

    @Override
    public DataSource loadByBatchUid(String batchUid) throws PersistenceException, KeyNotFoundException {
        return DataSourceLoader.Default.getInstance().loadByBatchUid(batchUid);
    }

    @Override
    public DataSource create(String batchUid, String description) throws PersistenceException, ValidationException {
        DataSourcePersister persister = DataSourcePersister.Default.getInstance();
        DataSource ds = new DataSource();
        ds.setBatchUid(batchUid);
        ds.setDescription(description);
        persister.create(ds);
        return ds;
    }

    @Override
    public void modify(DataSource ds) throws PersistenceException, KeyNotFoundException, ValidationException {
        DataSourcePersister.Default.getInstance().modify(ds);
    }

    @Override
    public void delete(String batchUid) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister.Default.getInstance().removeByBatchUid(batchUid);
    }

    @Override
    public void disableAll(String batchUid, Calendar cutoffDate) throws PersistenceException {
        DataSourcePersister.Default.getInstance().disableAllAdminObjects(batchUid, cutoffDate);
    }

    @Override
    public void disableEntity(String batchUid, DataSourceManager.EntityType entityType, Calendar cutoffDate) throws PersistenceException {
        DataSourcePersister.Default.getInstance().disableAdminObjectsByDataType(batchUid, entityType.getDataType(), cutoffDate);
    }

    @Override
    public void purgeAll(String batchUid, Calendar cutoffDate) throws PersistenceException {
        DataSourcePersister.Default.getInstance().purgeAllAdminObjects(batchUid, cutoffDate);
    }

    @Override
    public void purgeEntity(String batchUid, DataSourceManager.EntityType entityType, Calendar cutoffDate) throws PersistenceException {
        DataSourcePersister.Default.getInstance().purgeAdminObjectsByDataType(batchUid, entityType.getDataType(), cutoffDate);
    }

    @Override
    public void purgeSnapshotSessions() throws PersistenceException {
        DataSourcePersister.Default.getInstance().purgeSnapshotSessions();
    }

    @Override
    public String beginSnapshotSession() throws PersistenceException {
        return DataSourcePersister.Default.getInstance().beginSnapshotSession();
    }

    @Override
    public void beginSnapshotSession(String sessionId) throws PersistenceException {
        DataSourcePersister.Default.getInstance().beginSnapshotSession(sessionId);
    }

    @Override
    public void endSnapshotSession(String sessionId) throws PersistenceException {
        DataSourcePersister.Default.getInstance().endSnapshotSession(sessionId);
    }

    @Override
    public Map<DataSourceManager.EntityType, Long> loadObjectCounts(String batchUid, IAdminObject.RowStatus status) throws PersistenceException {
        BbList<DataSourceObjectCount> counts = DataSourceLoader.Default.getInstance().loadAllAdminObjectCounts(batchUid, status);
        return this.getCounts((List<DataSourceObjectCount>)counts);
    }

    @Override
    public Map<DataSourceManager.EntityType, Long> loadObjectCountsForDisable(String batchUid) throws PersistenceException {
        BbList<DataSourceObjectCount> counts = DataSourceLoader.Default.getInstance().loadAllAdminObjectCountsForDisable(batchUid);
        return this.getCounts((List<DataSourceObjectCount>)counts);
    }

    @Override
    public Map<DataSourceManager.EntityType, Long> loadObjectCountsForPurge(String batchUid) throws PersistenceException {
        BbList<DataSourceObjectCount> counts = DataSourceLoader.Default.getInstance().loadAllAdminObjectCountsForPurge(batchUid);
        return this.getCounts((List<DataSourceObjectCount>)counts);
    }

    private Map<DataSourceManager.EntityType, Long> getCounts(List<DataSourceObjectCount> counts) {
        LinkedHashMap<DataSourceManager.EntityType, Long> result = new LinkedHashMap<DataSourceManager.EntityType, Long>();
        for (DataSourceObjectCount c : counts) {
            result.put(DataSourceManager.EntityType.fromTableName(c.getObjectDataTable()), c.getObjectCount());
        }
        return result;
    }
}

