/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.datasource.DataSourceManager;
import blackboard.admin.persist.datasource.DataSourceManagerFactory;
import blackboard.platform.context.ContextManagerFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.queue.BaseQueuedOperation;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.BundleUtil;
import blackboard.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

public class DataSourceQueuedOperation
extends BaseQueuedOperation {
    public static final String TYPE_CODE = "DataSourceQueuedOperation";
    private static final String PARAM_MODE = "mode";
    private static final String PARAM_DATA_SOURCE_BATCH_UID = "dataSourceBatchUid";
    private static final String PARAM_ENTITIES = "entities";
    private static final String PARAM_CUTOFF_DATE = "cutoffDate";
    private Mode _mode;
    private String _batchUid;
    private List<DataSourceManager.EntityType> _entities;
    private Calendar _cutoffDate;
    private DataSource _dataSource;

    public static QueueTask createTask(Mode mode, String dataSourceBatchUid, List<DataSourceManager.EntityType> entities, Calendar cutoffDate) {
        if (mode == null || StringUtil.isEmpty((String)dataSourceBatchUid)) {
            throw new IllegalArgumentException("Invalid arguments specified: mode= " + (Object)((Object)mode) + ", dataSourceBatchUid=" + dataSourceBatchUid);
        }
        Properties props = new Properties();
        props.setProperty(PARAM_MODE, mode.name());
        props.setProperty(PARAM_DATA_SOURCE_BATCH_UID, dataSourceBatchUid);
        if (entities != null && !entities.isEmpty()) {
            StringBuilder entitiesStr = new StringBuilder();
            for (DataSourceManager.EntityType entity : entities) {
                entitiesStr.append(entity.name()).append(",");
            }
            entitiesStr.setLength(entitiesStr.length() - 1);
            props.setProperty(PARAM_ENTITIES, entitiesStr.toString());
        }
        if (cutoffDate != null) {
            props.setProperty(PARAM_CUTOFF_DATE, String.valueOf(cutoffDate.getTimeInMillis()));
        }
        QueueTask task = new QueueTask();
        task.setArguments(props);
        task.setTitle("snapshot|dsm.queued.operation." + (mode == Mode.Disable ? "disable" : "purge") + ".title|" + dataSourceBatchUid);
        task.setType(TYPE_CODE);
        task.setInitiatorUserId(ContextManagerFactory.getInstance().getContext().getUserId());
        return task;
    }

    public String getTypeCode() {
        return TYPE_CODE;
    }

    public String execute() {
        String result;
        String cutoffStr;
        Properties arguments = this._task.getArgumentsAsProperties();
        this._mode = Mode.valueOf(arguments.getProperty(PARAM_MODE));
        this._batchUid = arguments.getProperty(PARAM_DATA_SOURCE_BATCH_UID);
        String entitiesStr = arguments.getProperty(PARAM_ENTITIES);
        this._entities = new ArrayList<DataSourceManager.EntityType>();
        if (StringUtil.notEmpty((String)entitiesStr)) {
            String[] parts;
            for (String part : parts = entitiesStr.split(",")) {
                this._entities.add(DataSourceManager.EntityType.valueOf(part));
            }
        }
        if (StringUtil.notEmpty((String)(cutoffStr = arguments.getProperty(PARAM_CUTOFF_DATE)))) {
            this._cutoffDate = Calendar.getInstance();
            this._cutoffDate.setTimeInMillis(Long.parseLong(cutoffStr));
        }
        DataSourceManager dsm = DataSourceManagerFactory.getInstance();
        try {
            this._dataSource = dsm.loadByBatchUid(this._batchUid);
            if (this._entities.isEmpty()) {
                if (this._mode == Mode.Disable) {
                    dsm.disableAll(this._batchUid, this._cutoffDate);
                    result = "dsm.queued.operation.disable.all.success";
                } else {
                    dsm.purgeAll(this._batchUid, this._cutoffDate);
                    result = "dsm.queued.operation.purge.all.success";
                }
            } else {
                for (DataSourceManager.EntityType entity : this._entities) {
                    if (this._mode == Mode.Disable) {
                        dsm.disableEntity(this._batchUid, entity, this._cutoffDate);
                        continue;
                    }
                    dsm.purgeEntity(this._batchUid, entity, this._cutoffDate);
                }
                result = this._mode == Mode.Disable ? "dsm.queued.operation.disable.entities.success" : "dsm.queued.operation.purge.entities.success";
            }
            this._status = QueueTask.Status.COMPLETE;
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Error executing DataSourceQueuedOperation.", (Throwable)e);
            result = "dsm.general.failure";
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        return "snapshot|" + result;
    }

    public String getDisplayName() {
        return BundleUtil.getMessage((String)"snapshot", (String)"dsm.queued.operation.type");
    }

    public String getStatusDetail(String strLocale) {
        if (this._status == QueueTask.Status.COMPLETE) {
            Object[] args = new String[]{this._batchUid, this._dataSource.getDescription() != null ? this._dataSource.getDescription() : ""};
            if (this._entities.isEmpty()) {
                return this.buildString(strLocale, "snapshot", "dsm." + (this._mode == Mode.Disable ? "disable" : "purge") + "all.success", args);
            }
            StringBuilder results = new StringBuilder();
            for (DataSourceManager.EntityType entity : this._entities) {
                String msgKeyEntity = "";
                switch (entity) {
                    case CourseCategory: {
                        msgKeyEntity = "category";
                        break;
                    }
                    case CourseCategoryMembership: {
                        msgKeyEntity = "categorymembership";
                        break;
                    }
                    case CourseCourse: {
                        msgKeyEntity = "crosslistassociation";
                        break;
                    }
                    case CourseOrg: {
                        msgKeyEntity = "group";
                        break;
                    }
                    case InstitutionRoleMembership: {
                        msgKeyEntity = "portalrolemembership";
                        break;
                    }
                    case Membership: {
                        msgKeyEntity = "membership";
                        break;
                    }
                    case ObserverAssociation: {
                        msgKeyEntity = "observerassociation";
                        break;
                    }
                    case OrganizationCategory: {
                        msgKeyEntity = "orgcategory";
                        break;
                    }
                    case OrganizationCategoryMembership: {
                        msgKeyEntity = "orgcategorymembership";
                        break;
                    }
                    case Person: {
                        msgKeyEntity = "person";
                    }
                }
                results.append(this.buildString(strLocale, "snapshot", "dsm." + (this._mode == Mode.Disable ? "disable" : "purge") + msgKeyEntity + ".success", args)).append("\n");
            }
            return results.toString();
        }
        return this.buildString(strLocale, "snapshot", "dsm.general.failure");
    }

    public String getStatusSummary(String strLocale) {
        Object[] args = new String[]{this._batchUid};
        if (this._status == QueueTask.Status.COMPLETE) {
            return this.buildString(strLocale, "snapshot", "dsm.queued.operation.email.subject.success", args);
        }
        return this.buildString(strLocale, "snapshot", "dsm.queued.operation.email.subject.failure", args);
    }

    public static enum Mode {
        Disable,
        Purge;

    }
}

