/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.impl.soap.ClientUtility;
import blackboard.admin.persist.datasource.impl.soap.ServerUtility;
import blackboard.admin.persist.impl.AdminLoader;
import blackboard.base.BbList;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.soap.ServerResponse;
import java.util.List;

public class DataSourceRemoteLoader
extends AdminLoader
implements DataSourceLoader {
    @Override
    public DataSource loadByBatchUid(String batchUid) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.load(batchUid);
        ServerResponse response = this.executeSoapCall(req);
        List<DataSource> list = ServerUtility.unMarshallDataSourceObject((String)response.getResults());
        return list.get(0);
    }

    @Override
    public DataSource loadDefault() throws PersistenceException, KeyNotFoundException {
        return this.loadByBatchUid("SYSTEM");
    }

    @Override
    public BbList<DataSource> loadAll() throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.load();
        ServerResponse response = this.executeSoapCall(req);
        return (BbList)ServerUtility.unMarshallDataSourceObject((String)response.getResults());
    }

    @Override
    public DataSourceObjectCount loadAdminObjectCount(String dataSourceBatchUid, DataType dataType, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.loadCount(dataSourceBatchUid, dataType, status);
        ServerResponse response = this.executeSoapCall(req);
        List<DataSourceObjectCount> list = ServerUtility.unMarshallDataSourceObjectCount((String)response.getResults());
        return list.get(0);
    }

    @Override
    public BbList<DataSourceObjectCount> loadAllAdminObjectCounts(String dataSourceBatchUid, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.loadAllCounts(dataSourceBatchUid, status);
        ServerResponse response = this.executeSoapCall(req);
        return (BbList)ServerUtility.unMarshallDataSourceObjectCount((String)response.getResults());
    }

    @Override
    public BbList<DataSourceObjectCount> loadAllAdminObjectCountsForDisable(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.loadAllCountsForDisable(dataSourceBatchUid);
        ServerResponse response = this.executeSoapCall(req);
        return (BbList)ServerUtility.unMarshallDataSourceObjectCount((String)response.getResults());
    }

    @Override
    public BbList<DataSourceObjectCount> loadAllAdminObjectCountsForPurge(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.loadAllCountsForPurge(dataSourceBatchUid);
        ServerResponse response = this.executeSoapCall(req);
        return (BbList)ServerUtility.unMarshallDataSourceObjectCount((String)response.getResults());
    }
}

