/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.TemporarySnapshotSession;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.admin.persist.datasource.impl.soap.ClientUtility;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import java.util.Calendar;

public class DataSourceRemotePersister
extends AdminPersister
implements DataSourcePersister {
    @Override
    public void create(DataSource dataSource) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.create(dataSource);
        this.executeSoapCall(req);
    }

    @Override
    public void modify(DataSource dataSource) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.modify(dataSource);
        this.executeSoapCall(req);
    }

    @Override
    public void removeByBatchUid(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.remove(dataSourceBatchUid);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void disableAllAdminObjects(String dataSourceBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.disableAll(dataSourceBatchUid, cal);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void disableAdminObjectsByDataType(String dataSourceBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.disable(dataSourceBatchUid, dataType, cal);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void purgeAllAdminObjects(String dataSourceBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.purgeAll(dataSourceBatchUid, cal);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void purgeAdminObjectsByDataType(String dataSourceBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.purge(dataSourceBatchUid, dataType, cal);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void purgeSnapshotSessions() throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.purgeSnapshotSessions();
        this.executeSoapCall(req);
    }

    @Override
    public String beginSnapshotSession() throws PersistenceException {
        String uuid = TemporarySnapshotSession.generateSnapshotSessionId();
        this.beginSnapshotSession(uuid);
        return uuid;
    }

    @Override
    public void beginSnapshotSession(String sessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.beginSnapshotSession(sessionId);
        this.executeSoapCall(req);
    }

    @Override
    public void endSnapshotSession(String sessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.endSnapshotSession(sessionId);
        this.executeSoapCall(req);
    }

    @Override
    public void removeById(Id id) throws PersistenceException, KeyNotFoundException {
    }
}

