/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.persist.impl.AdminSelectQuery;
import blackboard.base.AppVersion;
import blackboard.data.BbAttribute;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.data.user.User;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.impl.NewBaseDbLoader;
import blackboard.platform.LicenseComponent;
import blackboard.platform.LicenseManagerFactory;
import blackboard.platform.RuntimeBbServiceException;
import java.util.Calendar;
import java.util.List;

public class AdminNewBaseDbLoader<E>
extends NewBaseDbLoader<E> {
    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            super.init(pm, appVersion);
            try {
                this.checkApiLicensing();
            }
            catch (RuntimeBbServiceException exc) {
                if (!LicenseManagerFactory.getInstance().isLicensed(LicenseComponent.INTEGRATION_APIS)) break block2;
                throw exc;
            }
        }
    }

    protected void checkApiLicensing() {
        LicenseManagerFactory.getInstance().runtimeAssertIsLicensed(LicenseComponent.INTEGRATION_APIS);
    }

    protected void generateWhereClause(BbObject obj, AdminSelectQuery query) {
        BbAttributes bbAttribs = obj.getBbAttributes();
        List list = bbAttribs.getBbAttributeList();
        for (BbAttribute attrib : list) {
            if (!attrib.getIsDirty()) continue;
            if (attrib.getValue() == null || attrib.getValue() == User.Gender.UNKNOWN) {
                query.addNullWhere(attrib.getName());
                continue;
            }
            if (attrib.getValue() instanceof Calendar) {
                query.addDateAfterWhere(attrib.getName(), (Calendar)attrib.getValue());
                continue;
            }
            String value = attrib.getValue().toString();
            if (value.indexOf("%") >= 0 || value.indexOf("?") >= 0) {
                query.addLikeWhere(attrib.getName(), attrib.getValue());
                continue;
            }
            if (attrib.getType() == BbAttribute.Type.STRING) {
                if (attrib.getValue() != null) {
                    query.addLikeWhere(attrib.getName(), attrib.getValue());
                    continue;
                }
                query.addNullWhere(attrib.getName());
                continue;
            }
            query.addWhere(attrib.getName(), attrib.getValue());
        }
    }
}

