/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.data.IBbObject;
import blackboard.db.BbDatabase;
import blackboard.db.DbTypeFunctions;
import blackboard.db.DbUtil;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.GenericProcedureQuery;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.Mapping;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class AdminSaveProcedureQuery
extends GenericProcedureQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminSaveProcedureQuery(DbObjectMap map, BbObject obj) {
        super("save_" + map.getAliasTableName() + "_proc");
        DbObjectMap dbObjectMap = map;
        synchronized (dbObjectMap) {
            map.removeMapping("RecStatus");
            map.removeMapping("ImportTaskId");
        }
        List list = map.getMappingList();
        for (Mapping mapping : list) {
            String[] columns;
            Mapping.Use use = mapping.getInsertUse();
            if (use == Mapping.Use.NONE) continue;
            for (String column : columns = mapping.getColumns()) {
                if (use == Mapping.Use.INPUT) {
                    if (column.startsWith("p_")) {
                        this.addInputParameter(column);
                        continue;
                    }
                    this.addInputParameter("p_" + column);
                    this.addInputParameter("f_" + column);
                    continue;
                }
                if (use == Mapping.Use.OUTPUT) {
                    if (this.getUseResultSet()) {
                        this.addOutputParameter(column);
                        continue;
                    }
                    if (column.startsWith("p_")) {
                        this.addOutputParameter(column);
                        continue;
                    }
                    this.addOutputParameter("p_" + column);
                    continue;
                }
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("db.mapping.invalid");
                throw new RuntimeException(msg + use.toString());
            }
        }
        this._dbBbObjMap = map;
        this._obj = obj;
    }

    public boolean getUseResultSet() {
        if (this._bUseResultSet == null) {
            DbTypeFunctions dbTypeFunctions = BbDatabase.getDefaultInstance().getType().getFunctions();
            this._bUseResultSet = dbTypeFunctions.requiresResultSetForProcedureOutput();
        }
        return this._bUseResultSet;
    }

    protected void marshallParams(CallableStatement stmt) throws SQLException, SQLException, PersistenceException {
        if (!(this._obj instanceof IBbObject)) {
            throw new PersistenceException("CMS-Admin objects must implement IBbObject");
        }
        BbAttributes attribs = ((IBbObject)this._obj).getBbAttributes();
        List list = this._dbBbObjMap.getMappingList();
        for (Mapping mapping : list) {
            Mapping.Use use = mapping.getInsertUse();
            String mapName = mapping.getColumns()[0];
            int nStartPos = this.getColumnPosition(mapName);
            if (use == Mapping.Use.INPUT) {
                if (mapName.startsWith("p_")) {
                    mapping.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition(mapName), this._dbBbObjMap.getTargetValue(this._obj, mapping.getName()));
                    continue;
                }
                mapping.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition("p_" + mapName), this._dbBbObjMap.getTargetValue(this._obj, mapping.getName()));
                DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("f_" + mapName), (int)ConversionUtility.booleanToInt(attribs.getBbAttribute(mapping.getName()).getIsDirty()));
                continue;
            }
            if (use != Mapping.Use.OUTPUT || this.getUseResultSet()) continue;
            if (mapName.startsWith("p_")) {
                mapping.registerOutParameter(stmt, nStartPos);
                continue;
            }
            mapping.registerOutParameter(stmt, this.getColumnPosition("p_" + mapName));
        }
    }

    public void processResults(CallableStatement stmt) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        for (Mapping mapping : list) {
            String mapName = mapping.getColumns()[0];
            if (mapping.getInsertUse() != Mapping.Use.OUTPUT) continue;
            if (!mapName.startsWith("p_")) {
                mapName = "p_" + mapName;
            }
            Object obj = mapping.unmarshall(this.getContainer(), stmt, this.getColumnPosition(mapName));
            this._dbBbObjMap.setTargetValue(this._obj, mapping.getName(), obj);
        }
    }

    public void processResults(ResultSet rst) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        for (Mapping mapping : list) {
            if (mapping.getInsertUse() != Mapping.Use.OUTPUT) continue;
            Object obj = mapping.unmarshall(this.getContainer(), rst, null);
            this._dbBbObjMap.setTargetValue(this._obj, mapping.getName(), obj);
        }
    }
}

