/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.persist.user.PersonPersister;
import blackboard.admin.persist.user.impl.PersonDbLoader;
import blackboard.admin.persist.user.impl.mapping.PersonDeleteDbMap;
import blackboard.admin.persist.user.impl.mapping.PersonInsertDbMap;
import blackboard.admin.persist.user.impl.mapping.PersonPersisterDbMap;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.user.User;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import blackboard.persist.user.UserDbLoaderEx;
import blackboard.persist.user.impl.UserCache;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.user.event.UserLifecycleEventManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PersonDbPersister
extends SnapshotDbPersister<Person>
implements PersonPersister {
    private static final String[] CONSTRAINTS = new String[]{"USERS_PK", "USERS_AK1", "USERS_AK2"};
    private final UserCache _userCache = UserCache.getInstance();

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "user");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "user", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        List<Id> bbuserIds = null;
        try {
            PersonDbLoader loader = (PersonDbLoader)this._pm.getLoader("PersonLoader");
            bbuserIds = loader.loadBySessionId(strSessionId);
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Error in closeSession loadBySessionId", (Throwable)e);
        }
        super.closeSession(strSessionId, "user");
        if (bbuserIds != null) {
            for (Id userId : bbuserIds) {
                this._userCache.flushById(userId);
            }
        }
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((Person)obj, strSessionId);
    }

    @Override
    public Results save(List<Person> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        PersonDbLoader loader = (PersonDbLoader)this._pm.getLoader("PersonLoader");
        HashMap<Id, Person> oldPersonMap = new HashMap<Id, Person>(objList.size());
        HashSet<String> newPersonSet = new HashSet<String>(objList.size());
        for (Person p : objList) {
            Person oldPerson;
            String batchUid = p.getBatchUid();
            try {
                oldPerson = loader.load(batchUid);
            }
            catch (KeyNotFoundException e) {
                oldPerson = null;
            }
            if (null != oldPerson) {
                oldPersonMap.put(oldPerson.getId(), oldPerson);
                continue;
            }
            newPersonSet.add(batchUid);
        }
        Results results = super.save(PersonPersisterDbMap.MAP, objList, strSessionId);
        HashSet<String> errorUsers = new HashSet<String>();
        if (results.getErrorCount() > 0) {
            for (Results.Error e : results.getList()) {
                errorUsers.add(((Person)e.getObject()).getBatchUid());
            }
        }
        try {
            UserDbLoaderEx userLoader = (UserDbLoaderEx)UserDbLoaderEx.Default.getInstance();
            for (Person p : objList) {
                this._userCache.flushByBatchId(p.getBatchUid());
                if (errorUsers.contains(p.getBatchUid())) continue;
                UserLifecycleEventManager eventManager = (UserLifecycleEventManager)UserLifecycleEventManager.Factory.getInstance();
                if (newPersonSet.contains(p.getBatchUid())) {
                    eventManager.handleUserCreated(p.getId());
                    continue;
                }
                Person oldPerson = (Person)oldPersonMap.get(p.getId());
                if (p.getRecStatus() == IAdminObject.RecStatus.DELETE) {
                    eventManager.handleUserDeleted(oldPerson.getId());
                    continue;
                }
                IAdminObject.RowStatus oldRowStatus = oldPerson.getRowStatus();
                oldPerson.getBbAttributes().removeBbAttribute("RowStatus");
                oldPerson.getBbAttributes().setInteger("RowStatus", ConversionUtility.rowStatusToInt(oldRowStatus));
                User modifiedUser = userLoader.loadByIdIgnoreRowStatus(p.getId());
                eventManager.handleUserModified((User)oldPerson, modifiedUser);
            }
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().log("Error generating user events for snapshot import", (Throwable)e, LogService.Verbosity.ERROR);
        }
        return results;
    }

    @Override
    public Results remove(List<Person> objList) throws PersistenceException {
        HashMap<String, Id> personIds = new HashMap<String, Id>();
        HashSet<String> errorUsers = new HashSet<String>();
        for (Person objToRemove : objList) {
            try {
                personIds.put(objToRemove.getBatchUid(), this.getPersonId(objToRemove));
            }
            catch (PersistenceException e) {
                errorUsers.add(objToRemove.getBatchUid());
            }
        }
        Results results = super.remove(PersonDeleteDbMap.MAP, objList);
        if (results.getErrorCount() > 0) {
            for (Results.Error e : results.getList()) {
                errorUsers.add(((Person)e.getObject()).getBatchUid());
            }
        }
        for (Person p : objList) {
            this._userCache.flushByBatchId(p.getBatchUid());
            if (errorUsers.contains(p.getBatchUid())) continue;
            Id personId = (Id)personIds.get(p.getBatchUid());
            ((UserLifecycleEventManager)UserLifecycleEventManager.Factory.getInstance()).handleUserDeleted(personId);
        }
        return results;
    }

    @Override
    public void save(Person objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        Person oldObj = this.loadOldObject(objToSave);
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(PersonPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.postSaveHandler(objToSave, oldObj);
    }

    @Override
    public void save(Person objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        Person oldObj = this.loadOldObject(objToSave);
        super.save(PersonPersisterDbMap.MAP, objToSave, strSessionId);
        this.postSaveHandler(objToSave, oldObj);
    }

    @Override
    public void insert(Person objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(PersonInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.postSaveHandler(objToSave, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, CONSTRAINTS);
        }
    }

    @Override
    public void update(Person objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        Person oldObj = this.loadOldObject(objToSave);
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(PersonPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
        if (oldObj != null) {
            this._userCache.flushByBatchId(oldObj.getBatchUid());
            ((UserLifecycleEventManager)UserLifecycleEventManager.Factory.getInstance()).handleUserModified((User)oldObj, (User)objToSave);
        }
    }

    private void resolveReplacementBatchUid(Person objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    @Override
    public void remove(Person objToRemove) throws KeyNotFoundException, PersistenceException {
        Id personId = this.getPersonId(objToRemove);
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(PersonDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
        this._userCache.flushByBatchId(objToRemove.getBatchUid());
        ((UserLifecycleEventManager)UserLifecycleEventManager.Factory.getInstance()).handleUserDeleted(personId);
    }

    @Override
    public void changeKey(Person objToSave, String newKey) throws PersistenceException, ValidationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        this.update(objToSave);
    }

    private void resolveBatchUid(Person objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        PersonDbLoader loader = (PersonDbLoader)this._pm.getLoader("PersonLoader");
        Person obj = new Person();
        obj.setId(objInput.getId());
        BbList<Person> list = loader.load(obj);
        Person person = this.getSingleItem(list, obj);
        objInput.setBatchUid(person.getBatchUid());
    }

    private void resolveBatchUid(List<Person> list) throws PersistenceException {
        for (Person obj : list) {
            this.resolveBatchUid(obj);
        }
    }

    private Id getPersonId(Person objToRemove) throws PersistenceException, KeyNotFoundException {
        Id personId = objToRemove.getId();
        if (null == personId || !this._pm.isValidId(personId)) {
            PersonDbLoader loader = (PersonDbLoader)this._pm.getLoader("PersonLoader");
            Person oldPerson = loader.load(objToRemove.getBatchUid());
            personId = oldPerson.getId();
        }
        return personId;
    }

    private Person loadOldObject(Person objToSave) throws PersistenceException, KeyNotFoundException {
        if (!this._pm.isValidId(objToSave.getId())) {
            return null;
        }
        PersonDbLoader loader = (PersonDbLoader)this._pm.getLoader("PersonLoader");
        return loader.load(objToSave.getBatchUid());
    }

    private void postSaveHandler(Person objToSave, Person oldObj) {
        UserLifecycleEventManager eventManager = (UserLifecycleEventManager)UserLifecycleEventManager.Factory.getInstance();
        if (oldObj == null) {
            eventManager.handleUserCreated(objToSave.getId());
        } else {
            this._userCache.flushByBatchId(oldObj.getBatchUid());
            eventManager.handleUserModified((User)oldObj, (User)objToSave);
        }
    }
}

