/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.persist.user.PersonPersister;
import blackboard.admin.persist.user.impl.PersonRemoteLoader;
import blackboard.admin.persist.user.impl.soap.ClientUtility;
import blackboard.admin.snapshot.persist.Results;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.soap.ServerResponse;
import blackboard.util.ObjectSerializer;
import java.util.ArrayList;
import java.util.List;

public class PersonRemotePersister
extends AdminPersister
implements PersonPersister {
    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid);
        ServerResponse response = this.executeSoapCall(req);
        return (String)response.getResults();
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, sessionId);
        this.executeSoapCall(req);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.closeSession(strSessionId);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        try {
            this.save((Person)obj, strSessionId);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public Results save(List<Person> objList, String strSessionId) throws PersistenceException {
        PersonRemoteLoader loader = (PersonRemoteLoader)this._pm.getLoader("PersonLoader");
        for (Person p : objList) {
            if (p.getBbAttributes().getBbAttribute("Password").getIsDirty()) continue;
            try {
                Person oldPerson = loader.load(p.getBatchUid());
                p.setPassword(oldPerson.getPassword());
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logDebug("This is a new user: " + p.getBatchUid());
            }
        }
        ClientUtility req = new ClientUtility();
        req.save(objList, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        return this.resolveInternalId(objList, response, "person.id.list");
    }

    @Override
    public Results remove(List<Person> objList) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objList);
        ServerResponse response = this.executeSoapCall(req);
        return (Results)ObjectSerializer.deSerializeObject((String)((String)response.getResults()));
    }

    @Override
    public void save(Person objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    @Override
    public void save(Person objToSave, String strSessionId) throws PersistenceException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        ArrayList<Person> bList = new ArrayList<Person>();
        bList.add(objToSave);
        this.resolveInternalId(bList, response, "person.id.list");
    }

    @Override
    public void insert(Person objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.insert(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    @Override
    public void update(Person objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.update(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    @Override
    public void remove(Person objToRemove) throws KeyNotFoundException, PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objToRemove);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void changeKey(Person objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        this.update(objToSave);
    }
}

