/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl.soap;

import blackboard.admin.data.user.Person;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.persist.user.PersonLoader;
import blackboard.admin.persist.user.PersonPersister;
import blackboard.admin.persist.user.impl.soap.ClientUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.PersistenceRuntimeException;
import blackboard.persist.Persister;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "person.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        List<Person> list = ServerUtility.unMarshallObjects(obj);
        Iterator<Person> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            Person tmp = iter.next();
            p.insert(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        List<Person> list = ServerUtility.unMarshallObjects(obj);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (Person tmp : list) {
            p.update(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        List<Person> list = ServerUtility.unMarshallObjects(obj);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (Person tmp : list) {
            p.save(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String convert(String obj) throws PersistenceException, ValidationException {
        throw new PersistenceRuntimeException("No longer supported.");
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<Person> list = ServerUtility.unMarshallObjects(props, obj);
        Results results = p.save(list, session);
        Iterator<Person> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            Person tmp = iter.next();
            if (Id.isValidPkId((Id)tmp.getId())) {
                aList.add(tmp.getId().toExternalString());
                continue;
            }
            aList.add("");
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        List<Person> list = ServerUtility.unMarshallObjects(obj);
        Person person = list.get(0);
        p.remove(person);
    }

    public static String removeList(String obj) throws PersistenceException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        List<Person> list = ServerUtility.unMarshallObjects(obj);
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid) throws PersistenceException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        return p.createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        p.createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId) throws PersistenceException {
        PersonPersister p = (PersonPersister)ServerUtility.getPersister();
        p.closeSession(strSessionId);
    }

    public static String load(String batchUid) throws PersistenceException, KeyNotFoundException {
        PersonLoader l = (PersonLoader)ServerUtility.getLoader();
        Person person = l.load(batchUid);
        return ClientUtility.convertToString(person);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        PersonLoader l = (PersonLoader)ServerUtility.getLoader();
        List<Person> list = ServerUtility.unMarshallObjects(template);
        if (list.size() == 0) {
            return "";
        }
        list = l.load(list.get(0));
        return ClientUtility.convertToString(list);
    }

    private static Persister getPersister() throws PersistenceException {
        return PersonPersister.Default.getInstance();
    }

    private static Loader getLoader() throws PersistenceException {
        return PersonLoader.Default.getInstance();
    }

    public static List<Person> unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }

    public static List<Person> unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }
}

