/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl.soap.observer;

import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.admin.persist.user.ObserverAssociationXmlPersister;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.data.BbObject;
import blackboard.persist.PersistenceException;
import blackboard.util.ObjectSerializer;
import blackboard.xml.XmlUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientUtility
implements IClientUtility {
    private static final String SOAP_URN = "ObserverAssociationServerUtility";
    private static final String SAVE = "save";
    private static final String INSERT = "insert";
    private static final String UPDATE = "update";
    private static final String REMOVE = "remove";
    private static final String REMOVE_LIST = "removeList";
    private static final String CREATE_SESSION = "createSession";
    private static final String CLOSE_SESSION = "closeSession";
    private static final String LOAD = "load";
    private static final String LOAD_BY_TEMPLATE = "loadByTemplate";
    private String _sMethod;
    private final Vector<String> _vArgs = new Vector();

    public String getObjectNameSpace() {
        return SOAP_URN;
    }

    public String getMethodName() {
        return this._sMethod;
    }

    public Vector<String> getArguments() {
        return this._vArgs;
    }

    public void createSession(String dataSourceBatchUid) {
        this._sMethod = CREATE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
    }

    public void createSession(String dataSourceBatchUid, String session) {
        this._sMethod = CREATE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        this._vArgs.add(session);
    }

    public void closeSession(String strSessionId) {
        this._sMethod = CLOSE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(strSessionId);
    }

    public void load(String obsBatchUid, String usrBatchUid) {
        this._sMethod = LOAD;
        this._vArgs.removeAllElements();
        this._vArgs.add(obsBatchUid);
        this._vArgs.add(usrBatchUid);
    }

    public void load(ObserverAssociation template) throws PersistenceException {
        this._sMethod = LOAD_BY_TEMPLATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((BbObject)template));
    }

    public void save(List<ObserverAssociation> objList, String strSessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objList));
        this._vArgs.add(strSessionId);
        this._vArgs.add(ObjectSerializer.serializeObject((Object)Authority.getSettings()));
    }

    public void remove(List<ObserverAssociation> objList) throws PersistenceException {
        this._sMethod = REMOVE_LIST;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objList));
    }

    public void save(ObserverAssociation objToSave) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((BbObject)objToSave));
    }

    public void save(ObserverAssociation objToSave, String strSessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((BbObject)objToSave));
        this._vArgs.add(strSessionId);
    }

    public void insert(ObserverAssociation objToSave) throws PersistenceException {
        this._sMethod = INSERT;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((BbObject)objToSave));
    }

    public void update(ObserverAssociation objToSave) throws PersistenceException {
        this._sMethod = UPDATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((BbObject)objToSave));
    }

    public void remove(ObserverAssociation objToRemove) throws PersistenceException {
        this._sMethod = REMOVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((BbObject)objToRemove));
    }

    protected static String convertToString(BbObject obj) throws PersistenceException {
        Document doc;
        try {
            doc = XmlUtil.buildDocument();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        Element element = null;
        ObserverAssociationXmlPersister persister = ObserverAssociationXmlPersister.Default.getInstance();
        element = persister.persist((ObserverAssociation)obj, doc);
        doc.appendChild(element);
        String tmp = null;
        try {
            tmp = XmlUtil.createEncodedStringFromDoc((Document)doc, (boolean)false, (String)"UTF-8");
        }
        catch (IOException io) {
            throw new PersistenceException((Throwable)io);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        return tmp;
    }

    protected static String convertToString(List<ObserverAssociation> list) throws PersistenceException {
        StringBuilder sb = new StringBuilder();
        Iterator<ObserverAssociation> iter = list.iterator();
        sb.append("<enterprise>");
        while (iter.hasNext()) {
            sb.append(ClientUtility.convertToString((BbObject)iter.next()));
        }
        sb.append("</enterprise>");
        return sb.toString();
    }
}

