/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.authority;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.CourseStandardSubDocument;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Membership;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.EnrollmentPersister;
import blackboard.admin.persist.course.OrganizationMembershipPersister;
import blackboard.admin.persist.course.OrganizationPersister;
import blackboard.admin.persist.course.StaffAssignmentPersister;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.AuthorityLogger;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.admin.snapshot.config.OverriddenSnapshotSettingsHelper;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.admin.snapshot.serialize.IParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbEnum;
import blackboard.base.InitializationException;
import blackboard.data.BbObject;
import blackboard.data.IBbObject;
import blackboard.data.ValidationException;
import blackboard.db.BbDatabase;
import blackboard.db.ConstraintViolationException;
import blackboard.db.DbTypeFactory;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.StatusCode;
import blackboard.platform.contentsystem.manager.DocumentManagerEx;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.platform.persistence.PersistenceServiceFactory;
import blackboard.util.CollectionUtils;
import blackboard.util.StringUtil;
import blackboard.util.ThreadContextManager;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public abstract class Authority {
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final ThreadContextManager _threadContext = new ThreadContextManager(true);
    protected AuthorityLogger _logger;
    protected SnapshotPersister<?> _activePersister;
    protected List<IAdminObject> _adminObjects;
    protected Reader _reader;
    protected IParser _parser;
    protected String _sessionId;
    protected long _start;
    private final Set<EntityType> _initializedPersisters = new HashSet<EntityType>();
    private final ConfigurationManager _config;
    private final Operation _operation;
    private DataSource _dataSource;
    private DataSource _membershipDataSource;
    private StatusCode _statusCode;
    private Set<String> _enrollmentCourseIds = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Authority(Properties settings, SnapshotPersister<?> activePersister, IParser parser, Reader reader, Writer logger, Operation operation) throws InitializationException {
        this(settings, activePersister, parser, reader, operation, logger);
        String dataSourceKey = null;
        try {
            DataSourceLoader loader = DataSourceLoader.Default.getInstance();
            dataSourceKey = this._config.getSetting("data.source.key");
            if (dataSourceKey != null && dataSourceKey.length() > 0) {
                this._dataSource = loader.loadByBatchUid(dataSourceKey);
            }
            if ((dataSourceKey = this._config.getSetting("membership.datasource.key", "")) != null && dataSourceKey.length() > 0) {
                this._membershipDataSource = loader.loadByBatchUid(dataSourceKey);
            }
        }
        catch (KeyNotFoundException e) {
            this._statusCode = StatusCode.ABORTING;
            throw new InitializationException(this._config.getMessage("nonexistent.datasource.msg", dataSourceKey), (Throwable)e);
        }
        catch (Exception e) {
            if (operation != Operation.CLONE) {
                this._statusCode = StatusCode.ABORTING;
                throw new InitializationException(this._config.getMessage("controller.init.failure", new String[0]), (Throwable)e);
            }
            try {
                DataSourceLoader loader = DataSourceLoader.Default.getInstance();
                this._dataSource = loader.loadByBatchUid("SYSTEM");
            }
            catch (Exception nest) {
                this._statusCode = StatusCode.ABORTING;
                throw new InitializationException(this._config.getMessage("controller.init.failure", new String[0]), (Throwable)nest);
            }
        }
        finally {
            if (this._statusCode != StatusCode.ABORTING) {
                try {
                    this._sessionId = DataSourcePersister.Default.getInstance().beginSnapshotSession();
                }
                catch (PersistenceException e) {
                    this._statusCode = StatusCode.ABORTING;
                    throw new InitializationException(this._config.getMessage("controller.init.failure", new String[0]), (Throwable)e);
                }
            }
        }
        _threadContext.attachThreadContext((Object)settings);
    }

    public AuthorityLogger getLogger() {
        return this._logger;
    }

    public static Properties getSettings() {
        Properties props = (Properties)_threadContext.getThreadContext();
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    protected Authority(Properties settings, SnapshotPersister<?> activePersister, IParser parser, Reader reader, Operation operation) {
        this(settings, activePersister, parser, reader, operation, null);
    }

    protected Authority(Properties settings, SnapshotPersister<?> activePersister, IParser parser, Reader reader, Operation operation, Writer logger) {
        if (null != BbDatabase.getDefaultInstance()) {
            Preconditions.checkState((DbTypeFactory.getInstanceByTypeName((String)"pgsql") != BbDatabase.getDefaultInstance().getType() ? 1 : 0) != 0, (Object)"Snapshot is not supported on PostgreSQL.");
        }
        if (settings == null) {
            settings = new Properties();
        }
        settings.putAll((Map<?, ?>)System.getProperties());
        this._statusCode = StatusCode.INITIALIZING;
        this._reader = reader;
        this._config = ConfigurationManager.getInstance(settings);
        this._start = System.currentTimeMillis();
        this._activePersister = activePersister;
        this._parser = parser;
        this._adminObjects = new ArrayList<IAdminObject>();
        this._operation = operation;
        this._logger = new AuthorityLogger(this._config, logger);
    }

    public ConfigurationManager getConfigurationManager() {
        return this._config;
    }

    public Operation getOperation() {
        return this._operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SnapshotException, PersistenceException {
        this._statusCode = StatusCode.OPERATING;
        try {
            if (this._activePersister != null && this.getOperation() == Operation.SNAPSHOT) {
                this._logger.stdOutWriteMessage(this._config.getMessage("snapshot.session.initialization.start", new String[0]));
                this.initPersistence(this._activePersister);
                this._logger.stdOutWriteMessage(this._config.getMessage("snapshot.session.initialization.end", new String[0]));
            }
            this._parser.init(this, this._reader);
            this._parser.execute();
        }
        finally {
            this.releaseResources();
        }
        this._statusCode = StatusCode.EXITED;
    }

    public void setStatus(StatusCode statusCode) {
        this._statusCode = statusCode;
    }

    public StatusCode getStatus() {
        return this._statusCode;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void releaseResources() {
        if (this.getOperation() != Operation.SNAPSHOT) {
            this.endSnapshotSession();
            return;
        }
        this._logger.stdOutWriteMessage(this._config.getMessage("snapshot.session.finalization.start", new String[0]));
        boolean completedNormally = true;
        for (EntityType entityType : this._initializedPersisters) {
            completedNormally &= this.closeSession(entityType);
        }
        if (completedNormally) {
            this.endSnapshotSession();
        }
        this._logger.stdOutWriteMessage(this._config.getMessage("snapshot.session.finalization.end", new String[0]));
    }

    private boolean closeSession(EntityType entityType) {
        try {
            this.closeSession(this.getPersister(entityType));
        }
        catch (Exception e) {
            String msg = this.getConfigurationManager().getMessage("snapshot.persister.stop", new String[0]);
            this._logger.logWarning(MessageFormat.format(msg, this.getSessionId()), e);
            return false;
        }
        return true;
    }

    private void closeSession(SnapshotPersister<?> persister) {
        try {
            persister.closeSession(this.getSessionId());
        }
        catch (Exception e) {
            String msg = this.getConfigurationManager().getMessage("snapshot.persister.stop", new String[0]);
            this._logger.logWarning(MessageFormat.format(msg, this.getSessionId()), e);
        }
    }

    private void endSnapshotSession() {
        try {
            DataSourcePersister.Default.getInstance().endSnapshotSession(this._sessionId);
        }
        catch (PersistenceException e) {
            this._logger.logWarning(this._config.getMessage("snapshot.session.finalization.end", new String[0]), (Exception)((Object)e));
        }
    }

    protected Results delegatePersistence(List<? extends IAdminObject> list) throws PersistenceException {
        SnapshotPersister<?> persister = this.getActivePersister(list);
        Results results = null;
        if (this._operation == Operation.SNAPSHOT || this._operation == Operation.MANUAL || this._operation == Operation.CLONE) {
            results = this.isActiveCoursePersister(persister) ? Authority.delegateAdminCoursePersistence(list, persister, this.getSessionId(), this._membershipDataSource, true) : persister.save(list, this.getSessionId());
        } else if (this._operation == Operation.REMOVE) {
            if (this.isActiveCoursePersister(persister) && this.shouldRemoveAllCourseFiles()) {
                this.deleteCourseFiles(list);
            }
            results = persister.remove(list);
        }
        return results;
    }

    private void deleteCourseFiles(List<? extends IAdminObject> list) {
        DocumentManagerEx docMgrEx = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
        String[] batchUids = this.toBatchUids(list);
        try {
            docMgrEx.removeCourseContent(batchUids);
        }
        catch (Exception e) {
            this._logger.logWarning(this._config.getMessage("snapshot.delete.coursefiles.failed", new String[0]), e);
        }
    }

    private String[] toBatchUids(List<? extends IAdminObject> list) {
        ArrayList<String> results = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (IAdminObject iAdminObject : list) {
                if (!(iAdminObject instanceof AdminCourse)) continue;
                results.add(((AdminCourse)iAdminObject).getBatchUid());
            }
        }
        return results.toArray(new String[results.size()]);
    }

    private boolean shouldRemoveAllCourseFiles() {
        boolean removeContent = ConversionUtility.getBoolean(this.getConfigurationManager().getSetting("course.delete.content", ConfigurationManager.GeneralSetting.DeleteContent.getDefaultValue()));
        return removeContent;
    }

    private boolean isActiveCoursePersister(SnapshotPersister<?> persister) {
        return persister instanceof CourseSitePersister || persister instanceof OrganizationPersister;
    }

    private boolean isEnrollmentPersister(SnapshotPersister<?> persister) {
        return persister instanceof EnrollmentPersister || persister instanceof OrganizationMembershipPersister || persister instanceof StaffAssignmentPersister;
    }

    public static Results delegateAdminCoursePersistence(List objects, SnapshotPersister<?> persist, String session, DataSource membershipDataSource, boolean doClone) throws PersistenceException {
        List<AdminCourse> cloneList = null;
        if (doClone) {
            cloneList = Authority.cloneCheck(objects);
        }
        Results results = persist.save(objects, session);
        if (cloneList != null && !cloneList.isEmpty()) {
            Results cloneResults = Authority.doClone(cloneList, membershipDataSource);
            ConversionUtility.mergeResults(cloneResults, results);
        }
        return results;
    }

    private static List<AdminCourse> cloneCheck(List<AdminCourse> adminCourses) throws PersistenceException {
        HashMap<String, AdminCourse> coursesToClone = new HashMap<String, AdminCourse>();
        for (AdminCourse course : adminCourses) {
            if (coursesToClone.containsKey(course.getBatchUid()) || !Authority._cloneCheck(course)) continue;
            coursesToClone.put(course.getBatchUid(), course);
        }
        return new ArrayList<AdminCourse>(coursesToClone.values());
    }

    private static Results doClone(List<AdminCourse> adminCourses, DataSource membershipDataSource) throws PersistenceException {
        CloneConfig cfg = ConfigurationManager.getCloneConfiguration(Authority.getSettings());
        Properties properties = Authority.getSettings();
        String dataSourceKey = properties.getProperty("membership.datasource.key", "");
        if (membershipDataSource == null && dataSourceKey.length() > 0) {
            DataSourceLoader loader = DataSourceLoader.Default.getInstance();
            membershipDataSource = loader.loadByBatchUid(dataSourceKey);
        }
        if (membershipDataSource != null) {
            cfg.setMembershipDataSourceId(membershipDataSource.getId());
        }
        String hostName = properties.getProperty("host.name");
        cfg.setHostName(hostName);
        BbResourceBundle bundle = BundleManagerFactory.getInstance().getBundle("snapshot");
        String sourceName = bundle.getString("snapshot.copy.into.title");
        cfg.setSourceName(sourceName);
        cfg.setIsCommandLineRequest(true);
        RemoteResults results = new RemoteResults();
        for (AdminCourse course : adminCourses) {
            try {
                Authority._doClone(course, cfg);
            }
            catch (PersistenceException e) {
                results.addError((BbObject)course, (Exception)((Object)e));
            }
        }
        return results;
    }

    private static void _doClone(AdminCourse course, CloneConfig config) throws PersistenceException {
        CourseSitePersister persister = CourseSitePersister.Default.getInstance();
        OverriddenSnapshotSettingsHelper overiddenSettingsHelper = new OverriddenSnapshotSettingsHelper(config);
        boolean hasOverriddenSettings = overiddenSettingsHelper.hasOverriddenConfiguration(course.getBbAttributes());
        try {
            if (hasOverriddenSettings) {
                overiddenSettingsHelper.updateCloneConfigWithOverriddenSettings(course.getBbAttributes());
            }
            persister.clone(course.getTemplateBatchUid(), course.getBatchUid(), config);
        }
        catch (ValidationException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new PersistenceException((Throwable)e);
        }
        finally {
            if (hasOverriddenSettings) {
                overiddenSettingsHelper.restoreOriginalSnapshotSettings();
            }
        }
    }

    private static boolean _cloneCheck(AdminCourse course) throws PersistenceException {
        boolean exists;
        block3: {
            String templateBatchUid = course.getTemplateBatchUid();
            if (StringUtil.isEmpty((String)templateBatchUid)) {
                return false;
            }
            exists = false;
            CourseSiteLoader loader = CourseSiteLoader.Default.getInstance();
            try {
                loader.load(course.getBatchUid());
                exists = true;
            }
            catch (PersistenceException e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)writer, true));
                String msg = writer.getBuffer().toString();
                if (msg.indexOf("KeyNotFoundException") != -1) break block3;
                throw e;
            }
        }
        return !exists || course.getBbAttributes().getBbAttribute("TemplateBatchUid").getIsDirty();
    }

    protected SnapshotPersister<?> getActivePersister(List<? extends IAdminObject> list) throws PersistenceException {
        EntityType entityType = EntityType.fromAdminObject(list.get(0));
        SnapshotPersister<?> persister = this.getPersister(entityType);
        this.initPersistence(persister);
        return persister;
    }

    protected SnapshotPersister<?> getPersister(EntityType entityType) throws PersistenceException {
        return entityType.getPersister();
    }

    private EntityType getPersisterBit(SnapshotPersister<?> persister) throws PersistenceException {
        return EntityType.fromPersister(persister);
    }

    private Collection<List<IAdminObject>> splitByType(List<? extends IAdminObject> adminObjects) {
        TreeMap<EntityType, ArrayList<IAdminObject>> output = new TreeMap<EntityType, ArrayList<IAdminObject>>();
        for (IAdminObject iAdminObject : adminObjects) {
            EntityType entityType = EntityType.fromAdminObject(iAdminObject);
            ArrayList<IAdminObject> list = (ArrayList<IAdminObject>)output.get((Object)entityType);
            if (list == null) {
                list = new ArrayList<IAdminObject>();
                output.put(entityType, list);
            }
            list.add(iAdminObject);
        }
        return output.values();
    }

    private void initPersistence(SnapshotPersister<?> persister) throws PersistenceException {
        if (this.getOperation() != Operation.SNAPSHOT) {
            return;
        }
        EntityType entityType = this.getPersisterBit(persister);
        if (this._initializedPersisters.contains((Object)entityType)) {
            return;
        }
        persister.createSession(this._dataSource.getBatchUid(), this._sessionId);
        this._initializedPersisters.add(entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SnapshotException {
        if (this._adminObjects.isEmpty()) {
            return;
        }
        Results results = null;
        try {
            Collection<List<IAdminObject>> adminObjectsList = this.splitByType(this._adminObjects);
            for (List<IAdminObject> list : adminObjectsList) {
                results = this.delegatePersistence(list);
                this._logger.logErrorsFromCommit(list, results);
            }
        }
        catch (PersistenceException e) {
            for (IBbObject iBbObject : this._adminObjects) {
                this._logger.logError(iBbObject, iBbObject.getBbAttributes().getSafeString("embed"), (Exception)((Object)e));
            }
        }
        finally {
            try {
                SnapshotPersister<?> persister = this.getActivePersister(this._adminObjects);
                if (!CollectionUtils.isEmpty(this._adminObjects) && (this._operation == Operation.SNAPSHOT || this._operation == Operation.MANUAL || this._operation == Operation.CLONE) && this.isEnrollmentPersister(persister)) {
                    this._enrollmentCourseIds.addAll(Membership.getCourseIdsSet(this._adminObjects));
                }
            }
            catch (Exception e) {
                throw new SnapshotException("Error adding course ids", e);
            }
            this._adminObjects.clear();
        }
    }

    public void queue(IAdminObject adminObject) {
        this._adminObjects.add(adminObject);
    }

    public boolean checkLicense() {
        return Boolean.TRUE;
    }

    public static enum EntityType {
        Course(CourseSite.class, "CourseSitePersister"),
        CourseCategory(CourseCategory.class, "CourseCategoryPersister"),
        CourseCategoryMember(CourseCategoryMembership.class, "CourseCategoryMembershipPersister"),
        CourseCourse(AdminCourseCourse.class, "AdminCourseCoursePersister"),
        CourseStandardSubDoc(CourseStandardSubDocument.class, "CourseStandardSubDocumentPersister"),
        Enrollment(Enrollment.class, "EnrollmentPersister"),
        ObserverAssociation(ObserverAssociation.class, "ObserverAssociationPersister"),
        Organization(Organization.class, "OrganizationPersister"),
        OrganizationCategory(OrganizationCategory.class, "OrganizationCategoryPersister"),
        OrganizationCategoryMember(OrganizationCategoryMembership.class, "OrganizationCategoryMembershipPersister"),
        OrganizationMember(OrganizationMembership.class, "OrganizationMembershipPersister"),
        Person(Person.class, "PersonPersister"),
        PortalRoleMember(PortalRoleMembership.class, "PortalRoleMembershipPersister"),
        Staff(StaffAssignment.class, "StaffAssignmentPersister");

        private final Class<? extends IAdminObject> _entityClass;
        private final String _persisterType;

        private EntityType(Class<? extends IAdminObject> entityClazz, String persisterType) {
            this._entityClass = entityClazz;
            this._persisterType = persisterType;
        }

        public SnapshotPersister<?> getPersister() throws PersistenceException {
            return (SnapshotPersister)PersistenceServiceFactory.getInstance().getDbPersistenceManager().getPersister(this._persisterType);
        }

        public static EntityType fromAdminObject(IAdminObject adminObject) {
            for (EntityType entityType : EntityType.values()) {
                if (!entityType._entityClass.isAssignableFrom(adminObject.getClass())) continue;
                return entityType;
            }
            throw new RuntimeException("Unknown entity " + adminObject);
        }

        public static EntityType fromPersister(SnapshotPersister<?> persister) throws PersistenceException {
            for (EntityType entityType : EntityType.values()) {
                SnapshotPersister<?> entityPersister = entityType.getPersister();
                if (!entityPersister.getClass().isAssignableFrom(persister.getClass())) continue;
                return entityType;
            }
            throw new PersistenceException("Unknown persister " + persister.getClass());
        }
    }

    public static final class Operation
    extends BbEnum {
        public static final Operation SNAPSHOT = new Operation("SNAPSHOT");
        public static final Operation MANUAL = new Operation("MANUAL");
        public static final Operation REMOVE = new Operation("REMOVE");
        public static final Operation CLONE = new Operation("CLONE");
        static final long serialVersionUID = 1L;

        private Operation(String enumFieldName) {
            super(enumFieldName);
        }
    }
}

