/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.authority;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.admin.snapshot.config.MsgConstants;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.util.AdminTextUtil;
import blackboard.data.IBbObject;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.BbSystemWrapper;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class AuthorityLogger {
    protected long _count;
    protected long _errorCount;
    protected long _successCount;
    protected long _warningCount;
    private final long _maxErrorCount;
    private final ConfigurationManager _config;
    private final LogService _logService;
    private final Writer _logger;
    private String _previousMessage = "";

    public AuthorityLogger(ConfigurationManager config, Writer logger) {
        this._config = config;
        this._logger = logger;
        this._logService = LogServiceFactory.getInstance();
        this._maxErrorCount = this._config.getNumericSetting("max.error.count");
    }

    public void logWarning(String message) {
        ++this._warningCount;
        if (this._logService.getVerbosityLevel().getLevelAsInt() < LogService.Verbosity.WARNING.getLevelAsInt()) {
            return;
        }
        if (this._config.getSetting("log.stdout").equalsIgnoreCase("y")) {
            this.stdOutLogWarning(message, null);
        }
        this._logService.logWarning(this._config.getMessage("warning.log.header", new String[0]) + ": " + message);
    }

    public void logWarning(String message, Exception e) {
        ++this._warningCount;
        if (this._logService.getVerbosityLevel().getLevelAsInt() < LogService.Verbosity.WARNING.getLevelAsInt()) {
            return;
        }
        if (this._config.getSetting("log.stdout").equalsIgnoreCase("y")) {
            this.stdOutLogWarning(message, e);
        }
        this._logService.logWarning(this._config.getMessage("warning.log.header", new String[0]), (Throwable)e);
    }

    public void logError(IBbObject obj, String msg, List<Exception> e) throws SnapshotException {
        this.logError(msg, e);
    }

    public void logError(IBbObject obj, String msg, Exception e) throws SnapshotException {
        this.logError(msg, e);
    }

    public void logError(String message, Exception e) throws SnapshotException {
        this.logError(message, Arrays.asList(e));
    }

    public void logError(String message, List<Exception> exceptions) throws SnapshotException {
        this.incrementErrorCount(1);
        StringBuilder sb = new StringBuilder(message);
        sb.append(this._config.getSetting("error.delimeter"));
        if (exceptions != null) {
            for (Exception e : exceptions) {
                sb.append(e.getMessage());
                sb.append(" ");
            }
        }
        try {
            sb.append(MsgConstants.MSG_CRLF);
            this.writeToErrorStream(sb.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._logService.getVerbosityLevel().getLevelAsInt() < LogService.Verbosity.ERROR.getLevelAsInt()) {
            return;
        }
        if (this._config.getSetting("log.stdout").equalsIgnoreCase("y")) {
            String status = this._config.getMessage("entity.processing.failure", new String[0]);
            this.stdOutWriteMessage(status + ": " + message + MsgConstants.MSG_CRLF);
        }
        if (exceptions != null) {
            for (Exception e : exceptions) {
                this._logService.logError(message, (Throwable)e);
            }
        }
    }

    public void logErrorsFromCommit(List<IAdminObject> adminObjects, Results results) throws SnapshotException {
        this.incrementSuccessCount(adminObjects.size() - results.getErrorCount());
        if (results.getErrorCount() == 0) {
            return;
        }
        for (Results.Error error : results.getList()) {
            String embeddedText = error.getEmbeddedText();
            this.logError((IBbObject)error.getObject(), embeddedText, error.getAllExceptions());
        }
    }

    public void writeToErrorStream(String message) {
        if (this._logger == null) {
            return;
        }
        try {
            this._logger.write(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stdOutWriteMessage(String message) {
        AdminTextUtil.flushMessageBuffer(this._previousMessage, message);
        this._previousMessage = message;
        BbSystemWrapper.print((String)message);
    }

    public void stdOutLogCount(boolean skipIncrement) {
        String val;
        if (!skipIncrement) {
            ++this._count;
        }
        if (!((val = String.valueOf(this._count)).equals("1") || val.endsWith("0") || skipIncrement)) {
            return;
        }
        this.stdOutWriteMessage(val + " " + this._config.getMessage("status.entity.processed", new String[0]));
    }

    private void stdOutLogWarning(String message, Exception e) {
        if (e != null) {
            message = message + " : " + e.getMessage();
        }
        String status = this._config.getMessage("warning.report.msg", new String[0]);
        this.stdOutWriteMessage(status + " { " + message + " }" + MsgConstants.MSG_CRLF);
    }

    public void writeStdOutReport(String message) {
        String status = this._config.getMessage("status.report.msg", new String[0]);
        this.stdOutWriteMessage(status + " " + message + MsgConstants.MSG_CRLF);
        this._logService.logInfo(message);
    }

    public void incrementErrorCount(int errorCount) throws SnapshotException {
        this._errorCount += (long)errorCount;
        if (this.maxErrorExceeded()) {
            throw new SnapshotException(this._config.getMessage("parser.maxerr.exceeded", new String[0]));
        }
    }

    public boolean maxErrorExceeded() {
        return this._maxErrorCount >= 0L && this._errorCount > this._maxErrorCount;
    }

    public void incrementSuccessCount(int successCount) {
        this._successCount += (long)successCount;
    }
}

