/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.config;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.snapshot.config.ConfigConstants;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.course.CourseSettingCXHelper;
import blackboard.platform.cx.component.CxComponent;
import blackboard.platform.cx.component.CxComponentFactory;
import blackboard.platform.dataintegration.mapping.CourseCloneConfig;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.platform.soap.service.BbSoapClientServiceFactory;
import blackboard.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConfigurationManager
implements ConfigConstants {
    private static final String RESOURCE_BUNDLE = "snapshot";
    private static final String DEFAULT_STRING = "(=)";
    private static final String WIKI_CX_COMPONENT = "bb-wiki";
    private static final String RETENTION_CX_COMPONENT = "bb-retention";
    private Properties _settings = null;
    private BbResourceBundle _bundle = null;

    public static ConfigurationManager getInstance(Properties props) {
        return new ConfigurationManager(props);
    }

    public CloneConfig getConfiguration() {
        return ConfigurationManager.getCloneConfiguration(this._settings);
    }

    public static CloneConfig getCloneConfiguration(Properties props) {
        CloneConfig cfg = new CloneConfig();
        for (AreaSetting areaSetting : AreaSetting.values()) {
            if (!ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, areaSetting))) continue;
            cfg.includeArea(areaSetting.getArea());
        }
        if (cfg.isAreaIncluded(AreaSetting.Settings.getArea()) && ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, GeneralSetting.SettingsLimitedCopy))) {
            cfg.includeObject(CloneConfig.Area.SETTING, CourseSettingCXHelper.LIMITED_SETTINGS);
            List<IncludeSettingObject> settingsObjectIncludes = ConfigurationManager.getCourseSettingCXHelperValues();
            for (IncludeSettingObject setting : settingsObjectIncludes) {
                if (!ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, setting))) continue;
                cfg.includeObject(CloneConfig.Area.SETTING, setting.getSetting());
            }
        }
        if (ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, GeneralSetting.ExcludeDiscussionStarterPosts))) {
            cfg.includeObject(CloneConfig.Area.DISCUSSION_BOARD, "excludeStarterPosts");
        }
        for (Enum enum_ : CxComponentSetting.values()) {
            if (!ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, (SnapshotSetting)((Object)enum_)))) continue;
            cfg.includeCxComponent(((CxComponentSetting)enum_).getComponentHandle());
        }
        for (DynamicCxComponentSetting setting : ConfigurationManager.getDynamicCxComponentSettings()) {
            if (!ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, setting))) continue;
            cfg.includeCxComponent(setting.getComponentHandle());
        }
        if (ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, GeneralSetting.ReconcileCopy))) {
            cfg.setReconcileFlag(Boolean.TRUE);
        }
        cfg.setMaximumTransactionCount(XmlUtil.parseInteger((String)ConfigurationManager.getSettingValue(props, GeneralSetting.BatchSize)));
        cfg.setRawCsDir(ConfigurationManager.getSettingValue(props, GeneralSetting.ContentSystemPath));
        cfg.setCloneOptions(CourseCloneConfig.CloneOptions.handleToOption((String)ConfigurationManager.getSettingValue(props, GeneralSetting.ArchiveCSItems)));
        if (ConversionUtility.getBoolean(ConfigurationManager.getSettingValue(props, GeneralSetting.CourseExactCopy))) {
            cfg.includeArea(CloneConfig.Area.ALL);
            cfg.setCopyType(CloneConfig.CopyType.COPY_EXACT_COURSE);
        }
        return cfg;
    }

    public static Map<String, String> getAllCloneSettings() {
        HashMap<String, String> allSettings = new HashMap<String, String>();
        HashSet<Object> allSettingEnums = new HashSet<Object>();
        allSettingEnums.addAll(Arrays.asList(AreaSetting.values()));
        allSettingEnums.addAll(Arrays.asList(GeneralSetting.values()));
        allSettingEnums.addAll(Arrays.asList(CxComponentSetting.values()));
        allSettingEnums.addAll(ConfigurationManager.getCourseSettingCXHelperValues());
        allSettingEnums.addAll(ConfigurationManager.getDynamicCxComponentSettings());
        for (SnapshotSetting snapshotSetting : allSettingEnums) {
            allSettings.put(snapshotSetting.getKey(), snapshotSetting.getDefaultValue());
        }
        return allSettings;
    }

    private static List<IncludeSettingObject> getCourseSettingCXHelperValues() {
        ArrayList<IncludeSettingObject> result = new ArrayList<IncludeSettingObject>();
        List inclusions = CourseSettingCXHelper.getPossibleInclusions((boolean)false);
        for (CourseSettingCXHelper.DisplayVO setting : inclusions) {
            result.add(new IncludeSettingObject(setting.getSetting(), "Y"));
        }
        return result;
    }

    private static List<DynamicCxComponentSetting> getDynamicCxComponentSettings() {
        ArrayList<DynamicCxComponentSetting> result = new ArrayList<DynamicCxComponentSetting>();
        Collection components = CxComponentFactory.getConfigurableCxComponents();
        for (CxComponent component : components) {
            CxComponentSetting setting = CxComponentSetting.findByCxComponent(component);
            if (null != setting) continue;
            result.add(new DynamicCxComponentSetting(component.getComponentHandle(), "Y"));
        }
        return result;
    }

    private ConfigurationManager(Properties props) {
        this._settings = props == null || props.isEmpty() ? new Properties() : (Properties)props.clone();
        this._bundle = BundleManagerFactory.getInstance().getBundle(RESOURCE_BUNDLE);
    }

    public String getSetting(String key) {
        return this.getSetting(key, DEFAULT_STRING);
    }

    public String getSetting(String key, String defaultValue) {
        return this._settings.getProperty(key, defaultValue);
    }

    public int getNumericSetting(String key) {
        return Integer.parseInt(this._settings.getProperty(key, "-1"));
    }

    public void setSetting(String key, String value) {
        this._settings.setProperty(key, value);
    }

    public boolean isSOAPEnabled() {
        try {
            BbSoapClientServiceFactory.getInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getMessage(String key, String ... args) {
        return this._bundle.getString(key, args);
    }

    public static String getGlobalLocaleExceptionMessage(String arg) {
        BbResourceBundle bundle = BundleManagerFactory.getInstance().getBundle(RESOURCE_BUNDLE);
        return bundle.getString(arg);
    }

    public char getDelimiter() {
        return this._settings.getProperty("data.delimeter", " ").charAt(0);
    }

    public String getEscapeSequence() {
        return this._settings.getProperty("escape.character", "(!)");
    }

    public String getCSPath() {
        return this._settings.getProperty("cs.path", "(!)");
    }

    public String getArchiveCSItems() {
        return this._settings.getProperty("archive.cs.items");
    }

    private static String getSettingValue(Properties props, SnapshotSetting setting) {
        return props.getProperty(setting.getKey(), setting.getDefaultValue());
    }

    public static enum GeneralSetting implements SnapshotSetting
    {
        ArchiveCSItems("archive.cs.items", "1"),
        BatchSize("snapshot.batch.size", "0"),
        ContentSystemPath("cs.path", null),
        CourseExactCopy("course.exact.copy", "Y"),
        ReconcileCopy("reconcile", "N"),
        SettingsLimitedCopy("course.settings.limited.copy", "N"),
        DeleteContent("course.delete.content", "N"),
        ExcludeDiscussionStarterPosts("discussion.board.topics.exclude", "N");

        private final String _key;
        private final String _defaultValue;

        private GeneralSetting(String key, String defaultValue) {
            this._key = key;
            this._defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }
    }

    private static enum CxComponentSetting implements SnapshotSetting
    {
        Retention("bb-retention.copy", "Y", "bb-retention"),
        Wiki("bb-wiki.copy", "Y", "bb-wiki");

        private final String _key;
        private final String _defaultValue;
        private final String _componentHandle;

        private CxComponentSetting(String key, String defaultValue, String componentHandle) {
            this._key = key;
            this._defaultValue = defaultValue;
            this._componentHandle = componentHandle;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }

        public String getComponentHandle() {
            return this._componentHandle;
        }

        public static CxComponentSetting findByCxComponent(CxComponent component) {
            for (CxComponentSetting setting : CxComponentSetting.values()) {
                if (!setting.getComponentHandle().equals(component.getComponentHandle())) continue;
                return setting;
            }
            return null;
        }
    }

    private static enum AreaSetting implements SnapshotSetting
    {
        Alignments("course.alignments.copy", "Y", CloneConfig.Area.STD_ALIGNMENT),
        Announcement("announcements.copy", "Y", CloneConfig.Area.ANNOUNCEMENT),
        Assessment("assessment.copy", "Y", CloneConfig.Area.ASSESSMENT),
        AssessmentCartridge("assessment.cartridge.copy", "Y", CloneConfig.Area.ASSESSMENT_CARTRIDGE),
        AvailabilityRule("availability.rule.copy", "Y", CloneConfig.Area.AVAILABILITY_RULE),
        Blog("blog.copy", "Y", CloneConfig.Area.BLOG),
        Calendar("calendar.copy", "Y", CloneConfig.Area.CALENDAR),
        CategoryMembership("categories.copy", "Y", CloneConfig.Area.CATEGORY_MEMBERSHIP),
        ChatArchive("chat.archive.copy", "Y", CloneConfig.Area.CHAT_ARCHIVE),
        ChatSession("chat.session.copy", "Y", CloneConfig.Area.CHAT_SESSION),
        Content("course.content.copy", "Y", CloneConfig.Area.CONTENT),
        CourseCartridge("course.content.cartridge.copy", "Y", CloneConfig.Area.COURSE_CARTRIDGE),
        CourseStatistics("course.statistics.copy", "Y", CloneConfig.Area.COURSE_STATISTICS),
        DiscussionBoard("discussion.board.copy", "Y", CloneConfig.Area.DISCUSSION_BOARD),
        DiscussionBoardArchive("discussion.board.archive.copy", "Y", CloneConfig.Area.DISCUSSION_BOARD_ARCHIVE),
        DiscussionCartridge("discussion.board.cartridge.copy", "Y", CloneConfig.Area.DISCUSSION_CARTRIDGE),
        DropBox("drop.box.copy", "Y", CloneConfig.Area.DROP_BOX),
        Glossary("glossary.copy", "Y", CloneConfig.Area.GLOSSARY),
        Gradebook("gradebook.copy", "Y", CloneConfig.Area.GRADEBOOK),
        GradebookClear("gradebook.clear", "Y", CloneConfig.Area.GRADEBOOK_CLEAR),
        Grades("grades.copy", "Y", CloneConfig.Area.GRADES),
        Group("groups.copy", "Y", CloneConfig.Area.GROUP),
        Journal("journal.copy", "Y", CloneConfig.Area.JOURNAL),
        Membership("membership.copy", "Y", CloneConfig.Area.MEMBERSHIP),
        MembershipExact("membership.exact.copy", "Y", CloneConfig.Area.MEMBERSHIP_EXACT),
        Rubric("rubric.copy", "Y", CloneConfig.Area.RUBRIC),
        Settings("course.settings.copy", "Y", CloneConfig.Area.SETTING),
        StaffInformation("staff.information.copy", "Y", CloneConfig.Area.STAFF_INFORMATION),
        Task("tasks.copy", "Y", CloneConfig.Area.TASK);

        private final String _key;
        private final String _defaultValue;
        private final CloneConfig.Area _area;

        private AreaSetting(String key, String defaultValue, CloneConfig.Area area) {
            this._key = key;
            this._defaultValue = defaultValue;
            this._area = area;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }

        public CloneConfig.Area getArea() {
            return this._area;
        }
    }

    private static class DynamicCxComponentSetting
    implements SnapshotSetting {
        private final String _componentHandle;
        private final String _defaultValue;

        public DynamicCxComponentSetting(String componentHandle, String defaultValue) {
            this._componentHandle = componentHandle;
            this._defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return "cxcomponent." + this._componentHandle + ".copy";
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }

        public String getComponentHandle() {
            return this._componentHandle;
        }
    }

    private static class IncludeSettingObject
    implements SnapshotSetting {
        private final String _setting;
        private final String _defaultValue;

        public IncludeSettingObject(String setting, String defaultValue) {
            this._setting = setting;
            this._defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return "course.settings." + this.getSetting() + ".copy";
        }

        @Override
        public String getDefaultValue() {
            return this._defaultValue;
        }

        public String getSetting() {
            return this._setting;
        }
    }

    private static interface SnapshotSetting {
        public String getKey();

        public String getDefaultValue();
    }
}

