/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.config;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.snapshot.config.OverriddenSetting;
import blackboard.data.BbAttributes;
import blackboard.util.CollectionUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OverriddenSnapshotSettingsHelper {
    private CloneConfig _cloneConfig;
    private final Map<CloneConfig.Area, Set<String>> _originalConfigIncludedObjectsMap;

    public OverriddenSnapshotSettingsHelper(CloneConfig cloneConfig) {
        this._cloneConfig = cloneConfig;
        this._originalConfigIncludedObjectsMap = cloneConfig.getIncludeObjectMap();
    }

    public void updateCloneConfigWithOverriddenSettings(BbAttributes bbAttributes) {
        EnumMap<OverriddenSetting, Object> overriddenValuesLookup = OverriddenSettingLookup.getExistingOverriddenValuesMap(bbAttributes);
        if (overriddenValuesLookup != null && overriddenValuesLookup.size() > 0) {
            this.overrideConfigIncludedObjectsMap();
            this.overrideExcludeDiscussionStarterPostsSetting(overriddenValuesLookup);
            OverriddenSettingLookup.clearOverriddenValuesMap(bbAttributes);
        }
    }

    public static void saveOverriddenBooleanSetting(BbAttributes bbAttributes, OverriddenSetting overriddenConfigurationSetting, boolean value) {
        EnumMap<OverriddenSetting, Object> overriddenValuesMap = OverriddenSettingLookup.getOverriddenValuesMap(bbAttributes);
        overriddenValuesMap.put(overriddenConfigurationSetting, (Object)value);
    }

    public boolean hasOverriddenConfiguration(BbAttributes bbAttributes) {
        EnumMap<OverriddenSetting, Object> overriddenValuesMap = OverriddenSettingLookup.getExistingOverriddenValuesMap(bbAttributes);
        return overriddenValuesMap != null && overriddenValuesMap.size() > 0;
    }

    public void restoreOriginalSnapshotSettings() {
        this._cloneConfig.setIncludeObjectMap(this._originalConfigIncludedObjectsMap);
    }

    private void overrideExcludeDiscussionStarterPostsSetting(EnumMap<OverriddenSetting, Object> overriddenValuesMap) {
        Boolean excludeDiscussionStarterPosts = (Boolean)overriddenValuesMap.get((Object)OverriddenSetting.excludeDiscussionStarterPosts);
        if (excludeDiscussionStarterPosts != null) {
            if (Boolean.valueOf(excludeDiscussionStarterPosts).booleanValue()) {
                this.addSetting(CloneConfig.Area.DISCUSSION_BOARD, "excludeStarterPosts");
            } else {
                this.removeSetting(CloneConfig.Area.DISCUSSION_BOARD, "excludeStarterPosts");
            }
        }
    }

    private void overrideConfigIncludedObjectsMap() {
        HashMap<CloneConfig.Area, Set<String>> overridenIncludeObjectMap = new HashMap<CloneConfig.Area, Set<String>>();
        overridenIncludeObjectMap.putAll(this._cloneConfig.getIncludeObjectMap());
        this._cloneConfig.setIncludeObjectMap(overridenIncludeObjectMap);
    }

    private void removeSetting(CloneConfig.Area area, String settingName) {
        Set<String> strings = this._cloneConfig.getIncludedObjects(area);
        if (CollectionUtils.notEmpty(strings)) {
            strings.remove(settingName);
        }
    }

    private void addSetting(CloneConfig.Area area, String settingName) {
        this._cloneConfig.includeObject(area, settingName);
    }

    private static class OverriddenSettingLookup {
        private static final String SNAPSHOT_OVERRIDDEN_VALUES_MAP_KEY = "snapshotOverriddenValuesMap";

        private OverriddenSettingLookup() {
        }

        public static EnumMap<OverriddenSetting, Object> getExistingOverriddenValuesMap(BbAttributes bbAttributes) {
            return (EnumMap)bbAttributes.getObject(SNAPSHOT_OVERRIDDEN_VALUES_MAP_KEY);
        }

        public static EnumMap<OverriddenSetting, Object> getOverriddenValuesMap(BbAttributes bbAttributes) {
            EnumMap<OverriddenSetting, Object> overriddenValuesMap = OverriddenSettingLookup.getExistingOverriddenValuesMap(bbAttributes);
            if (overriddenValuesMap == null) {
                overriddenValuesMap = new EnumMap(OverriddenSetting.class);
                OverriddenSettingLookup.saveOverriddenValuesMap(bbAttributes, overriddenValuesMap);
            }
            return overriddenValuesMap;
        }

        public static void saveOverriddenValuesMap(BbAttributes bbAttributes, EnumMap<OverriddenSetting, Object> overriddenValuesMap) {
            bbAttributes.setObject(SNAPSHOT_OVERRIDDEN_VALUES_MAP_KEY, overriddenValuesMap);
        }

        public static void clearOverriddenValuesMap(BbAttributes bbAttributes) {
            bbAttributes.removeBbAttribute(SNAPSHOT_OVERRIDDEN_VALUES_MAP_KEY);
        }
    }
}

